/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.graalvm.visualvm.lib.jfluid.heap.Field;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayInstance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveArrayInstance;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveType;
import org.graalvm.visualvm.lib.jfluid.heap.Type;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

public class TruffleFrame {
    private static final String TRUFFLE_FRAME_FQN = "com.oracle.truffle.api.impl.DefaultVirtualFrame";
    private static final String COMPILER_FRAME_NOBOX_FQN = "org.graalvm.compiler.truffle.FrameWithoutBoxing";
    private static final String ENT_COMPILER_FRAME_NOBOX_FQN = "com.oracle.graal.truffle.FrameWithoutBoxing";
    private static final String COMPILER_FRAME_NOBOX1_FQN = "org.graalvm.compiler.truffle.runtime.FrameWithoutBoxing";
    private static final String COMPILER_FRAME_BOX_FQN = "org.graalvm.compiler.truffle.FrameWithBoxing";
    private static final String ENT_COMPILER_FRAME_BOX_FQN = "com.oracle.graal.truffle.FrameWithBoxing";
    private static final String COMPILER_FRAME_BOX1_FQN = "org.graalvm.compiler.truffle.runtime.FrameWithBoxing";
    private static final String ARG_PREFIX = "arg";
    private static final String LOCAL_UNDEFINED = "undefined";
    private static final byte OBJECT_TAG = 0;
    private static final byte ILLEGAL_TAG = 1;
    private static final byte LONG_TAG = 2;
    private static final byte INT_TAG = 3;
    private static final byte DOUBLE_TAG = 4;
    private static final byte FLOAT_TAG = 5;
    private static final byte BOOLEAN_TAG = 6;
    private static final byte BYTE_TAG = 7;
    private List<FieldValue> values = Collections.EMPTY_LIST;
    private List<FieldValue> localValues = Collections.EMPTY_LIST;
    private boolean isTruffleFrame;

    public TruffleFrame(Instance truffleFrame) {
        if (TruffleFrame.isTruffleFrameSubClass(truffleFrame)) {
            List<Instance> locals = this.getObjectArray(truffleFrame, "locals");
            List<String> primitiveLocals = this.getPrimitiveArray(truffleFrame, "primitiveLocals");
            List<Instance> arguments = this.getObjectArray(truffleFrame, "arguments");
            Instance slotArr = TruffleFrame.getValueofFields(truffleFrame, "descriptor", "slots");
            List<Instance> slots = this.getObjectArray(slotArr, "elementData");
            Instance defaultValue = TruffleFrame.getValueofFields(truffleFrame, "descriptor", "defaultValue");
            if (locals != null && arguments != null && slots != null) {
                Instance[] frameSlots = this.createFrameSlots(slots, locals.size());
                ArrayList<FieldValue> vals = new ArrayList<FieldValue>(arguments.size() + locals.size());
                ArrayList<FieldValue> locs = new ArrayList<FieldValue>(locals.size());
                this.createArguments(truffleFrame, arguments, vals);
                this.createLocals(truffleFrame, locals, primitiveLocals, frameSlots, defaultValue, locs);
                vals.addAll(locs);
                this.values = Collections.unmodifiableList(vals);
                this.localValues = Collections.unmodifiableList(locs);
                this.isTruffleFrame = true;
            }
        }
    }

    public List<FieldValue> getFieldValues() {
        return this.values;
    }

    public List<FieldValue> getLocalFieldValues() {
        return this.localValues;
    }

    public boolean isTruffleFrame() {
        return this.isTruffleFrame;
    }

    private static boolean isTruffleFrameSubClass(Instance truffleFrame) {
        return TruffleFrame.isSubClassOf(truffleFrame, TRUFFLE_FRAME_FQN) || TruffleFrame.isSubClassOf(truffleFrame, COMPILER_FRAME_NOBOX_FQN) || TruffleFrame.isSubClassOf(truffleFrame, COMPILER_FRAME_NOBOX1_FQN) || TruffleFrame.isSubClassOf(truffleFrame, ENT_COMPILER_FRAME_NOBOX_FQN) || TruffleFrame.isSubClassOf(truffleFrame, COMPILER_FRAME_BOX_FQN) || TruffleFrame.isSubClassOf(truffleFrame, COMPILER_FRAME_BOX1_FQN) || TruffleFrame.isSubClassOf(truffleFrame, ENT_COMPILER_FRAME_BOX_FQN);
    }

    private static boolean isSubClassOf(Instance i, String superClassName) {
        if (i != null) {
            for (JavaClass superCls = i.getJavaClass(); superCls != null; superCls = superCls.getSuperClass()) {
                if (!superCls.getName().equals(superClassName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isTruffleFrame(Instance truffleFrame) {
        return TruffleFrame.isTruffleFrameSubClass(truffleFrame);
    }

    private static Instance getValueofFields(Instance instance, String ... fields) {
        if (instance != null) {
            for (String field : fields) {
                Object val = instance.getValueOfField(field);
                if (val == null || !(val instanceof Instance)) {
                    return null;
                }
                instance = (Instance)val;
            }
        }
        return instance;
    }

    private List<Instance> getObjectArray(Instance instance, String field) {
        Object localsInst = instance.getValueOfField(field);
        if (localsInst instanceof ObjectArrayInstance) {
            return ((ObjectArrayInstance)localsInst).getValues();
        }
        return null;
    }

    private List<String> getPrimitiveArray(Instance instance, String field) {
        Object localsInst = instance.getValueOfField(field);
        if (localsInst instanceof PrimitiveArrayInstance) {
            return ((PrimitiveArrayInstance)localsInst).getValues();
        }
        return null;
    }

    private void createArguments(Instance truffleFrame, List<Instance> arguments, List<FieldValue> values) {
        for (int i = 0; i < arguments.size(); ++i) {
            values.add(new TruffleObjectField(truffleFrame, arguments.get(i), ARG_PREFIX + i));
        }
    }

    private void createLocals(Instance truffleFrame, List<Instance> locals, List<String> primitiveLocals, Instance[] frameSlots, Instance defaultValue, List<FieldValue> values) {
        for (int i = 0; i < locals.size(); ++i) {
            Instance frameSlot = frameSlots[i];
            Instance nameInst = (Instance)frameSlot.getValueOfField("identifier");
            String name = this.getDetails(nameInst);
            Type type = this.getVauleType(frameSlot);
            if (ObjType.OBJECT.equals(type)) {
                values.add(new TruffleObjectField(truffleFrame, locals.get(i), name));
                continue;
            }
            if (primitiveLocals != null) {
                String value = this.convertValue(primitiveLocals.get(i), type);
                values.add(new TruffleField(truffleFrame, value, name, type));
                continue;
            }
            Instance val = locals.get(i);
            if (val.equals(defaultValue)) {
                values.add(new TruffleField(truffleFrame, LOCAL_UNDEFINED, name, type));
                continue;
            }
            String value = this.getDetails(val);
            values.add(new TruffleField(truffleFrame, value, name, type));
        }
    }

    private Instance[] createFrameSlots(List<Instance> slots, int size) {
        Instance[] names = new Instance[size];
        for (int i = 0; i < size; ++i) {
            Instance frameSlot = slots.get(i);
            Integer index = (Integer)frameSlot.getValueOfField("index");
            names[index.intValue()] = frameSlot;
        }
        return names;
    }

    private Type getVauleType(Instance frameSlot) {
        Instance kind = (Instance)frameSlot.getValueOfField("kind");
        byte tag = (Byte)kind.getValueOfField("tag");
        switch (tag) {
            case 0: {
                return ObjType.OBJECT;
            }
            case 1: {
                return ObjType.OBJECT;
            }
            case 2: {
                return PType.LONG;
            }
            case 3: {
                return PType.INT;
            }
            case 4: {
                return PType.DOUBLE;
            }
            case 5: {
                return PType.FLOAT;
            }
            case 6: {
                return PType.BOOLEAN;
            }
            case 7: {
                return PType.BYTE;
            }
        }
        throw new IllegalArgumentException("Unknown type:" + tag);
    }

    private String convertValue(String val, Type type) {
        if (!PType.LONG.equals(type)) {
            long originalLong = Long.parseLong(val);
            if (PType.INT.equals(type)) {
                return String.valueOf((int)originalLong);
            }
            if (PType.DOUBLE.equals(type)) {
                return String.valueOf(Double.longBitsToDouble(originalLong));
            }
            if (PType.FLOAT.equals(type)) {
                return String.valueOf(Float.intBitsToFloat((int)originalLong));
            }
            if (PType.BOOLEAN.equals(type)) {
                return String.valueOf((int)originalLong != 0);
            }
            if (PType.BYTE.equals(type)) {
                return String.valueOf((byte)originalLong);
            }
        }
        return val;
    }

    private String getDetails(Instance i) {
        if (i.getJavaClass().getName().startsWith("java.lang.")) {
            return DetailsUtils.getInstanceString((Instance)i, null);
        }
        return "N/A";
    }

    private static class PType
    implements PrimitiveType {
        static final PrimitiveType BOOLEAN = new PType("boolean");
        static final PrimitiveType CHAR = new PType("char");
        static final PrimitiveType FLOAT = new PType("float");
        static final PrimitiveType DOUBLE = new PType("double");
        static final PrimitiveType BYTE = new PType("byte");
        static final PrimitiveType SHORT = new PType("short");
        static final PrimitiveType INT = new PType("int");
        static final PrimitiveType LONG = new PType("long");
        private String name;

        PType(String n) {
            this.name = n;
        }

        public String getName() {
            return this.name;
        }
    }

    private static class ObjType
    implements Type {
        static final Type OBJECT = new ObjType();

        private ObjType() {
        }

        public String getName() {
            return "Object";
        }
    }

    private static class FrameField
    implements Field {
        private final JavaClass definingClass;
        private final String name;
        private final Type type;

        private FrameField(JavaClass cls, String n, Type t) {
            this.definingClass = cls;
            this.name = n;
            this.type = t;
        }

        public JavaClass getDeclaringClass() {
            return this.definingClass;
        }

        public String getName() {
            return this.name;
        }

        public boolean isStatic() {
            return false;
        }

        public Type getType() {
            return this.type;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FrameField) {
                FrameField ff = (FrameField)obj;
                return this.definingClass.equals(ff.definingClass) && this.name.equals(ff.name);
            }
            return false;
        }

        public int hashCode() {
            return 31 * this.definingClass.hashCode() + this.name.hashCode();
        }
    }

    private class TruffleObjectField
    extends TruffleField
    implements ObjectFieldValue {
        private final Instance instanceValue;

        private TruffleObjectField(Instance defI, Instance val, String name) {
            super(defI, val == null ? null : String.valueOf(val.getInstanceId()), name, ObjType.OBJECT);
            this.instanceValue = val;
        }

        public Instance getInstance() {
            return this.instanceValue;
        }
    }

    private class TruffleField
    implements FieldValue {
        private final Instance definingInstance;
        private final Field field;
        private final String value;

        private TruffleField(Instance defI, String val, String name, Type type) {
            this.definingInstance = defI;
            this.value = val;
            this.field = new FrameField(defI.getJavaClass(), name, type);
        }

        public Field getField() {
            return this.field;
        }

        public Instance getDefiningInstance() {
            return this.definingInstance;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TruffleField) {
                TruffleField tfv = (TruffleField)obj;
                return this.definingInstance.equals(tfv.definingInstance) && this.field.equals(tfv.field);
            }
            return false;
        }

        public int hashCode() {
            return 31 * this.definingInstance.hashCode() + this.field.hashCode();
        }
    }
}

