/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.model.RootNode;
import org.graalvm.visualvm.heapviewer.model.TextNode;
import org.graalvm.visualvm.heapviewer.truffle.Bundle;
import org.graalvm.visualvm.heapviewer.truffle.TruffleLanguage;
import org.graalvm.visualvm.heapviewer.truffle.TruffleLanguageHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObject;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObjectPropertyProvider;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObjectsWrapper;
import org.graalvm.visualvm.heapviewer.truffle.TruffleType;
import org.graalvm.visualvm.heapviewer.truffle.swing.LinkButton;
import org.graalvm.visualvm.heapviewer.ui.HeapViewPlugin;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.heapviewer.ui.TreeTableView;
import org.graalvm.visualvm.heapviewer.ui.TreeTableViewColumn;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.openide.util.NbPreferences;

public class TruffleObjectPropertyPlugin<O extends TruffleObject, T extends TruffleType<O>, F extends TruffleLanguageHeapFragment<O, T>, L extends TruffleLanguage<O, T, F>>
extends HeapViewPlugin {
    private static final TreeTableView.ColumnConfiguration CCONF_TYPE = new TreeTableView.ColumnConfiguration(DataType.COUNT, null, DataType.COUNT, SortOrder.DESCENDING, Boolean.FALSE);
    private static final TreeTableView.ColumnConfiguration CCONF_OBJECT = new TreeTableView.ColumnConfiguration(null, DataType.COUNT, DataType.NAME, SortOrder.UNSORTED, null);
    private final TruffleObjectPropertyProvider<O, T, F, L, ? extends Object> provider;
    private final Heap heap;
    private HeapViewerNode selected;
    private volatile boolean mergedRequest;
    private final TreeTableView objectsView;
    private JComponent component;

    public TruffleObjectPropertyPlugin(String name, String description, Icon icon, String viewID, HeapContext context, HeapViewerActions actions, final TruffleObjectPropertyProvider<O, T, F, L, ? extends Object> provider) {
        super(name, description, icon);
        TreeTableViewColumn[] treeTableViewColumnArray;
        this.provider = provider;
        final String mergedPropertiesKey = provider.getMergedPropertiesKey();
        this.heap = context.getFragment().getHeap();
        if (mergedPropertiesKey == null) {
            TreeTableViewColumn[] treeTableViewColumnArray2 = new TreeTableViewColumn[5];
            treeTableViewColumnArray2[0] = new TreeTableViewColumn.Name(this.heap);
            treeTableViewColumnArray2[1] = new TreeTableViewColumn.LogicalValue(this.heap);
            treeTableViewColumnArray2[2] = new TreeTableViewColumn.OwnSize(this.heap, false, false);
            treeTableViewColumnArray2[3] = new TreeTableViewColumn.RetainedSize(this.heap, false, false);
            treeTableViewColumnArray = treeTableViewColumnArray2;
            treeTableViewColumnArray2[4] = new TreeTableViewColumn.ObjectID(this.heap);
        } else {
            TreeTableViewColumn[] treeTableViewColumnArray3 = new TreeTableViewColumn[6];
            treeTableViewColumnArray3[0] = new TreeTableViewColumn.Name(this.heap);
            treeTableViewColumnArray3[1] = new TreeTableViewColumn.LogicalValue(this.heap);
            treeTableViewColumnArray3[2] = new TreeTableViewColumn.Count(this.heap, true, true);
            treeTableViewColumnArray3[3] = new TreeTableViewColumn.OwnSize(this.heap, false, false);
            treeTableViewColumnArray3[4] = new TreeTableViewColumn.RetainedSize(this.heap, false, false);
            treeTableViewColumnArray = treeTableViewColumnArray3;
            treeTableViewColumnArray3[5] = new TreeTableViewColumn.ObjectID(this.heap);
        }
        TreeTableViewColumn[] columns = treeTableViewColumnArray;
        this.objectsView = new TreeTableView(viewID, context, actions, columns){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected HeapViewerNode[] computeData(RootNode root, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
                HeapViewerNode[] heapViewerNodeArray;
                HeapViewerNode[] nodes;
                TruffleObjectsWrapper wrapper;
                HeapViewerNode _selected;
                if (TruffleObjectPropertyPlugin.this.mergedRequest) {
                    return HeapViewerNode.NO_NODES;
                }
                TreeTableView treeTableView = TruffleObjectPropertyPlugin.this.objectsView;
                synchronized (treeTableView) {
                    _selected = TruffleObjectPropertyPlugin.this.selected;
                }
                if (_selected == null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!CCONF_OBJECT.equals(TruffleObjectPropertyPlugin.this.objectsView.getCurrentColumnConfiguration())) {
                                TruffleObjectPropertyPlugin.this.objectsView.configureColumns(CCONF_OBJECT);
                            }
                        }
                    });
                    return new HeapViewerNode[]{new TextNode(TruffleObjectPropertyPlugin.this.noSelectionString())};
                }
                TruffleObjectsWrapper truffleObjectsWrapper = wrapper = mergedPropertiesKey == null ? null : (TruffleObjectsWrapper)HeapViewerNode.getValue((HeapViewerNode)_selected, TruffleObjectsWrapper.DATA_TYPE, (Heap)heap);
                if (wrapper != null) {
                    nodes = provider.getNodes(wrapper, _selected, heap, viewID, viewFilter, dataTypes, sortOrders, progress);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!CCONF_TYPE.equals(TruffleObjectPropertyPlugin.this.objectsView.getCurrentColumnConfiguration())) {
                                TruffleObjectPropertyPlugin.this.objectsView.configureColumns(CCONF_TYPE);
                            }
                        }
                    });
                } else {
                    Object selectedO = provider.getObject(_selected, heap);
                    nodes = selectedO != null ? provider.getNodes(selectedO, (HeapViewerNode)root, heap, viewID, viewFilter, dataTypes, sortOrders, progress) : new HeapViewerNode[]{new TextNode(TruffleObjectPropertyPlugin.this.noSelectionString())};
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!CCONF_OBJECT.equals(TruffleObjectPropertyPlugin.this.objectsView.getCurrentColumnConfiguration())) {
                                TruffleObjectPropertyPlugin.this.objectsView.configureColumns(CCONF_OBJECT);
                            }
                        }
                    });
                }
                if (nodes == null || nodes.length == 0) {
                    HeapViewerNode[] heapViewerNodeArray2 = new HeapViewerNode[1];
                    heapViewerNodeArray = heapViewerNodeArray2;
                    heapViewerNodeArray2[0] = new TextNode(Bundle.TruffleObjectPropertyPlugin_NoItems(provider.getName()));
                } else {
                    heapViewerNodeArray = nodes;
                }
                return heapViewerNodeArray;
            }

            protected void populatePopup(HeapViewerNode node, JPopupMenu popup) {
                if (provider.getMergedPropertiesKey() == null) {
                    return;
                }
                if (popup.getComponentCount() > 0) {
                    popup.addSeparator();
                }
                popup.add(new JCheckBoxMenuItem(Bundle.TruffleObjectPropertyPlugin_AutoShowMergedSwitch(provider.getName()), TruffleObjectPropertyPlugin.this.isAutoMerge()){

                    @Override
                    protected void fireActionPerformed(ActionEvent event) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                TruffleObjectPropertyPlugin.this.setAutoMerge(this.isSelected());
                            }
                        });
                    }
                });
            }
        };
    }

    private String noSelectionString() {
        return this.provider.getMergedPropertiesKey() == null ? Bundle.TruffleObjectPropertyPlugin_NoSelection() : Bundle.TruffleObjectPropertyPlugin_NoSelectionEx();
    }

    private void showObjectsView() {
        JComponent c = this.objectsView.getComponent();
        if (c.isVisible()) {
            return;
        }
        c.setVisible(true);
        this.component.removeAll();
        this.component.add((Component)c, "Center");
        this.mergedRequest = false;
        this.component.invalidate();
        this.component.revalidate();
        this.component.repaint();
    }

    private void showMergedView() {
        JComponent c = this.objectsView.getComponent();
        if (!c.isVisible()) {
            return;
        }
        c.setVisible(false);
        this.component.removeAll();
        String name = this.provider.getName();
        String _name = name.substring(0, 1).toUpperCase() + name.substring(1);
        JButton jb = new JButton(Bundle.TruffleObjectPropertyPlugin_ComputeMergedReferencesLbl(_name), this.getIcon()){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                TruffleObjectPropertyPlugin.this.showObjectsView();
                TruffleObjectPropertyPlugin.this.objectsView.reloadView();
            }
        };
        jb.setIconTextGap(jb.getIconTextGap() + 2);
        jb.setToolTipText(Bundle.TruffleObjectPropertyPlugin_ComputeMergedReferencesTtp(name));
        Insets margin = jb.getMargin();
        if (margin != null) {
            jb.setMargin(new Insets(margin.top + 3, margin.left + 3, margin.bottom + 3, margin.right + 3));
        }
        LinkButton lb = new LinkButton(Bundle.TruffleObjectPropertyPlugin_AutoComputeMergedReferencesLbl(_name)){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                TruffleObjectPropertyPlugin.this.setAutoMerge(true);
                TruffleObjectPropertyPlugin.this.showObjectsView();
                TruffleObjectPropertyPlugin.this.objectsView.reloadView();
            }
        };
        lb.setToolTipText(Bundle.TruffleObjectPropertyPlugin_AutoComputeMergedReferencesTtp(name));
        JPanel p = new JPanel(new GridBagLayout());
        p.setOpaque(false);
        GridBagConstraints g = new GridBagConstraints();
        g.fill = 2;
        g.gridy = 0;
        p.add((Component)jb, g);
        g = new GridBagConstraints();
        g.fill = 2;
        g.gridy = 1;
        g.insets = new Insets(10, 0, 0, 0);
        p.add((Component)lb, g);
        this.component.add(p);
        this.mergedRequest = true;
        this.component.invalidate();
        this.component.revalidate();
        this.component.repaint();
    }

    protected JComponent createComponent() {
        this.component = new JPanel(new BorderLayout());
        this.component.setOpaque(true);
        this.component.setBackground(UIUtils.getProfilerResultsBackground());
        this.objectsView.getComponent().setVisible(false);
        this.showObjectsView();
        return this.component;
    }

    protected void closed() {
        this.objectsView.closed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nodeSelected(HeapViewerNode node, boolean adjusting) {
        TreeTableView treeTableView = this.objectsView;
        synchronized (treeTableView) {
            if (Objects.equals(this.selected, node)) {
                return;
            }
            this.selected = node;
        }
        if (this.selected != null && this.provider.getMergedPropertiesKey() != null && !this.isAutoMerge() && HeapViewerNode.getValue((HeapViewerNode)this.selected, TruffleObjectsWrapper.DATA_TYPE, (Heap)this.heap) != null) {
            this.showMergedView();
        } else {
            this.showObjectsView();
        }
        this.objectsView.reloadView();
    }

    private boolean isAutoMerge() {
        return NbPreferences.root().getBoolean(this.provider.getMergedPropertiesKey(), false);
    }

    private void setAutoMerge(boolean value) {
        NbPreferences.root().putBoolean(this.provider.getMergedPropertiesKey(), value);
    }
}

