/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.details;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.graalvm.visualvm.heapviewer.truffle.details.Bundle;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.results.ExportDataDumper;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.api.ExportAction;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.api.StringDecoder;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.openide.util.RequestProcessor;

public final class SourceSectionView
extends DetailsProvider.View
implements Scrollable,
ExportAction.ExportProvider {
    private static final int MAX_PREVIEW_LENGTH = 256;
    private static final int MAX_ARRAY_ITEMS = 1000;
    private static final int MAX_CHARARRAY_ITEMS = 500000;
    private static final String TRUNCATED = Bundle.SourceSectionView_Truncated();
    private JTextPane view;
    private JButton all;
    private String caption;
    private Heap heap;
    private List<String> values;
    private byte coder = (byte)-1;
    private int offset;
    private int count;
    private int sectionOffset;
    private int sectionSize;
    private boolean chararray;
    private String instanceIdentifier;

    public SourceSectionView(String className, Instance instance, int offset, int size, Heap heap) {
        super(instance, heap);
        this.sectionOffset = offset;
        this.sectionSize = size;
    }

    protected void computeView(Instance instance, Heap h) {
        this.offset = DetailsUtils.getIntFieldValue((Instance)instance, (String)"offset", (int)0);
        this.count = DetailsUtils.getIntFieldValue((Instance)instance, (String)"count", (int)-1);
        this.coder = DetailsUtils.getByteFieldValue((Instance)instance, (String)"coder", (byte)-1);
        this.values = DetailsUtils.getPrimitiveArrayFieldValues((Instance)instance, (String)"value");
        this.caption = Bundle.SourceSectionView_Value();
        this.heap = h;
        this.instanceIdentifier = instance.getJavaClass().getName() + "#" + instance.getInstanceNumber();
        final String preview = this.getString(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SourceSectionView.this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                SourceSectionView.this.setBackground(UIUtils.getProfilerResultsBackground());
                SourceSectionView.this.setOpaque(true);
                SourceSectionView.this.removeAll();
                JLabel l = new JLabel(SourceSectionView.this.caption, 10);
                l.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
                SourceSectionView.this.add(l, "North");
                SourceSectionView.this.view = new JTextPane();
                l.setLabelFor(SourceSectionView.this.view);
                SourceSectionView.this.view.setEditable(false);
                SourceSectionView.this.view.setText(preview);
                try {
                    SourceSectionView.this.view.setCaretPosition(0);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                JScrollPane viewScroll = new JScrollPane(SourceSectionView.this.view, 20, 31);
                SourceSectionView.this.add(viewScroll, "Center");
                JPanel p = new JPanel(new GridBagLayout());
                p.setOpaque(false);
                SourceSectionView.this.all = SourceSectionView.htmlButton(Bundle.SourceSectionView_All(), SourceSectionView.this.count < (SourceSectionView.this.chararray ? 500000 : 1000), new Runnable(){

                    @Override
                    public void run() {
                        SourceSectionView.this.showAll();
                    }
                });
                GridBagConstraints c = new GridBagConstraints();
                c.gridx = 0;
                c.insets = new Insets(3, 0, 0, 5);
                p.add((Component)SourceSectionView.this.all, c);
                JButton save = SourceSectionView.htmlButton(Bundle.SourceSectionView_Save(), !preview.isEmpty(), new Runnable(){

                    @Override
                    public void run() {
                        new ExportAction((ExportAction.ExportProvider)SourceSectionView.this).actionPerformed(null);
                    }
                });
                c = new GridBagConstraints();
                c.gridx = 1;
                c.insets = new Insets(3, 0, 0, 0);
                p.add((Component)save, c);
                JPanel f = new JPanel(null);
                f.setOpaque(false);
                c = new GridBagConstraints();
                c.gridx = 2;
                c.weightx = 1.0;
                c.fill = 2;
                p.add((Component)f, c);
                SourceSectionView.this.add(p, "South");
                SourceSectionView.this.revalidate();
                SourceSectionView.this.doLayout();
                SourceSectionView.this.repaint();
                if (SourceSectionView.this.sectionSize == -1) {
                    SourceSectionView.this.showAll();
                }
            }
        });
    }

    private void showAll() {
        this.all.setEnabled(false);
        this.view.setEnabled(false);
        new RequestProcessor("SourceSection Details").post(new Runnable(){

            @Override
            public void run() {
                String _preview = null;
                try {
                    _preview = SourceSectionView.this.getString(false);
                }
                catch (OutOfMemoryError e) {
                    ProfilerDialogs.displayError((String)Bundle.SourceSectionView_OutOfMemory());
                    return;
                }
                final String preview = _preview;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SourceSectionView.this.view.setText(preview);
                            SourceSectionView.this.view.setEnabled(true);
                            SimpleAttributeSet attrs = new SimpleAttributeSet();
                            StyleConstants.setBackground(attrs, Color.YELLOW);
                            StyledDocument doc = SourceSectionView.this.view.getStyledDocument();
                            doc.setCharacterAttributes(SourceSectionView.this.sectionOffset, SourceSectionView.this.sectionSize, attrs, false);
                            SourceSectionView.this.view.setCaretPosition(Math.min(SourceSectionView.this.sectionOffset + 64, preview.length()));
                        }
                        catch (OutOfMemoryError e) {
                            ProfilerDialogs.displayError((String)Bundle.SourceSectionView_OutOfMemory());
                        }
                    }
                });
            }
        });
    }

    private String getString(boolean preview) {
        int firstValue;
        if (this.values == null) {
            return "";
        }
        StringDecoder decoder = new StringDecoder(this.heap, this.coder, this.values);
        int valuesCount = this.count < 0 ? decoder.getStringLength() - this.offset : this.count;
        int estimatedSize = (int)Math.min((long)valuesCount * 2L, (long)(256 + TRUNCATED.length()));
        StringBuilder value = new StringBuilder(estimatedSize);
        int lastValue = this.offset + (preview ? this.sectionOffset + this.sectionSize - 1 : valuesCount - 1);
        for (int i = firstValue = this.offset + (preview ? this.sectionOffset : 0); i <= lastValue; ++i) {
            value.append(decoder.getValueAt(i));
            if (!preview || value.length() < 256) continue;
            value.append(TRUNCATED);
            break;
        }
        return value.toString();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return null;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        Container parent = this.getParent();
        if (parent == null || !(parent instanceof JViewport)) {
            return 50;
        }
        return (int)((float)((JViewport)parent).getHeight() * 0.95f);
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        Container parent = this.getParent();
        if (parent == null || !(parent instanceof JViewport)) {
            return false;
        }
        return this.getMinimumSize().height < ((JViewport)parent).getHeight();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        Container parent = this.getParent();
        if (parent == null || !(parent instanceof JViewport)) {
            return false;
        }
        return this.getMinimumSize().width < ((JViewport)parent).getWidth();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    private static JButton htmlButton(final String text, boolean enabled, final Runnable handler) {
        JButton b = new JButton(){

            @Override
            public void setEnabled(boolean b) {
                this.setText(!b ? text : "<html><nobr><a href='#'>" + text + "</a></nobr></html>");
                this.setCursor(!b ? Cursor.getDefaultCursor() : Cursor.getPredefinedCursor(12));
                super.setEnabled(b);
            }
        };
        b.setOpaque(false);
        b.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        b.setBorderPainted(false);
        b.setContentAreaFilled(false);
        b.setEnabled(enabled);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                handler.run();
            }
        });
        return b;
    }

    public void exportData(int exportedFileType, ExportDataDumper eDD) {
        String comma = ",";
        if (this.values != null) {
            StringDecoder decoder = new StringDecoder(this.heap, this.coder, this.values);
            int valuesCount = this.count < 0 ? decoder.getStringLength() - this.offset : this.count;
            int lastValue = this.offset + valuesCount - 1;
            block5: for (int i = this.offset; i <= lastValue; ++i) {
                String value = decoder.getValueAt(i);
                switch (exportedFileType) {
                    case 1: {
                        eDD.dumpData((CharSequence)value);
                        eDD.dumpData((CharSequence)comma);
                        continue block5;
                    }
                    case 2: {
                        eDD.dumpData((CharSequence)value);
                        continue block5;
                    }
                    case 3: {
                        byte b = Byte.valueOf(value);
                        eDD.dumpByte(b);
                        continue block5;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
        }
        eDD.close();
    }

    public String getViewName() {
        return this.instanceIdentifier;
    }

    public boolean hasRawData() {
        return false;
    }

    public boolean hasBinaryData() {
        return false;
    }

    public boolean hasText() {
        return true;
    }

    public boolean isExportable() {
        return this.hasText() || this.hasBinaryData() || this.hasRawData();
    }
}

