/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.javaext;

import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.SortOrder;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.model.RootNode;
import org.graalvm.visualvm.heapviewer.model.TextNode;
import org.graalvm.visualvm.heapviewer.truffle.TruffleLanguageHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.javaext.Bundle;
import org.graalvm.visualvm.heapviewer.ui.HeapViewPlugin;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.heapviewer.ui.TreeTableView;
import org.graalvm.visualvm.heapviewer.ui.TreeTableViewColumn;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;

public class TruffleJavaViewPlugin
extends HeapViewPlugin {
    private final Heap heap;
    private Instance selected;
    private final TreeTableView objectsView;

    public TruffleJavaViewPlugin(HeapContext context, HeapViewerActions actions) {
        super(Bundle.TruffleJavaViewPlugin_Name(), Bundle.TruffleJavaViewPlugin_Description(), Icons.getIcon((String)"GeneralIcons.JavaProcess"));
        this.heap = context.getFragment().getHeap();
        this.objectsView = new TreeTableView("java_objects_truffleext", context, actions, TreeTableViewColumn.instancesPlain((Heap)this.heap)){

            protected HeapViewerNode[] computeData(RootNode root, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
                InstanceNode instanceNode = TruffleJavaViewPlugin.this.selected == null ? null : new InstanceNode(TruffleJavaViewPlugin.this.selected);
                InstanceNode result = instanceNode == null ? new TextNode(Bundle.TruffleJavaViewPlugin_NoSelection()) : instanceNode;
                return new HeapViewerNode[]{result};
            }

            protected void childrenChanged() {
                HeapViewerNode[] children;
                for (HeapViewerNode child : children = this.getRoot().getChildren()) {
                    this.expandNode(child);
                }
                if (children.length > 0 && (children = children[0].getChildren()).length > 0 && children[0] instanceof TextNode) {
                    this.expandNode(children[0]);
                }
            }
        };
    }

    protected JComponent createComponent() {
        return this.objectsView.getComponent();
    }

    protected void closed() {
        this.objectsView.closed();
    }

    protected void nodeSelected(HeapViewerNode node, boolean adjusting) {
        Instance selectedInstance;
        Instance instance = selectedInstance = node == null ? null : (Instance)HeapViewerNode.getValue((HeapViewerNode)node, (DataType)DataType.INSTANCE, (Heap)this.heap);
        if (Objects.equals(this.selected, selectedInstance)) {
            return;
        }
        this.selected = selectedInstance;
        this.objectsView.reloadView();
    }

    public static class Provider
    extends HeapViewPlugin.Provider {
        public HeapViewPlugin createPlugin(HeapContext context, HeapViewerActions actions, String viewID) {
            if (TruffleLanguageHeapFragment.isTruffleHeap(context)) {
                return new TruffleJavaViewPlugin(context, actions);
            }
            return null;
        }
    }
}

