/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.ruby;

import java.util.Iterator;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObjectLanguageHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.Bundle;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.RubyLanguage;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.RubyObject;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.RubyType;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;

class RubyHeapFragment
extends DynamicObjectLanguageHeapFragment<RubyObject, RubyType> {
    static final String RUBY_LANG_ID = "org.truffleruby.language.RubyObjectType";
    static final String RUBY_LANG_ID1 = "org.truffleruby.interop.RubyObjectType";
    private static final String RUBY_HEAP_ID = "ruby_heap";
    private final String rubyLangId;

    RubyHeapFragment(RubyLanguage language, JavaClass rubyLangIdClass, Instance langID, Heap heap) {
        super(RUBY_HEAP_ID, Bundle.RubyHeapFragment_Name(), RubyHeapFragment.fragmentDescription(langID, heap), language, heap);
        this.rubyLangId = rubyLangIdClass.getName();
    }

    static RubyHeapFragment fromContext(HeapContext context) {
        return (RubyHeapFragment)context.getFragment();
    }

    @Override
    public Iterator<Instance> getInstancesIterator() {
        return this.languageInstancesIterator(this.rubyLangId);
    }

    @Override
    public Iterator<RubyObject> getObjectsIterator() {
        return this.languageObjectsIterator(this.rubyLangId);
    }

    static boolean isRubyHeap(HeapContext context) {
        return RUBY_HEAP_ID.equals(context.getFragment().getID());
    }
}

