/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.generic.model.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.graalvm.visualvm.jfr.generic.model.impl.DisplayableSupport;
import org.graalvm.visualvm.jfr.generic.model.impl.JFRGenericClass;
import org.graalvm.visualvm.jfr.generic.model.impl.JFRGenericStackTrace;
import org.graalvm.visualvm.jfr.generic.model.impl.JFRGenericThread;
import org.graalvm.visualvm.jfr.model.JFRClass;
import org.graalvm.visualvm.jfr.model.JFREvent;
import org.graalvm.visualvm.jfr.model.JFRPropertyNotAvailableException;
import org.graalvm.visualvm.jfr.model.JFRStackTrace;
import org.graalvm.visualvm.jfr.model.JFRThread;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.IMCThread;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.item.IAccessorKey;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.JfrAttributes;

abstract class JFRGenericEvent
extends JFREvent {
    final IItem item;

    protected JFRGenericEvent(IItem event) {
        this.item = event;
    }

    protected abstract IQuantity getEventStartTime() throws JFRPropertyNotAvailableException;

    protected abstract IQuantity getEventEndTime() throws JFRPropertyNotAvailableException;

    protected abstract IQuantity getEventDuration() throws JFRPropertyNotAvailableException;

    protected abstract Object getThreadThread() throws JFRPropertyNotAvailableException;

    public Instant getInstant(String key) throws JFRPropertyNotAvailableException {
        switch (key) {
            case "eventTime": 
            case "startTime": {
                IQuantity startTime = this.getEventStartTime();
                return startTime == null ? null : JFRGenericEvent.instantFromQuantity(startTime);
            }
            case "endTime": {
                IQuantity endTime = this.getEventStartTime();
                return endTime == null ? null : JFRGenericEvent.instantFromQuantity(endTime);
            }
        }
        Object time = this.getValue(key);
        if (time instanceof IQuantity) {
            return JFRGenericEvent.instantFromQuantity((IQuantity)time);
        }
        if (time == null) {
            return null;
        }
        throw new JFRPropertyNotAvailableException("No instant value available: " + key);
    }

    private static Instant instantFromQuantity(IQuantity quantity) {
        try {
            long nanos = quantity.longValueIn(UnitLookup.EPOCH_NS);
            return Instant.EPOCH.plusNanos(nanos);
        }
        catch (QuantityConversionException ex1) {
            try {
                long millis = quantity.longValueIn(UnitLookup.EPOCH_MS);
                return Instant.ofEpochMilli(millis);
            }
            catch (QuantityConversionException ex3) {
                long seconds = quantity.clampedLongValueIn(UnitLookup.EPOCH_S);
                return Instant.ofEpochSecond(seconds);
            }
        }
    }

    public Duration getDuration(String key) throws JFRPropertyNotAvailableException {
        if ("eventDuration".equals(key)) {
            IQuantity duration = this.getEventDuration();
            return duration == null ? null : JFRGenericEvent.durationFromQuantity(duration);
        }
        Object duration = this.getValue(key);
        if (duration instanceof IQuantity) {
            return JFRGenericEvent.durationFromQuantity((IQuantity)duration);
        }
        if (duration == null) {
            return null;
        }
        throw new JFRPropertyNotAvailableException("No duration value available: " + key);
    }

    private static Duration durationFromQuantity(IQuantity quantity) {
        try {
            long nanos = quantity.longValueIn(UnitLookup.NANOSECOND);
            return Duration.ofNanos(nanos);
        }
        catch (QuantityConversionException ex1) {
            try {
                long millis = quantity.longValueIn(UnitLookup.MILLISECOND);
                return Duration.ofMillis(millis);
            }
            catch (QuantityConversionException ex3) {
                long seconds = quantity.clampedLongValueIn(UnitLookup.SECOND);
                return Duration.ofSeconds(seconds);
            }
        }
    }

    public JFRClass getClass(String key) throws JFRPropertyNotAvailableException {
        Object value = this.getValue(key);
        if (value instanceof IMCType) {
            return new JFRGenericClass((IMCType)value);
        }
        if (value == null) {
            return null;
        }
        throw new JFRPropertyNotAvailableException("No class value available: " + key);
    }

    public JFRThread getThread(String key) throws JFRPropertyNotAvailableException {
        Object thread;
        block5 : switch (key) {
            case "eventThread": {
                IMCThread eventThread = (IMCThread)this.getValue(JfrAttributes.EVENT_THREAD);
                return eventThread == null ? null : new JFRGenericThread(eventThread);
            }
            case "sampledThread": {
                switch (this.item.getType().getIdentifier()) {
                    case "jdk.ExecutionSample": 
                    case "jdk.NativeMethodSample": {
                        IMCThread sampledThread = (IMCThread)this.getValue(JfrAttributes.EVENT_THREAD);
                        return sampledThread == null ? null : new JFRGenericThread(sampledThread);
                    }
                }
                thread = this.getValue(key);
                break;
            }
            case "thread": {
                switch (this.item.getType().getIdentifier()) {
                    case "jdk.ThreadStart": 
                    case "jdk.ThreadEnd": {
                        thread = this.getThreadThread();
                        break block5;
                    }
                    case "jdk.ThreadAllocationStatistics": {
                        IMCThread sampledThread = (IMCThread)this.getValue(JfrAttributes.EVENT_THREAD);
                        return sampledThread == null ? null : new JFRGenericThread(sampledThread);
                    }
                }
                thread = this.getValue(key);
                break;
            }
            default: {
                thread = this.getValue(key);
            }
        }
        if (thread instanceof IMCThread) {
            return new JFRGenericThread((IMCThread)thread);
        }
        if (thread == null) {
            return null;
        }
        throw new JFRPropertyNotAvailableException("No thread value available: " + key);
    }

    public JFRStackTrace getStackTrace(String key) throws JFRPropertyNotAvailableException {
        if ("eventStackTrace".equals(key)) {
            IMCStackTrace stackTrace = (IMCStackTrace)this.getValue(JfrAttributes.EVENT_STACKTRACE);
            return stackTrace == null ? null : new JFRGenericStackTrace(stackTrace);
        }
        Object stackTrace = this.getValue(key);
        if (stackTrace instanceof IMCStackTrace) {
            return new JFRGenericStackTrace((IMCStackTrace)stackTrace);
        }
        if (stackTrace == null) {
            return null;
        }
        throw new JFRPropertyNotAvailableException("No stacktrace value available: " + key);
    }

    public Object getValue(String key) throws JFRPropertyNotAvailableException {
        key = key.replace('.', ':');
        IType<?> type = this.item.getType();
        for (IAccessorKey<?> accessor : type.getAccessorKeys().keySet()) {
            if (!key.equals(accessor.getIdentifier())) continue;
            return type.getAccessor(accessor).getMember(this.item);
        }
        throw new JFRPropertyNotAvailableException("No value available: " + key);
    }

    protected <T> T getValue(IAttribute<T> attribute) throws JFRPropertyNotAvailableException {
        IType<?> type = this.item.getType();
        IMemberAccessor accessor = type.getAccessor(attribute.getKey());
        if (accessor == null) {
            throw new JFRPropertyNotAvailableException("No value available: " + attribute.getIdentifier());
        }
        return (T)accessor.getMember(this.item);
    }

    public List<Comparable> getDisplayableValues(boolean includeExperimental) {
        IType<?> type = this.item.getType();
        ArrayList<Comparable> values = new ArrayList<Comparable>();
        Iterator<IAccessorKey> keys = DisplayableSupport.displayableAccessorKeys(type, includeExperimental);
        while (keys.hasNext()) {
            IAccessorKey key = keys.next();
            Object value = type.getAccessor(key).getMember(this.item);
            if (value instanceof Comparable) {
                values.add((Comparable)value);
                continue;
            }
            values.add((Comparable)((Object)key.getContentType().getDefaultFormatter().format(value)));
        }
        return values;
    }

    public int hashCode() {
        return this.item.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof JFRGenericEvent ? this.item.equals(((JFRGenericEvent)((Object)o)).item) : false;
    }

    public String toString() {
        return this.item.toString() + " [" + this.item.getType().getAccessorKeys().keySet() + "]";
    }

    static final class V1
    extends JFRGenericEvent {
        V1(IItem event) {
            super(event);
        }

        @Override
        protected IQuantity getEventStartTime() throws JFRPropertyNotAvailableException {
            return (IQuantity)this.getValue(JfrAttributes.START_TIME);
        }

        @Override
        protected IQuantity getEventEndTime() throws JFRPropertyNotAvailableException {
            return this.getEventStartTime().add(this.getEventDuration());
        }

        @Override
        protected IQuantity getEventDuration() throws JFRPropertyNotAvailableException {
            return (IQuantity)this.getValue(JfrAttributes.DURATION);
        }

        @Override
        protected Object getThreadThread() throws JFRPropertyNotAvailableException {
            return this.getValue("thread");
        }
    }

    static final class V0
    extends JFRGenericEvent {
        V0(IItem event) {
            super(event);
        }

        @Override
        protected IQuantity getEventStartTime() throws JFRPropertyNotAvailableException {
            IType<?> type = this.item.getType();
            IMemberAccessor startAccessor = type.getAccessor(JfrAttributes.START_TIME.getKey());
            return startAccessor != null ? (IQuantity)startAccessor.getMember(this.item) : this.getEventEndTime();
        }

        @Override
        protected IQuantity getEventEndTime() throws JFRPropertyNotAvailableException {
            return (IQuantity)this.getValue(JfrAttributes.END_TIME);
        }

        @Override
        protected IQuantity getEventDuration() throws JFRPropertyNotAvailableException {
            IQuantity startTime = (IQuantity)this.getValue(JfrAttributes.START_TIME);
            if (startTime == null) {
                throw new JFRPropertyNotAvailableException("No start time to compute event duration");
            }
            IQuantity endTime = (IQuantity)this.getValue(JfrAttributes.END_TIME);
            if (endTime == null) {
                throw new JFRPropertyNotAvailableException("No end time to compute event duration");
            }
            return endTime.subtract(startTime);
        }

        @Override
        protected Object getThreadThread() throws JFRPropertyNotAvailableException {
            return this.getValue("javalangthread");
        }
    }
}

