/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.profiler;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.instrumentation.AllocationEvent;
import com.oracle.truffle.api.instrumentation.AllocationEventFilter;
import com.oracle.truffle.api.instrumentation.AllocationListener;
import com.oracle.truffle.api.instrumentation.ContextsListener;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.tools.profiler.HeapSummary;
import com.oracle.truffle.tools.profiler.impl.HeapMonitorInstrument;
import java.io.Closeable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.graalvm.polyglot.Engine;

public final class HeapMonitor
implements Closeable {
    private static final long CLEAN_INTERVAL = 200L;
    private static final ThreadLocal<Boolean> RECURSIVE = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private final TruffleInstrument.Env env;
    private final ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
    private final ConcurrentLinkedQueue<ObjectWeakReference> newReferences = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<ObjectWeakReference> processedReferences = new ConcurrentLinkedQueue();
    private final Map<LanguageInfo, Map<String, HeapSummary>> summaryData = new LinkedHashMap<LanguageInfo, Map<String, HeapSummary>>();
    private Thread referenceThread;
    private volatile boolean closed;
    private boolean collecting;
    private EventBinding<?> activeBinding;
    private final Map<LanguageInfo, LanguageInfo> initializedLanguages = new ConcurrentHashMap<LanguageInfo, LanguageInfo>();

    private HeapMonitor(TruffleInstrument.Env env) {
        this.env = env;
        env.getInstrumenter().attachContextsListener(new ContextsListener(){

            public void onContextCreated(TruffleContext context) {
            }

            public void onLanguageContextCreated(TruffleContext context, LanguageInfo language) {
            }

            public void onLanguageContextInitialized(TruffleContext context, LanguageInfo language) {
                HeapMonitor.this.initializedLanguages.put(language, language);
            }

            public void onLanguageContextFinalized(TruffleContext context, LanguageInfo language) {
                HeapMonitor.this.initializedLanguages.remove(language);
            }

            public void onLanguageContextDisposed(TruffleContext context, LanguageInfo language) {
            }

            public void onContextClosed(TruffleContext context) {
            }
        }, true);
    }

    private void resetMonitor() {
        assert (Thread.holdsLock(this));
        if (this.activeBinding != null) {
            this.activeBinding.dispose();
            this.activeBinding = null;
        }
        if (this.closed && this.referenceThread != null && this.referenceThread.isAlive()) {
            this.referenceThread.interrupt();
            this.referenceThread = null;
        }
        if (!this.collecting || this.closed) {
            return;
        }
        this.clearData();
        if (this.referenceThread == null) {
            this.referenceThread = new Thread(() -> {
                while (!this.closed) {
                    this.cleanReferenceQueue();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            });
            this.referenceThread.setName("HeapMonitor Cleanup");
            this.referenceThread.setDaemon(true);
        }
        this.referenceThread.start();
        this.activeBinding = this.env.getInstrumenter().attachAllocationListener(AllocationEventFilter.ANY, (AllocationListener)new Listener());
    }

    public static HeapMonitor find(Engine engine) {
        return HeapMonitorInstrument.getMonitor(engine);
    }

    public synchronized void setCollecting(boolean collecting) {
        if (this.closed) {
            throw new IllegalStateException("Heap Allocation Monitor is already closed.");
        }
        if (this.collecting != collecting) {
            this.collecting = collecting;
            this.resetMonitor();
        }
    }

    public synchronized boolean isCollecting() {
        return this.collecting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeapSummary takeSummary() {
        if (this.closed) {
            throw new IllegalStateException("Heap Allocation Monitor is already closed.");
        }
        HeapSummary totalSummary = new HeapSummary();
        this.cleanReferenceQueue();
        this.processNewReferences();
        Map<LanguageInfo, Map<String, HeapSummary>> map = this.summaryData;
        synchronized (map) {
            for (Map<String, HeapSummary> languages : this.summaryData.values()) {
                for (HeapSummary summaryEntry : languages.values()) {
                    totalSummary.add(summaryEntry);
                }
            }
        }
        return totalSummary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<LanguageInfo, Map<String, HeapSummary>> takeMetaObjectSummary() {
        this.cleanReferenceQueue();
        this.processNewReferences();
        Map<LanguageInfo, Map<String, HeapSummary>> map = this.summaryData;
        synchronized (map) {
            LinkedHashMap<LanguageInfo, Map<String, HeapSummary>> languageMap = new LinkedHashMap<LanguageInfo, Map<String, HeapSummary>>(this.summaryData);
            for (Map.Entry entry : languageMap.entrySet()) {
                LinkedHashMap copyLanguageMap = new LinkedHashMap((Map)entry.getValue());
                for (Map.Entry entry2 : copyLanguageMap.entrySet()) {
                    entry2.setValue(new HeapSummary((HeapSummary)entry2.getValue()));
                }
                entry.setValue(Collections.unmodifiableMap(copyLanguageMap));
            }
            return Collections.unmodifiableMap(languageMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNewReferences() {
        Map<LanguageInfo, Map<String, HeapSummary>> map = this.summaryData;
        synchronized (map) {
            ObjectWeakReference reference;
            while ((reference = this.newReferences.poll()) != null) {
                HeapSummary summary = HeapMonitor.getSummary(this.summaryData, reference.language, reference.metaObject);
                ++summary.totalInstances;
                ++summary.aliveInstances;
                long bytesDiff = reference.computeBytesDiff();
                summary.totalBytes += bytesDiff;
                summary.aliveBytes += bytesDiff;
                reference.processed = true;
                this.processedReferences.add(reference);
            }
        }
    }

    private static HeapSummary getSummary(Map<LanguageInfo, Map<String, HeapSummary>> summaries, LanguageInfo language, String metaObject) {
        Map summaryMap = summaries.computeIfAbsent(language, k -> new LinkedHashMap());
        return summaryMap.computeIfAbsent(metaObject, k -> new HeapSummary());
    }

    static Map<String, Object>[] toMap(Map<LanguageInfo, Map<String, HeapSummary>> summaries) {
        ArrayList heapHisto = new ArrayList(summaries.size());
        for (Map.Entry<LanguageInfo, Map<String, HeapSummary>> objectsByLanguage : summaries.entrySet()) {
            LanguageInfo language = objectsByLanguage.getKey();
            for (Map.Entry<String, HeapSummary> objectsByMetaObject : objectsByLanguage.getValue().entrySet()) {
                HeapSummary mi = objectsByMetaObject.getValue();
                HashMap<String, Object> metaObjMap = new HashMap<String, Object>();
                metaObjMap.put("language", language.getId());
                metaObjMap.put("name", objectsByMetaObject.getKey());
                metaObjMap.put("totalInstances", mi.getTotalInstances());
                metaObjMap.put("totalBytes", mi.getTotalBytes());
                metaObjMap.put("aliveInstances", mi.getAliveInstances());
                metaObjMap.put("aliveBytes", mi.getAliveBytes());
                heapHisto.add(metaObjMap);
            }
        }
        return heapHisto.toArray(new Map[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearData() {
        Map<LanguageInfo, Map<String, HeapSummary>> map = this.summaryData;
        synchronized (map) {
            this.newReferences.clear();
            this.summaryData.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasData() {
        if (!this.newReferences.isEmpty()) {
            return true;
        }
        Map<LanguageInfo, Map<String, HeapSummary>> map = this.summaryData;
        synchronized (map) {
            if (!this.summaryData.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        this.resetMonitor();
        this.clearData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanReferenceQueue() {
        ObjectWeakReference reference = (ObjectWeakReference)this.referenceQueue.poll();
        if (reference == null) {
            return;
        }
        HashSet<ObjectWeakReference> collectedNewReferences = new HashSet<ObjectWeakReference>();
        HashSet<ObjectWeakReference> collectedProcessedReferences = new HashSet<ObjectWeakReference>();
        Map<LanguageInfo, Map<String, HeapSummary>> map = this.summaryData;
        synchronized (map) {
            do {
                HeapSummary counter = HeapMonitor.getSummary(this.summaryData, reference.language, reference.metaObject);
                long bytesDiff = reference.computeBytesDiff();
                if (reference.processed) {
                    --counter.aliveInstances;
                    counter.aliveBytes -= bytesDiff;
                    collectedProcessedReferences.add(reference);
                    continue;
                }
                ++counter.totalInstances;
                counter.totalBytes += bytesDiff;
                collectedNewReferences.add(reference);
            } while ((reference = (ObjectWeakReference)this.referenceQueue.poll()) != null);
            this.newReferences.removeAll(collectedNewReferences);
            this.processedReferences.removeAll(collectedProcessedReferences);
        }
    }

    static {
        HeapMonitorInstrument.setFactory(HeapMonitor::new);
    }

    private static final class ObjectWeakReference
    extends WeakReference<Object> {
        final String metaObject;
        final LanguageInfo language;
        final long oldSize;
        final long newSize;
        boolean processed;

        ObjectWeakReference(Object obj, ReferenceQueue<Object> rq, LanguageInfo language, String metaObject, long oldSize, long newSize) {
            super(obj, rq);
            this.language = language;
            this.metaObject = metaObject;
            this.oldSize = oldSize;
            this.newSize = newSize;
        }

        long computeBytesDiff() {
            long newSize = this.newSize == Long.MIN_VALUE ? 0L : this.newSize;
            long oldSize = this.oldSize == Long.MIN_VALUE ? 0L : this.oldSize;
            return newSize - oldSize;
        }
    }

    private class Listener
    implements AllocationListener {
        private Listener() {
        }

        public void onEnter(AllocationEvent event) {
        }

        @CompilerDirectives.TruffleBoundary
        public void onReturnValue(AllocationEvent event) {
            String metaInfo;
            Object object = event.getValue();
            if (object == null) {
                return;
            }
            LanguageInfo language = event.getLanguage();
            if (HeapMonitor.this.initializedLanguages.containsKey(language) && (metaInfo = this.getMetaObjectString(language, object)) != null) {
                HeapMonitor.this.newReferences.add(new ObjectWeakReference(object, HeapMonitor.this.referenceQueue, language, metaInfo.intern(), event.getOldSize(), event.getNewSize()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getMetaObjectString(LanguageInfo language, Object value) {
            boolean recursive;
            boolean bl = recursive = RECURSIVE.get() == Boolean.TRUE;
            if (!recursive) {
                RECURSIVE.set(Boolean.TRUE);
                try {
                    String toString;
                    Object metaObject = HeapMonitor.this.env.findMetaObject(language, value);
                    if (metaObject != null && (toString = HeapMonitor.this.env.toString(language, metaObject)) != null) {
                        String string = toString;
                        return string;
                    }
                    String string = "Unknown";
                    return string;
                }
                finally {
                    RECURSIVE.set(Boolean.FALSE);
                }
            }
            return null;
        }
    }
}

