/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.LoadSourceEvent;
import com.oracle.truffle.api.instrumentation.LoadSourceListener;
import com.oracle.truffle.api.instrumentation.SourceFilter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.tools.agentscript.impl.AgentException;
import com.oracle.truffle.tools.agentscript.impl.AgentExecutionNode;
import com.oracle.truffle.tools.agentscript.impl.AgentType;
import com.oracle.truffle.tools.agentscript.impl.RootNameFilter;
import com.oracle.truffle.tools.agentscript.impl.SourceEventObject;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;

@ExportLibrary(value=InteropLibrary.class)
final class AgentObject
implements TruffleObject {
    private final TruffleInstrument.Env env;
    private final AtomicBoolean initializationFinished;
    private Object closeFn;

    AgentObject(TruffleInstrument.Env env) {
        this.env = env;
        this.initializationFinished = new AtomicBoolean(false);
    }

    @ExportMessage
    boolean isMemberReadable(String member) {
        return true;
    }

    @ExportMessage
    static boolean hasMembers(AgentObject obj) {
        return true;
    }

    @ExportMessage
    static Object getMembers(AgentObject obj, boolean includeInternal) {
        return new Object[0];
    }

    @ExportMessage
    Object readMember(String name) throws UnknownIdentifierException {
        switch (name) {
            case "version": {
                return "0.1";
            }
        }
        throw UnknownIdentifierException.create((String)name);
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    static Object invokeMember(AgentObject obj, String member, final Object[] args, final @CachedLibrary(limit="0") InteropLibrary interop) throws UnknownIdentifierException, UnsupportedMessageException {
        Instrumenter instrumenter = obj.env.getInstrumenter();
        block3 : switch (member) {
            case "on": {
                AgentType type = AgentType.find((String)args[0]);
                switch (type) {
                    case SOURCE: {
                        SourceFilter filter = SourceFilter.newBuilder().sourceIs((Predicate)((Object)new ExcludeAgentScriptsFilter(obj.initializationFinished))).includeInternal(false).build();
                        instrumenter.attachLoadSourceListener(filter, new LoadSourceListener(){

                            public void onLoad(LoadSourceEvent event) {
                                try {
                                    interop.execute(args[1], new Object[]{new SourceEventObject(event.getSource())});
                                }
                                catch (InteropException ex) {
                                    throw AgentException.raise((Exception)((Object)ex));
                                }
                            }
                        }, true);
                        break block3;
                    }
                    case ENTER: {
                        CompilerDirectives.transferToInterpreter();
                        SourceSectionFilter filter = AgentObject.createFilter(obj, args);
                        instrumenter.attachExecutionEventFactory(filter, AgentExecutionNode.factory(obj.env, args[1], null));
                        break block3;
                    }
                    case RETURN: {
                        CompilerDirectives.transferToInterpreter();
                        SourceSectionFilter filter = AgentObject.createFilter(obj, args);
                        instrumenter.attachExecutionEventFactory(filter, AgentExecutionNode.factory(obj.env, null, args[1]));
                        break block3;
                    }
                    case CLOSE: {
                        obj.registerOnClose(args[1]);
                        break block3;
                    }
                }
                throw new IllegalStateException();
            }
            default: {
                throw UnknownIdentifierException.create((String)member);
            }
        }
        return obj;
    }

    private static SourceSectionFilter createFilter(AgentObject obj, Object[] args) throws IllegalArgumentException, UnsupportedMessageException {
        SourceSectionFilter.Builder builder = SourceSectionFilter.newBuilder().sourceIs((SourceSectionFilter.SourcePredicate)new ExcludeAgentScriptsFilter(obj.initializationFinished)).includeInternal(false);
        ArrayList<Class<StandardTags.RootBodyTag>> allTags = new ArrayList<Class<StandardTags.RootBodyTag>>();
        if (args.length > 2) {
            Object config;
            InteropLibrary iop = (InteropLibrary)InteropLibrary.getFactory().getUncached();
            if (AgentObject.isSet(iop, config = args[2], "expressions")) {
                allTags.add(StandardTags.ExpressionTag.class);
            }
            if (AgentObject.isSet(iop, config, "statements")) {
                allTags.add(StandardTags.StatementTag.class);
            }
            if (AgentObject.isSet(iop, config, "roots")) {
                allTags.add(StandardTags.RootBodyTag.class);
            }
            try {
                Object rootNameFilter = iop.readMember(config, "rootNameFilter");
                if (rootNameFilter != null && !iop.isNull(rootNameFilter)) {
                    if (!iop.isExecutable(rootNameFilter)) {
                        throw new IllegalArgumentException("rootNameFilter has to be a function!");
                    }
                    builder.rootNameIs((Predicate)new RootNameFilter(rootNameFilter, obj.initializationFinished));
                }
            }
            catch (UnknownIdentifierException unknownIdentifierException) {
                // empty catch block
            }
        }
        if (allTags.isEmpty()) {
            throw new IllegalArgumentException("No elements specified to listen to for execution listener. Need to specify at least one element kind: expressions, statements or roots.");
        }
        builder.tagIs(allTags.toArray(new Class[0]));
        SourceSectionFilter filter = builder.build();
        return filter;
    }

    @ExportMessage
    static boolean isMemberInvocable(AgentObject obj, String member) {
        return false;
    }

    void initializationFinished() {
        this.initializationFinished.set(true);
    }

    @CompilerDirectives.TruffleBoundary
    void onClosed() {
        if (this.closeFn == null) {
            return;
        }
        InteropLibrary iop = (InteropLibrary)InteropLibrary.getFactory().getUncached();
        try {
            iop.execute(this.closeFn, new Object[0]);
        }
        catch (InteropException ex) {
            throw AgentException.raise((Exception)((Object)ex));
        }
        finally {
            this.closeFn = null;
        }
    }

    void registerOnClose(Object fn) {
        this.closeFn = fn;
    }

    private static boolean isSet(InteropLibrary iop, Object obj, String property) {
        try {
            Object value = iop.readMember(obj, property);
            return Boolean.TRUE.equals(value);
        }
        catch (UnknownIdentifierException ex) {
            return false;
        }
        catch (InteropException ex) {
            throw AgentException.raise((Exception)((Object)ex));
        }
    }

    private static final class ExcludeAgentScriptsFilter
    implements SourceSectionFilter.SourcePredicate {
        private final AtomicBoolean initializationFinished;
        private final Map<Source, Boolean> ignore = new WeakHashMap<Source, Boolean>();

        ExcludeAgentScriptsFilter(AtomicBoolean initializationFinished) {
            this.initializationFinished = initializationFinished;
        }

        public boolean test(Source source) {
            if (this.initializationFinished.get()) {
                return !Boolean.TRUE.equals(this.ignore.get(source));
            }
            this.ignore.put(source, Boolean.TRUE);
            return false;
        }
    }
}

