/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.tools.agentscript.impl.ArrayObject;

@ExportLibrary(value=InteropLibrary.class)
final class EventContextObject
implements TruffleObject {
    private final EventContext context;
    @CompilerDirectives.CompilationFinal
    private String name;

    EventContextObject(EventContext context) {
        this.context = context;
    }

    @ExportMessage
    static boolean hasMembers(EventContextObject obj) {
        return true;
    }

    @ExportMessage
    static Object getMembers(EventContextObject obj, boolean includeInternal) {
        return ArrayObject.array("name");
    }

    @ExportMessage
    static Object readMember(EventContextObject obj, String member) throws UnknownIdentifierException {
        switch (member) {
            case "name": {
                if (obj.name == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    obj.name = obj.context.getInstrumentedNode().getRootNode().getName();
                }
                return obj.name;
            }
        }
        throw UnknownIdentifierException.create((String)member);
    }

    @ExportMessage
    static boolean isMemberReadable(EventContextObject obj, String member) {
        return "name".equals(member);
    }
}

