/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.host.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.net.InetAddress;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.graalvm.visualvm.core.properties.PropertiesPanel;
import org.graalvm.visualvm.core.properties.PropertiesProvider;
import org.graalvm.visualvm.host.Host;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class GeneralPropertiesProvider
extends PropertiesProvider<Host> {
    public GeneralPropertiesProvider() {
        super(NbBundle.getMessage(GeneralPropertiesProvider.class, (String)"LBL_HostProperties"), NbBundle.getMessage(GeneralPropertiesProvider.class, (String)"DESCR_HostProperties"), Integer.MIN_VALUE, 50);
    }

    public PropertiesPanel createPanel(final Host dataSource) {
        PropertiesPanel panel = new PropertiesPanel();
        panel.setLayout((LayoutManager)new BorderLayout());
        final JTextArea textArea = new JTextArea(){

            @Override
            public Dimension getMinimumSize() {
                Dimension prefSize = this.getPreferredSize();
                Dimension minSize = super.getMinimumSize();
                prefSize.width = 0;
                if (minSize.height < prefSize.height) {
                    return prefSize;
                }
                return minSize;
            }
        };
        textArea.setBorder(BorderFactory.createEmptyBorder());
        textArea.setOpaque(false);
        if (UIManager.getLookAndFeel().getID().equals("Nimbus")) {
            textArea.setBackground(new Color(0, 0, 0, 0));
        }
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        String resolving = NbBundle.getMessage(GeneralPropertiesProvider.class, (String)"LBL_Resolving");
        GeneralPropertiesProvider.updateProperties(textArea, resolving, resolving);
        textArea.setMinimumSize(new Dimension(1, 1));
        panel.add((Component)textArea, (Object)"Center");
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                InetAddress address = dataSource.getInetAddress();
                final String hostname = address.getCanonicalHostName();
                final String ip = address.getHostAddress();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GeneralPropertiesProvider.updateProperties(textArea, hostname, ip);
                    }
                });
            }
        });
        return panel;
    }

    private static void updateProperties(JTextArea textArea, String hostname, String ip) {
        String dnsName = NbBundle.getMessage(GeneralPropertiesProvider.class, (String)"LBL_DnsName");
        String ipAddress = NbBundle.getMessage(GeneralPropertiesProvider.class, (String)"LBL_IpAddress");
        textArea.setText(dnsName + " " + hostname + "\n" + ipAddress + " " + ip);
        textArea.setCaretPosition(0);
    }

    public boolean supportsDataSource(Host dataSource) {
        return dataSource != null;
    }

    public void propertiesDefined(PropertiesPanel panel, Host dataSource) {
    }

    public void propertiesChanged(PropertiesPanel panel, Host dataSource) {
    }

    public void propertiesCancelled(PropertiesPanel panel, Host dataSource) {
    }
}

