/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.debug.Breakpoint;
import com.oracle.truffle.api.debug.DebugException;
import com.oracle.truffle.api.debug.DebugScope;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.debug.ValueInteropList;
import com.oracle.truffle.api.debug.ValuePropertiesCollection;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;

public abstract class DebugValue {
    static final InteropLibrary INTEROP = InteropLibrary.getFactory().getUncached();
    final LanguageInfo preferredLanguage;

    abstract Object get() throws DebugException;

    DebugValue(LanguageInfo preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

    public abstract void set(DebugValue var1) throws DebugException;

    public abstract void set(Object var1) throws DebugException;

    public abstract <T> T as(Class<T> var1) throws DebugException;

    public abstract String asString() throws DebugException;

    public abstract String getName();

    public abstract boolean isReadable();

    public abstract boolean hasReadSideEffects();

    public abstract boolean hasWriteSideEffects();

    public abstract boolean isWritable();

    public abstract boolean isInternal();

    public DebugScope getScope() {
        return null;
    }

    public final boolean isNull() {
        if (!this.isReadable()) {
            return false;
        }
        Object value = this.get();
        return INTEROP.isNull(value);
    }

    public final List<Breakpoint> getRootInstanceBreakpoints() {
        final Object value = this.get();
        final List[] breakpoints = new List[]{null};
        this.getSession().visitBreakpoints(new Consumer<Breakpoint>(){

            @Override
            public void accept(Breakpoint b) {
                if (b.getRootInstance() == value) {
                    if (breakpoints[0] == null) {
                        breakpoints[0] = new LinkedList();
                    }
                    breakpoints[0].add(b);
                }
            }
        });
        return breakpoints[0] != null ? breakpoints[0] : Collections.emptyList();
    }

    public final Collection<DebugValue> getProperties() throws DebugException {
        if (!this.isReadable()) {
            return null;
        }
        Object value = this.get();
        try {
            return DebugValue.getProperties(value, this.getSession(), this.resolveLanguage(), null);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable ex) {
            throw new DebugException(this.getSession(), ex, this.resolveLanguage(), null, true, null);
        }
    }

    static ValuePropertiesCollection getProperties(Object value, DebuggerSession session, LanguageInfo language, DebugScope scope) {
        if (INTEROP.hasMembers(value)) {
            Object keys;
            try {
                keys = INTEROP.getMembers(value, true);
            }
            catch (UnsupportedMessageException e) {
                return null;
            }
            return new ValuePropertiesCollection(session, language, value, keys, scope);
        }
        return null;
    }

    public final DebugValue getProperty(String name) throws DebugException {
        if (!this.isReadable()) {
            return null;
        }
        Object value = this.get();
        if (value != null) {
            try {
                if (!INTEROP.isMemberExisting(value, name)) {
                    return null;
                }
                return new ObjectMemberValue(this.getSession(), this.resolveLanguage(), null, value, name);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable ex) {
                throw new DebugException(this.getSession(), ex, this.resolveLanguage(), null, true, null);
            }
        }
        return null;
    }

    public final boolean isArray() throws DebugException {
        if (!this.isReadable()) {
            return false;
        }
        return INTEROP.hasArrayElements(this.get());
    }

    public final List<DebugValue> getArray() throws DebugException {
        if (!this.isReadable()) {
            return null;
        }
        Object value = this.get();
        if (INTEROP.hasArrayElements(value)) {
            return new ValueInteropList(this.getSession(), this.resolveLanguage(), value);
        }
        return null;
    }

    final LanguageInfo resolveLanguage() {
        LanguageInfo languageInfo = this.preferredLanguage != null ? this.preferredLanguage : (this.getScope() != null && this.getScope().getLanguage() != null ? this.getScope().getLanguage() : this.getOriginalLanguage());
        return languageInfo;
    }

    public final DebugValue getMetaObject() throws DebugException {
        if (!this.isReadable()) {
            return null;
        }
        Object obj = this.get();
        if (obj == null) {
            return null;
        }
        TruffleInstrument.Env env = this.getDebugger().getEnv();
        LanguageInfo languageInfo = this.resolveLanguage();
        if (languageInfo != null) {
            try {
                obj = env.findMetaObject(languageInfo, obj);
                if (obj != null) {
                    return new HeapValue(this.getSession(), languageInfo, null, obj, true);
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable ex) {
                throw new DebugException(this.getSession(), ex, languageInfo, null, true, null);
            }
        }
        return null;
    }

    public final SourceSection getSourceLocation() throws DebugException {
        if (!this.isReadable()) {
            return null;
        }
        Object obj = this.get();
        if (obj == null) {
            return null;
        }
        TruffleInstrument.Env env = this.getDebugger().getEnv();
        LanguageInfo languageInfo = this.resolveLanguage();
        if (languageInfo != null) {
            try {
                SourceSection location = env.findSourceLocation(languageInfo, obj);
                return this.getSession().resolveSection(location);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable ex) {
                throw new DebugException(this.getSession(), ex, languageInfo, null, true, null);
            }
        }
        return null;
    }

    public final boolean canExecute() throws DebugException {
        if (!this.isReadable()) {
            return false;
        }
        Object value = this.get();
        try {
            return INTEROP.isExecutable(value);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable ex) {
            throw new DebugException(this.getSession(), ex, this.resolveLanguage(), null, true, null);
        }
    }

    public final DebugValue execute(DebugValue ... arguments) throws DebugException {
        Object value = this.get();
        Object[] args = new Object[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            args[i] = arguments[i].get();
        }
        try {
            Object retValue = INTEROP.execute(value, args);
            return new HeapValue(this.getSession(), null, retValue);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable ex) {
            throw new DebugException(this.getSession(), ex, this.resolveLanguage(), null, true, null);
        }
    }

    public final LanguageInfo getOriginalLanguage() throws DebugException {
        if (!this.isReadable()) {
            return null;
        }
        Object obj = this.get();
        if (obj == null) {
            return null;
        }
        return this.getDebugger().getEnv().findLanguage(obj);
    }

    public final DebugValue asInLanguage(LanguageInfo language) {
        if (this.preferredLanguage == language) {
            return this;
        }
        return this.createAsInLanguage(language);
    }

    abstract DebugValue createAsInLanguage(LanguageInfo var1);

    abstract DebuggerSession getSession();

    final Debugger getDebugger() {
        return this.getSession().getDebugger();
    }

    public String toString() {
        return "DebugValue(name=" + this.getName() + ", value = " + (this.isReadable() ? this.as(String.class) : "<not readable>") + ")";
    }

    private static void checkPrimitive(Object value) {
        Class<?> clazz;
        if (value == null || (clazz = value.getClass()) != Byte.class && clazz != Short.class && clazz != Integer.class && clazz != Long.class && clazz != Float.class && clazz != Double.class && clazz != Character.class && clazz != Boolean.class && clazz != String.class) {
            throw new IllegalArgumentException(value + " is not primitive.");
        }
    }

    static final class ArrayElementValue
    extends AbstractDebugValue {
        private final Object array;
        private final long index;
        private final DebugScope scope;

        ArrayElementValue(DebuggerSession session, LanguageInfo preferredLanguage, DebugScope scope, Object array, long index) {
            super(session, preferredLanguage);
            this.array = array;
            this.index = index;
            this.scope = scope;
        }

        @Override
        Object get() {
            this.checkValid();
            try {
                return INTEROP.readArrayElement(this.array, this.index);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable ex) {
                throw new DebugException(this.getSession(), ex, this.resolveLanguage(), null, true, null);
            }
        }

        @Override
        public String getName() {
            return String.valueOf(this.index);
        }

        @Override
        public boolean isReadable() {
            this.checkValid();
            return INTEROP.isArrayElementReadable(this.array, this.index);
        }

        @Override
        public boolean isWritable() {
            this.checkValid();
            return INTEROP.isArrayElementWritable(this.array, this.index);
        }

        @Override
        public boolean hasReadSideEffects() {
            this.checkValid();
            return false;
        }

        @Override
        public boolean hasWriteSideEffects() {
            this.checkValid();
            return false;
        }

        @Override
        public boolean isInternal() {
            this.checkValid();
            return false;
        }

        @Override
        public DebugScope getScope() {
            this.checkValid();
            return this.scope;
        }

        @Override
        public void set(DebugValue value) {
            this.checkValid();
            try {
                INTEROP.writeArrayElement(this.array, this.index, value.get());
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable ex) {
                throw new DebugException(this.getSession(), ex, this.resolveLanguage(), null, true, null);
            }
        }

        @Override
        public void set(Object primitiveValue) {
            this.checkValid();
            DebugValue.checkPrimitive(primitiveValue);
            try {
                INTEROP.writeArrayElement(this.array, this.index, primitiveValue);
            }
            catch (Throwable ex) {
                throw new DebugException(this.getSession(), ex, this.resolveLanguage(), null, true, null);
            }
        }

        @Override
        DebugValue createAsInLanguage(LanguageInfo language) {
            return new ArrayElementValue(this.session, language, this.scope, this.array, this.index);
        }

        private void checkValid() {
            if (this.scope != null) {
                this.scope.verifyValidState();
            }
        }
    }

    static final class ObjectMemberValue
    extends AbstractDebugValue {
        private final Object object;
        private final String member;
        private final DebugScope scope;

        ObjectMemberValue(DebuggerSession session, LanguageInfo preferredLanguage, DebugScope scope, Object object, String member) {
            super(session, preferredLanguage);
            this.object = object;
            this.member = member;
            this.scope = scope;
        }

        @Override
        Object get() {
            this.checkValid();
            try {
                return INTEROP.readMember(this.object, this.member);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable ex) {
                throw new DebugException(this.getSession(), ex, this.resolveLanguage(), null, true, null);
            }
        }

        @Override
        public String getName() {
            return String.valueOf(this.member);
        }

        @Override
        public boolean isReadable() {
            this.checkValid();
            return INTEROP.isMemberReadable(this.object, this.member);
        }

        @Override
        public boolean isWritable() {
            this.checkValid();
            return INTEROP.isMemberWritable(this.object, this.member);
        }

        @Override
        public boolean hasReadSideEffects() {
            this.checkValid();
            return INTEROP.hasMemberReadSideEffects(this.object, this.member);
        }

        @Override
        public boolean hasWriteSideEffects() {
            this.checkValid();
            return INTEROP.hasMemberWriteSideEffects(this.object, this.member);
        }

        @Override
        public boolean isInternal() {
            this.checkValid();
            return INTEROP.isMemberInternal(this.object, this.member);
        }

        @Override
        public DebugScope getScope() {
            this.checkValid();
            return this.scope;
        }

        @Override
        public void set(DebugValue value) {
            this.checkValid();
            try {
                INTEROP.writeMember(this.object, this.member, value.get());
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable ex) {
                throw new DebugException(this.getSession(), ex, this.resolveLanguage(), null, true, null);
            }
        }

        @Override
        public void set(Object primitiveValue) {
            this.checkValid();
            DebugValue.checkPrimitive(primitiveValue);
            try {
                INTEROP.writeMember(this.object, this.member, primitiveValue);
            }
            catch (Throwable ex) {
                throw new DebugException(this.getSession(), ex, this.resolveLanguage(), null, true, null);
            }
        }

        @Override
        DebugValue createAsInLanguage(LanguageInfo language) {
            return new ObjectMemberValue(this.session, language, this.scope, this.object, this.member);
        }

        private void checkValid() {
            if (this.scope != null) {
                this.scope.verifyValidState();
            }
        }
    }

    static final class ObjectPropertyValue
    extends AbstractDebugValue {
        private final Object object;
        private final String member;
        private final DebugScope scope;

        ObjectPropertyValue(DebuggerSession session, LanguageInfo preferredLanguage, DebugScope scope, Object array, String member) {
            super(session, preferredLanguage);
            this.object = array;
            this.member = member;
            this.scope = scope;
        }

        @Override
        Object get() {
            this.checkValid();
            try {
                return INTEROP.readMember(this.object, this.member);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable ex) {
                throw new DebugException(this.getSession(), ex, this.resolveLanguage(), null, true, null);
            }
        }

        @Override
        public String getName() {
            return String.valueOf(this.member);
        }

        @Override
        public boolean isReadable() {
            this.checkValid();
            return INTEROP.isMemberReadable(this.object, this.member);
        }

        @Override
        public boolean isWritable() {
            this.checkValid();
            return INTEROP.isMemberWritable(this.object, this.member);
        }

        @Override
        public boolean hasReadSideEffects() {
            this.checkValid();
            return INTEROP.hasMemberReadSideEffects(this.object, this.member);
        }

        @Override
        public boolean hasWriteSideEffects() {
            this.checkValid();
            return INTEROP.hasMemberWriteSideEffects(this.object, this.member);
        }

        @Override
        public boolean isInternal() {
            this.checkValid();
            return INTEROP.isMemberInternal(this.object, this.member);
        }

        @Override
        public DebugScope getScope() {
            this.checkValid();
            return this.scope;
        }

        @Override
        public void set(DebugValue value) {
            this.checkValid();
            try {
                INTEROP.writeMember(this.object, this.member, value.get());
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable ex) {
                throw new DebugException(this.getSession(), ex, this.resolveLanguage(), null, true, null);
            }
        }

        @Override
        public void set(Object primitiveValue) {
            this.checkValid();
            DebugValue.checkPrimitive(primitiveValue);
            try {
                INTEROP.writeMember(this.object, this.member, primitiveValue);
            }
            catch (Throwable ex) {
                throw new DebugException(this.getSession(), ex, this.resolveLanguage(), null, true, null);
            }
        }

        @Override
        DebugValue createAsInLanguage(LanguageInfo language) {
            return new ObjectPropertyValue(this.session, language, this.scope, this.object, this.member);
        }

        private void checkValid() {
            if (this.scope != null) {
                this.scope.verifyValidState();
            }
        }
    }

    static class HeapValue
    extends AbstractDebugValue {
        private final String name;
        private final boolean isMeta;
        private Object value;

        HeapValue(DebuggerSession session, String name, Object value) {
            this(session, null, name, value);
        }

        HeapValue(DebuggerSession session, LanguageInfo preferredLanguage, String name, Object value) {
            this(session, preferredLanguage, name, value, false);
        }

        HeapValue(DebuggerSession session, LanguageInfo preferredLanguage, String name, Object value, boolean isMeta) {
            super(session, preferredLanguage);
            this.name = name;
            this.isMeta = isMeta;
            this.value = value;
        }

        @Override
        protected boolean isMeta() {
            return this.isMeta;
        }

        @Override
        Object get() {
            return this.value;
        }

        @Override
        public void set(DebugValue expression) {
            this.value = expression.get();
        }

        @Override
        public void set(Object primitiveValue) {
            DebugValue.checkPrimitive(primitiveValue);
            this.value = primitiveValue;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public boolean hasReadSideEffects() {
            return false;
        }

        @Override
        public boolean hasWriteSideEffects() {
            return false;
        }

        @Override
        public boolean isInternal() {
            return false;
        }

        @Override
        DebugValue createAsInLanguage(LanguageInfo language) {
            return new HeapValue(this.session, language, this.name, this.value, this.isMeta);
        }
    }

    static abstract class AbstractDebugValue
    extends DebugValue {
        final DebuggerSession session;

        AbstractDebugValue(DebuggerSession session, LanguageInfo preferredLanguage) {
            super(preferredLanguage);
            this.session = session;
        }

        @Override
        public final <T> T as(Class<T> clazz) throws DebugException {
            if (!this.isReadable()) {
                throw new IllegalStateException("Value is not readable");
            }
            try {
                if (clazz == String.class) {
                    LanguageInfo languageInfo;
                    Object val = this.get();
                    String stringValue = this.isMeta() && val instanceof String ? (String)val : ((languageInfo = this.resolveLanguage()) == null ? val.toString() : this.getDebugger().getEnv().toString(languageInfo, val));
                    return clazz.cast(stringValue);
                }
                if (clazz == Number.class || clazz == Boolean.class) {
                    return this.convertToPrimitive(clazz);
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable ex) {
                throw new DebugException(this.getSession(), ex, this.resolveLanguage(), null, true, null);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public String asString() throws DebugException {
            if (!this.isReadable()) {
                throw new IllegalStateException("Value is not readable");
            }
            try {
                Object val = this.get();
                if (INTEROP.isString(val)) {
                    return INTEROP.asString(val);
                }
                return null;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable ex) {
                throw new DebugException(this.getSession(), ex, this.resolveLanguage(), null, true, null);
            }
        }

        protected boolean isMeta() {
            return false;
        }

        private <T> T convertToPrimitive(Class<T> clazz) {
            Object val = this.get();
            if (clazz.isInstance(val)) {
                return clazz.cast(val);
            }
            return clazz.cast(Debugger.ACCESSOR.engineSupport().convertPrimitive(val, clazz));
        }

        @Override
        final DebuggerSession getSession() {
            return this.session;
        }
    }
}

