/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.AssertUtils;
import com.oracle.truffle.api.interop.InteropAccessNode;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;

final class LibraryToLegacy {
    LibraryToLegacy() {
    }

    static Object send(InteropAccessNode foreignNode, TruffleObject receiver, Object ... arguments) throws InteropException {
        try {
            return foreignNode.execute(receiver, arguments);
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
    }

    static Object sendRead(InteropAccessNode readNode, TruffleObject receiver, Object identifier) throws UnknownIdentifierException, UnsupportedMessageException {
        try {
            return readNode.execute(receiver, identifier);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreter();
            throw UnsupportedMessageException.create();
        }
        catch (UnknownIdentifierException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError(AssertUtils.violationPost((Object)receiver, e), e);
        }
    }

    static Object sendWrite(InteropAccessNode writeNode, TruffleObject receiver, Object identifier, Object value) throws UnknownIdentifierException, UnsupportedTypeException, UnsupportedMessageException {
        try {
            return writeNode.execute(receiver, identifier, value);
        }
        catch (UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError(AssertUtils.violationPost((Object)receiver, e), e);
        }
    }

    static boolean sendRemove(InteropAccessNode removeNode, TruffleObject receiver, Object identifier) throws UnknownIdentifierException, UnsupportedMessageException {
        try {
            return (Boolean)removeNode.execute(receiver, identifier);
        }
        catch (UnknownIdentifierException | UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreter();
            throw UnsupportedMessageException.create();
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError(AssertUtils.violationPost((Object)receiver, e), e);
        }
    }

    static Object sendUnbox(InteropAccessNode unboxNode, TruffleObject receiver) throws UnsupportedMessageException {
        try {
            return unboxNode.execute(receiver);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError(AssertUtils.violationPost((Object)receiver, e), e);
        }
    }

    static boolean sendIsPointer(InteropAccessNode isPointerNode, TruffleObject receiver) {
        try {
            return (Boolean)isPointerNode.executeOrFalse(receiver);
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError(AssertUtils.violationPost((Object)receiver, e), e);
        }
    }

    static long sendAsPointer(InteropAccessNode asPointerNode, TruffleObject receiver) throws UnsupportedMessageException {
        try {
            return (Long)asPointerNode.execute(receiver);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    static Object sendToNative(InteropAccessNode toNativeNode, TruffleObject receiver) throws UnsupportedMessageException {
        try {
            return toNativeNode.execute(receiver);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError(AssertUtils.violationPost((Object)receiver, e), e);
        }
    }

    static Object sendExecute(InteropAccessNode executeNode, TruffleObject receiver, Object ... arguments) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
        try {
            return executeNode.execute(receiver, arguments);
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError(AssertUtils.violationPost((Object)receiver, e), e);
        }
    }

    static boolean sendIsExecutable(InteropAccessNode isExecutableNode, TruffleObject receiver) {
        try {
            return (Boolean)isExecutableNode.executeOrFalse(receiver);
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError(AssertUtils.violationPost((Object)receiver, e), e);
        }
    }

    static boolean sendIsInstantiable(InteropAccessNode isInstantiableNode, TruffleObject receiver) {
        try {
            return (Boolean)isInstantiableNode.executeOrFalse(receiver);
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError(AssertUtils.violationPost((Object)receiver, e), e);
        }
    }

    static Object sendInvoke(InteropAccessNode invokeNode, TruffleObject receiver, String identifier, Object ... arguments) throws UnsupportedTypeException, ArityException, UnknownIdentifierException, UnsupportedMessageException {
        try {
            return invokeNode.execute(receiver, (Object)identifier, arguments);
        }
        catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError(AssertUtils.violationPost((Object)receiver, e), e);
        }
    }

    static Object sendNew(InteropAccessNode newNode, TruffleObject receiver, Object ... arguments) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
        try {
            return newNode.execute(receiver, arguments);
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError(AssertUtils.violationPost((Object)receiver, e), e);
        }
    }

    static boolean sendIsNull(InteropAccessNode isNullNode, TruffleObject receiver) {
        try {
            return (Boolean)isNullNode.executeOrFalse(receiver);
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError(AssertUtils.violationPost((Object)receiver, e), e);
        }
    }

    static boolean sendHasSize(InteropAccessNode hasSizeNode, TruffleObject receiver) {
        try {
            return (Boolean)hasSizeNode.executeOrFalse(receiver);
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError(AssertUtils.violationPost((Object)receiver, e), e);
        }
    }

    static Object sendGetSize(InteropAccessNode getSizeNode, TruffleObject receiver) throws UnsupportedMessageException {
        try {
            return getSizeNode.execute(receiver);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError(AssertUtils.violationPost((Object)receiver, e), e);
        }
    }

    static boolean sendIsBoxed(InteropAccessNode isBoxedNode, TruffleObject receiver) {
        try {
            return (Boolean)isBoxedNode.executeOrFalse(receiver);
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError(AssertUtils.violationPost((Object)receiver, e), e);
        }
    }

    static int sendKeyInfo(InteropAccessNode keyInfoNode, TruffleObject receiver, Object identifier) {
        try {
            return (Integer)keyInfoNode.execute(receiver, identifier);
        }
        catch (UnsupportedMessageException ex) {
            CompilerDirectives.transferToInterpreter();
            try {
                if (identifier instanceof String) {
                    InteropLibrary uncached = InteropLibrary.getFactory().getUncached();
                    Object keys = uncached.getMembers(receiver);
                    long size = uncached.getArraySize(keys);
                    for (long i = 0L; i < size; ++i) {
                        Object key = uncached.readArrayElement(keys, i);
                        if (!identifier.equals(key)) continue;
                        return 7;
                    }
                }
            }
            catch (InvalidArrayIndexException | UnsupportedMessageException uncached) {
                // empty catch block
            }
            try {
                boolean hasSize;
                if (identifier instanceof Number && (hasSize = (uncached = InteropLibrary.getFactory().getUncached(receiver)).hasArrayElements(receiver))) {
                    int id = ((Number)identifier).intValue();
                    if (id < 0 || (double)id != ((Number)identifier).doubleValue()) {
                        return 0;
                    }
                    long size = uncached.getArraySize(receiver);
                    if ((long)id < size) {
                        return 7;
                    }
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            return 0;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError(AssertUtils.violationPost((Object)receiver, e), e);
        }
    }

    static boolean sendHasKeys(InteropAccessNode hasKeysNode, TruffleObject receiver) {
        try {
            return (Boolean)hasKeysNode.execute(receiver);
        }
        catch (UnsupportedMessageException ex) {
            CompilerDirectives.transferToInterpreter();
            try {
                LibraryToLegacy.sendKeys(InteropAccessNode.getUncached(Message.KEYS), receiver, true);
                return true;
            }
            catch (UnsupportedMessageException uex) {
                return false;
            }
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError(AssertUtils.violationPost((Object)receiver, e), e);
        }
    }

    static TruffleObject sendKeys(InteropAccessNode keysNode, TruffleObject receiver, boolean includeInternal) throws UnsupportedMessageException {
        try {
            return (TruffleObject)LibraryToLegacy.send(keysNode, receiver, includeInternal);
        }
        catch (UnsupportedMessageException ex) {
            CompilerDirectives.transferToInterpreter();
            throw ex;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError(AssertUtils.violationPost((Object)receiver, e), e);
        }
    }
}

