/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.CharArrayWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.DuplicateException;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.Stamps;
import org.netbeans.Util;
import org.netbeans.core.startup.ModuleHistory;
import org.netbeans.core.startup.NbInstaller;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Dependency;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.SpecificationVersion;
import org.openide.util.BaseUtilities;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

final class ModuleList
implements Stamps.Updater {
    static final RequestProcessor RP = new RequestProcessor("Module List Updates");
    public static final String PUBLIC_ID = "-//NetBeans//DTD Module Status 1.0//EN";
    public static final String SYSTEM_ID = "http://www.netbeans.org/dtds/module-status-1_0.dtd";
    private static final boolean VALIDATE_XML = true;
    private static final Logger LOG = Logger.getLogger(ModuleList.class.getName());
    private final ModuleManager mgr;
    private final FileObject folder;
    private final Events ev;
    private final Map<String, DiskStatus> statuses = new HashMap<String, DiskStatus>(100);
    private boolean triggered = false;
    private final Listener listener = new Listener();
    private FileChangeListener weakListener;
    private final Set<FileSystem.AtomicAction> myAtomicActions = Collections.synchronizedSet(new WeakSet(100));
    private static final byte[] MODULE_XML_INTRO = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE module PUBLIC \"-//NetBeans//DTD Module Status 1.0//EN\"\n                        \"http://www.netbeans.org/dtds/module-status-1_0.dtd\">\n<module name=\"".getBytes();
    private static final byte[] MODULE_XML_INTRO_END = ">\n".getBytes();
    private static final byte[] MODULE_XML_DIV2 = "   <param name=\"".getBytes();
    private static final byte[] MODULE_XML_DIV3 = "/param>\n".getBytes();
    private static final byte[] MODULE_XML_END = "/module>\n".getBytes();

    public ModuleList(ModuleManager moduleManager, FileObject fileObject, Events events) {
        this.mgr = moduleManager;
        this.folder = fileObject;
        this.ev = events;
        LOG.fine("ModuleList created, storage in " + fileObject);
    }

    public Set<Module> readInitial() {
        this.ev.log("startRead", new Object[0]);
        HashSet<Module> hashSet = new HashSet<Module>();
        try {
            this.folder.getFileSystem().runAtomicAction((FileSystem.AtomicAction)new ReadInitial(hashSet));
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, null, iOException);
        }
        return hashSet;
    }

    final Module createModule(File file, ModuleHistory moduleHistory, boolean bl, boolean bl2, boolean bl3, Integer n) throws IOException {
        Module module;
        try {
            module = n != null ? this.mgr.createBundle(file, (Object)moduleHistory, bl, bl2, bl3, n.intValue()) : this.mgr.create(file, (Object)moduleHistory, bl, bl2, bl3);
        }
        catch (DuplicateException duplicateException) {
            throw new IOException(duplicateException);
        }
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File findJarByName(String string, String string2) throws IOException {
        File file = new File(string);
        if (file.isAbsolute()) {
            if (!file.isFile()) {
                throw new FileNotFoundException(file.getAbsolutePath());
            }
            return file;
        }
        Set set = InstalledFileLocator.getDefault().locateAll(string, string2, false);
        if (set.isEmpty()) {
            throw new FileNotFoundException(string);
        }
        if (set.size() == 1 || Boolean.getBoolean("org.netbeans.core.startup.ModuleList.firstModuleJarWins")) {
            return (File)set.iterator().next();
        }
        int n = -1;
        SpecificationVersion specificationVersion = null;
        File file2 = null;
        for (File file3 : set) {
            int n2 = -1;
            SpecificationVersion specificationVersion2 = null;
            try (JarFile jarFile = new JarFile(file3);){
                String string3;
                int n3;
                Attributes attributes = jarFile.getManifest().getMainAttributes();
                String string4 = attributes.getValue("OpenIDE-Module");
                if (string4 != null && (n3 = string4.lastIndexOf(47)) != -1) {
                    n2 = Integer.parseInt(string4.substring(n3 + 1));
                }
                if ((string3 = attributes.getValue("OpenIDE-Module-Specification-Version")) != null) {
                    specificationVersion2 = new SpecificationVersion(string3);
                }
            }
            if (file2 != null && n2 <= n && (specificationVersion == null || specificationVersion2 == null || specificationVersion2.compareTo((Object)specificationVersion) <= 0)) continue;
            file2 = file3;
            n = n2;
            specificationVersion = specificationVersion2;
        }
        return file2;
    }

    public void trigger(Set<Module> set) {
        this.ev.log("perfStart", new Object[]{"ModuleList.trigger"});
        if (this.triggered) {
            throw new IllegalStateException("Duplicate call to trigger()");
        }
        HashSet<Module> hashSet = new HashSet<Module>(set);
        for (DiskStatus diskStatus : this.statuses.values()) {
            if (!diskStatus.pendingInstall) continue;
            diskStatus.pendingInstall = false;
            Module module = diskStatus.module;
            if (module.isEnabled() || module.isAutoload() || module.isEager()) {
                throw new IllegalStateException();
            }
            hashSet.add(module);
        }
        this.ev.log("perfTick", new Object[]{"modules to enable prepared"});
        if (!hashSet.isEmpty()) {
            this.ev.log("startAutoRestore", new Object[]{hashSet});
            this.installNew(hashSet);
            this.ev.log("finishAutoRestore", new Object[]{hashSet});
        }
        LOG.fine("ModuleList.trigger: enabled new modules, flushing changes...");
        this.triggered = true;
        this.flushInitial();
        this.ev.log("perfEnd", new Object[]{"ModuleList.trigger"});
    }

    private void installNew(Set<Module> set) {
        Module module;
        Object object;
        if (set.isEmpty()) {
            return;
        }
        this.ev.log("perfStart", new Object[]{"ModuleList.installNew"});
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object.isAutoload() || object.isEager()) {
                iterator.remove();
                continue;
            }
            if (object.isEnabled()) {
                LOG.fine("#17295 fix active for " + object.getCodeNameBase());
                iterator.remove();
                continue;
            }
            if (object.isValid()) continue;
            LOG.fine("#17471 fix active for " + object.getCodeNameBase());
            iterator.remove();
        }
        object = this.mgr.simulateEnable(set);
        Object object2 = object.iterator();
        while (object2.hasNext()) {
            module = (Module)object2.next();
            if (module.isAutoload() || module.isEager() || set.contains(module)) continue;
            set.add(module);
        }
        object2 = new HashSet<Module>(set);
        object2.removeAll((Collection<?>)object);
        if (!object2.isEmpty()) {
            Util.transitiveClosureModuleDependencies((ModuleManager)this.mgr, (Set)object2);
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                module = (Module)iterator.next();
                if (!module.getProblems().isEmpty()) continue;
                iterator.remove();
            }
            this.ev.log("failedInstallNew", new Object[]{object2});
            set.removeAll((Collection<?>)object2);
        }
        try {
            this.mgr.enable(set);
        }
        catch (InvalidException invalidException) {
            LOG.log(Level.INFO, null, invalidException);
            Module module2 = invalidException.getModule();
            if (module2 == null) {
                throw new IllegalStateException();
            }
            Set set2 = this.mgr.getModuleInterdependencies(module2, true, true, true);
            this.ev.log("failedInstallNewUnexpected", new Object[]{module2, set2, invalidException});
            set.removeAll(set2);
            this.installNew(set);
        }
        this.ev.log("perfEnd", new Object[]{"ModuleList.installNew"});
    }

    private Map<String, Object> readStatus(InputSource inputSource, XMLReader xMLReader) throws IOException, SAXException {
        if (xMLReader == null) {
            xMLReader = XMLUtil.createXMLReader((boolean)true);
            xMLReader.setEntityResolver(this.listener);
            xMLReader.setErrorHandler(this.listener);
        }
        final HashMap<String, Object> hashMap = new HashMap<String, Object>();
        DefaultHandler defaultHandler = new DefaultHandler(){
            private String modName;
            private String paramName;
            private StringBuffer data = new StringBuffer();

            @Override
            public void startElement(String string, String string2, String string3, org.xml.sax.Attributes attributes) throws SAXException {
                if ("module".equals(string3)) {
                    this.modName = attributes.getValue("name");
                    if (this.modName == null) {
                        throw new SAXException("No module name");
                    }
                    hashMap.put("name", this.modName.intern());
                } else if (this.modName != null && "param".equals(string3)) {
                    this.paramName = attributes.getValue("name");
                    if (this.paramName == null) {
                        throw new SAXException("No param name");
                    }
                    this.paramName = this.paramName.intern();
                    this.data.setLength(0);
                }
            }

            @Override
            public void characters(char[] cArray, int n, int n2) {
                if (this.modName != null && this.paramName != null) {
                    this.data.append(cArray, n, n2);
                }
            }

            @Override
            public void endElement(String string, String string2, String string3) throws SAXException {
                if ("param".equals(string3)) {
                    if (this.modName != null && this.paramName != null) {
                        if (this.data.length() == 0) {
                            throw new SAXException("No text contents in " + this.paramName + " of " + this.modName);
                        }
                        try {
                            hashMap.put(this.paramName, ModuleList.this.processStatusParam(this.paramName, this.data.toString()));
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw (SAXException)new SAXException(numberFormatException.toString()).initCause(numberFormatException);
                        }
                        this.data.setLength(0);
                        this.paramName = null;
                    }
                } else if ("module".equals(string3)) {
                    this.modName = null;
                }
            }
        };
        xMLReader.setContentHandler(defaultHandler);
        xMLReader.parse(inputSource);
        this.sanityCheckStatus(hashMap);
        return hashMap;
    }

    private Object processStatusParam(String string, String string2) throws NumberFormatException {
        if (string == "enabled" || string == "autoload" || string == "eager" || string == "reloadable") {
            return Boolean.valueOf(string2);
        }
        if (string == "startlevel") {
            return Integer.valueOf(string2);
        }
        if (string2.length() < 100) {
            string2 = string2.intern();
        }
        return string2;
    }

    private void sanityCheckStatus(Map<String, Object> map) throws IOException {
        String string = (String)map.get("jar");
        if (string == null) {
            throw new IOException("Must define jar param");
        }
        if (Boolean.TRUE.equals(map.get("autoload")) && map.get("enabled") != null) {
            throw new IOException("Autoload " + string + " cannot specify enablement");
        }
        if (Boolean.TRUE.equals(map.get("eager")) && map.get("enabled") != null) {
            throw new IOException("Eager " + string + " cannot specify enablement");
        }
    }

    private Map<String, Object> readStatus(InputStream inputStream, boolean bl) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 1);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(15);
        if (!this.expect(pushbackInputStream, MODULE_XML_INTRO)) {
            LOG.fine("Could not read intro");
            return null;
        }
        String string = this.readTo(pushbackInputStream, '\"');
        if (string == null) {
            LOG.fine("Could not read code name base");
            return null;
        }
        hashMap.put("name", string.intern());
        if (!this.expect(pushbackInputStream, MODULE_XML_INTRO_END)) {
            LOG.fine("Could not read stuff after cnb");
            return null;
        }
        block6: while (true) {
            int n = pushbackInputStream.read();
            switch (n) {
                case 32: {
                    if (!this.expect(pushbackInputStream, MODULE_XML_DIV2)) {
                        LOG.fine("Could not read up to param");
                        return null;
                    }
                    String string2 = this.readTo(pushbackInputStream, '\"');
                    if (string2 == null) {
                        LOG.fine("Could not read param");
                        return null;
                    }
                    string2 = string2.intern();
                    if (pushbackInputStream.read() != 62) {
                        LOG.fine("No > at end of <param> " + string2);
                        return null;
                    }
                    String string3 = this.readTo(pushbackInputStream, '<');
                    if (string3 == null) {
                        LOG.fine("Could not read value of " + string2);
                        return null;
                    }
                    if (!this.expect(pushbackInputStream, MODULE_XML_DIV3)) {
                        LOG.fine("Could not read end of param " + string2);
                        return null;
                    }
                    try {
                        hashMap.put(string2, this.processStatusParam(string2, string3));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOG.fine("Number misparse: " + numberFormatException);
                        return null;
                    }
                }
                case 60: {
                    if (!this.expect(pushbackInputStream, MODULE_XML_END)) {
                        LOG.fine("Strange ending");
                        return null;
                    }
                    if (!bl || pushbackInputStream.read() == -1) break block6;
                    LOG.fine("Trailing garbage");
                    return null;
                }
                default: {
                    LOG.fine("Strange stuff after <param>s: " + n);
                    return null;
                }
            }
        }
        this.sanityCheckStatus(hashMap);
        return hashMap;
    }

    private boolean expect(PushbackInputStream pushbackInputStream, byte[] byArray) throws IOException {
        int n = byArray.length;
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            int n3 = pushbackInputStream.read();
            if (n3 == 10 || n3 == 13) {
                if (bl) continue;
                bl = true;
                n3 = 10;
            } else {
                bl = false;
            }
            if (n3 == byArray[n2++]) continue;
            return false;
        }
        if (byArray[n - 1] == 10 && (n2 = pushbackInputStream.read()) != -1 && n2 != 10 && n2 != 13) {
            pushbackInputStream.unread(n2);
        }
        return true;
    }

    private String readTo(InputStream inputStream, char c) throws IOException {
        if (c == '\n') {
            throw new IOException("Not implemented");
        }
        CharArrayWriter charArrayWriter = new CharArrayWriter(100);
        boolean bl = false;
        int n;
        while ((n = inputStream.read()) != -1) {
            if (n > 126) {
                return null;
            }
            if (n == 10 || n == 13) {
                if (bl) continue;
                bl = true;
                n = 10;
            } else {
                if (n < 32 && n != 9) {
                    return null;
                }
                bl = false;
            }
            if (n == c) {
                return charArrayWriter.toString();
            }
            charArrayWriter.write(n);
        }
        return null;
    }

    final Map<String, Map<String, Object>> readCache() {
        InputStream inputStream = Stamps.getModulesJARs().asStream("all-modules.dat");
        if (inputStream == null) {
            this.writeCache();
            return null;
        }
        LOG.log(Level.FINEST, "Reading cache all-modules.dat");
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            HashMap<String, Map<String, Object>> hashMap = new HashMap<String, Map<String, Object>>(1333);
            while (inputStream.available() > 0) {
                Set set;
                Map<String, Object> map = this.readStatus(objectInputStream, false);
                if (map == null) {
                    LOG.log(Level.CONFIG, "Cache is invalid all-modules.dat");
                    return null;
                }
                try {
                    set = (Set)objectInputStream.readObject();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IOException(classNotFoundException);
                }
                map.put("deps", set);
                String string = (String)map.get("name");
                hashMap.put(string, map);
            }
            inputStream.close();
            return hashMap;
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, "Cannot read cache", iOException);
            this.writeCache();
            return null;
        }
    }

    final void writeCache() {
        Stamps.getModulesJARs().scheduleSave((Stamps.Updater)this, "all-modules.dat", false);
    }

    public void cacheReady() {
    }

    public void flushCaches(DataOutputStream dataOutputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(dataOutputStream);
        for (Module module : this.mgr.getModules()) {
            if (module.isFixed()) continue;
            Map<String, Object> map = this.computeProperties(module);
            this.writeStatus(map, objectOutputStream);
            objectOutputStream.writeObject(module.getDependencies());
        }
    }

    private void writeStatus(Map<String, Object> map, OutputStream outputStream) throws IOException {
        String string = (String)map.get("name");
        if (string == null) {
            throw new IllegalArgumentException("no code name present");
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        outputStreamWriter.write("<!DOCTYPE module PUBLIC \"");
        outputStreamWriter.write(PUBLIC_ID);
        outputStreamWriter.write("\"\n                        \"");
        outputStreamWriter.write(SYSTEM_ID);
        outputStreamWriter.write("\">\n");
        outputStreamWriter.write("<module name=\"");
        outputStreamWriter.write(XMLUtil.toAttributeValue((String)string));
        outputStreamWriter.write("\">\n");
        for (Map.Entry<String, Object> entry : new TreeMap<String, Object>(map).entrySet()) {
            String string2 = entry.getKey();
            if (string2.equals("name") || string2.equals("deps")) continue;
            Object object = entry.getValue();
            outputStreamWriter.write("    <param name=\"");
            outputStreamWriter.write(XMLUtil.toAttributeValue((String)string2));
            outputStreamWriter.write("\">");
            outputStreamWriter.write(XMLUtil.toElementContent((String)object.toString()));
            outputStreamWriter.write("</param>\n");
        }
        outputStreamWriter.write("</module>\n");
        ((Writer)outputStreamWriter).flush();
    }

    private DiskStatus writeOut(Module module, DiskStatus diskStatus) throws IOException {
        DiskStatus diskStatus2;
        if (diskStatus == null) {
            diskStatus2 = new DiskStatus();
            diskStatus2.module = module;
            diskStatus2.setDiskProps(this.computeProperties(module));
        } else {
            diskStatus2 = diskStatus;
        }
        FileSystem.AtomicAction atomicAction = new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                if (diskStatus2.file == null) {
                    diskStatus2.file = FileUtil.createData((FileObject)ModuleList.this.folder, (String)(((String)diskStatus2.diskProps.get("name")).replace('.', '-') + ".xml"));
                } else if (diskStatus2.dirty) {
                    LOG.log(Level.INFO, null, new IOException("Will not clobber external changes in " + diskStatus2.file));
                    return;
                }
                LOG.fine("ModuleList: (re)writing " + diskStatus2.file);
                FileLock fileLock = diskStatus2.file.lock();
                try (OutputStream outputStream = diskStatus2.file.getOutputStream(fileLock);){
                    ModuleList.this.writeStatus(diskStatus2.diskProps, outputStream);
                }
                finally {
                    fileLock.releaseLock();
                }
            }
        };
        this.myAtomicActions.add(atomicAction);
        this.folder.getFileSystem().runAtomicAction(atomicAction);
        return diskStatus2;
    }

    private void deleteFromDisk(final Module module, final DiskStatus diskStatus) throws IOException {
        final String string = module.getCodeNameBase().replace('.', '-');
        FileSystem.AtomicAction atomicAction = new FileSystem.AtomicAction(){

            public void run() throws IOException {
                FileObject fileObject = ModuleList.this.folder.getFileObject(string, "xml");
                if (fileObject == null) {
                    LOG.fine("ModuleList: " + module + "'s XML already gone from disk");
                    return;
                }
                if (diskStatus.dirty) {
                    throw new IOException("Unapproved external change to " + fileObject);
                }
                LOG.fine("ModuleList: deleting " + fileObject);
                fileObject.delete();
                FileObject fileObject2 = ModuleList.this.folder.getFileObject(string, "ser");
                if (fileObject2 != null) {
                    LOG.fine("(and also " + fileObject2 + ")");
                    fileObject2.delete();
                }
            }
        };
        this.myAtomicActions.add(atomicAction);
        this.folder.getFileSystem().runAtomicAction(atomicAction);
    }

    private void flushInitial() {
        LOG.fine("Flushing initial module list...");
        for (Module module : this.mgr.getModules()) {
            DiskStatus diskStatus = this.statuses.get(module.getCodeNameBase());
            if (diskStatus == null) continue;
            this.moduleChanged(module, diskStatus);
            module.addPropertyChangeListener((PropertyChangeListener)this.listener);
        }
        this.moduleListChanged();
        this.mgr.addPropertyChangeListener((PropertyChangeListener)this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void moduleListChanged() {
        Map<String, DiskStatus> map = this.statuses;
        synchronized (map) {
            String string;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("ModuleList: moduleListChanged; statuses=" + this.statuses);
            }
            for (Object object : this.mgr.getModules()) {
                if (object.isFixed() || object.getJarFile() == null || this.statuses.get(string = object.getCodeNameBase()) != null) continue;
                LOG.fine("moduleListChanged: added: " + object);
                try {
                    this.statuses.put(string, this.writeOut((Module)object, null));
                    object.addPropertyChangeListener((PropertyChangeListener)this.listener);
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, null, iOException);
                }
            }
            Iterator<Object> iterator = this.statuses.values().iterator();
            while (iterator.hasNext()) {
                Object object;
                object = (DiskStatus)iterator.next();
                if (object.module.isValid()) continue;
                object.module.removePropertyChangeListener((PropertyChangeListener)this.listener);
                string = this.mgr.get(object.module.getCodeNameBase());
                if (string != null) {
                    LOG.fine("moduleListChanged: recreated: " + string);
                    string.addPropertyChangeListener((PropertyChangeListener)this.listener);
                    object.module = string;
                    this.moduleChanged((Module)string, (DiskStatus)object);
                    continue;
                }
                LOG.fine("moduleListChanged: deleted: " + object.module);
                iterator.remove();
                try {
                    this.deleteFromDisk(object.module, (DiskStatus)object);
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, null, iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moduleChanged(Module module, DiskStatus diskStatus) {
        DiskStatus diskStatus2 = diskStatus;
        synchronized (diskStatus2) {
            LOG.log(Level.FINE, "moduleChanged: {0}", module);
            Map<String, Object> map = this.computeProperties(module);
            int n = 0;
            for (Map.Entry<String, Object> entry : diskStatus.diskProps.entrySet()) {
                if (entry.getKey().equals("deps")) continue;
                Object object = map.get(entry.getKey());
                if (!entry.getValue().equals(object)) {
                    n = -1;
                    break;
                }
                ++n;
            }
            if (n != map.size()) {
                if (LOG.isLoggable(Level.FINE)) {
                    HashSet<Map.Entry<String, Object>> hashSet = new HashSet<Map.Entry<String, Object>>(map.entrySet());
                    hashSet.removeAll(diskStatus.diskProps.entrySet());
                    LOG.fine("ModuleList: changes are " + hashSet);
                }
                diskStatus.setDiskProps(map);
                try {
                    this.writeOut(module, diskStatus);
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, null, iOException);
                }
                this.writeCache();
            }
        }
    }

    private Map<String, Object> computeProperties(Module module) {
        if (module.isFixed() || !module.isValid()) {
            throw new IllegalArgumentException("fixed or invalid: " + module);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("name", module.getCodeNameBase());
        if (!module.isAutoload() && !module.isEager()) {
            hashMap.put("enabled", module.isEnabled());
        }
        hashMap.put("autoload", module.isAutoload());
        hashMap.put("eager", module.isEager());
        hashMap.put("reloadable", module.isReloadable());
        if (module.getStartLevel() > 0) {
            hashMap.put("startlevel", module.getStartLevel());
        }
        if (module.getHistory() instanceof ModuleHistory) {
            ModuleHistory moduleHistory = (ModuleHistory)module.getHistory();
            hashMap.put("jar", moduleHistory.getJar());
        }
        return hashMap;
    }

    final void init() {
        this.weakListener = FileUtil.weakFileChangeListener((FileChangeListener)this.listener, (Object)this.folder);
        this.folder.getChildren();
        this.folder.addFileChangeListener(this.weakListener);
    }

    final void shutDown() {
        this.folder.removeFileChangeListener(this.weakListener);
    }

    private class ReadInitial
    implements FileSystem.AtomicAction,
    Runnable {
        private final Set<Module> read;
        private volatile RequestProcessor.Task task;

        public ReadInitial(Set<Module> set) {
            this.read = set;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String[] stringArray;
            if (this.task != null) {
                ModuleList.this.init();
                return;
            }
            this.task = RP.create((Runnable)this);
            this.task.schedule(0);
            Map<String, Map<String, Object>> map = ModuleList.this.readCache();
            if (map != null) {
                stringArray = map.keySet().toArray(new String[map.size()]);
            } else {
                object4 = ModuleList.this.folder.getChildren();
                ArrayList<String> arrayList = new ArrayList<String>(((FileObject[])object4).length);
                for (Object object5 : object4) {
                    if (object5.hasExt("ser")) continue;
                    if (object5.hasExt("xml")) {
                        object3 = object5.getName();
                        object2 = new char[]{'.', '/', '>', '='};
                        for (int i = 0; i < 4; ++i) {
                            if (((String)object3).indexOf(object2[i]) == -1) continue;
                            throw new IllegalArgumentException("Bad name: " + (String)object3);
                        }
                        object = ((String)object3).replace('-', '.').intern();
                        arrayList.add((String)object);
                        continue;
                    }
                    LOG.fine("Strange file encountered in modules folder: " + object5);
                }
                stringArray = arrayList.toArray(new String[arrayList.size()]);
            }
            ModuleList.this.ev.log("modulesFileScanned", new Object[]{stringArray.length});
            object4 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                FileObject fileObject = null;
                try {
                    Map map2;
                    Object object5;
                    block22: {
                        Map map3 = map2 = map == null ? null : map.get(string);
                        if (map2 == null) {
                            Dependency.create((int)1, (String)string);
                            LOG.log(Level.FINEST, "no cache for {0}", string);
                            fileObject = ModuleList.this.folder.getFileObject(string.replace('.', '-') + ".xml");
                            object5 = fileObject.getInputStream();
                            try {
                                map2 = ModuleList.this.readStatus(new BufferedInputStream((InputStream)object5), true);
                                if (map2 != null) break block22;
                                LOG.warning("Note - failed to parse " + fileObject + " the quick way, falling back on XMLReader");
                                ((InputStream)object5).close();
                                object5 = fileObject.getInputStream();
                                object3 = new InputSource((InputStream)object5);
                                ((InputSource)object3).setSystemId(fileObject.toURL().toExternalForm());
                                if (object4 == null) {
                                    try {
                                        object4 = XMLUtil.createXMLReader();
                                    }
                                    catch (SAXException sAXException) {
                                        throw (IllegalStateException)new IllegalStateException(sAXException.toString()).initCause(sAXException);
                                    }
                                    object4.setEntityResolver(ModuleList.this.listener);
                                    object4.setErrorHandler(ModuleList.this.listener);
                                }
                                map2 = ModuleList.this.readStatus((InputSource)object3, (XMLReader)object4);
                            }
                            finally {
                                ((InputStream)object5).close();
                            }
                        }
                    }
                    if (!string.equals(map2.get("name"))) {
                        throw new IOException("Code name mismatch: " + (String)string + " vs. " + map2.get("name"));
                    }
                    object5 = (Boolean)map2.get("enabled");
                    object3 = (String)map2.get("jar");
                    try {
                        object2 = ModuleList.this.findJarByName((String)object3, string);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        ModuleList.this.ev.log("missingJarFile", new Object[]{new File(fileNotFoundException.getMessage()), object5});
                        if (fileObject == null || Boolean.FALSE.equals(object5)) continue;
                        try {
                            fileObject.delete();
                        }
                        catch (IOException iOException) {
                            LOG.log(Level.WARNING, null, iOException);
                        }
                        continue;
                    }
                    object = new ModuleHistory((String)object3, "loaded from " + fileObject);
                    Boolean bl = (Boolean)map2.get("reloadable");
                    boolean bl2 = bl != null ? bl : false;
                    boolean bl3 = object5 != null ? (Boolean)object5 : false;
                    Boolean bl4 = (Boolean)map2.get("autoload");
                    boolean bl5 = bl4 != null ? bl4 : false;
                    Boolean bl6 = (Boolean)map2.get("eager");
                    boolean bl7 = bl6 != null ? bl6 : false;
                    NbInstaller.register(string, map2.get("deps"));
                    Integer n = (Integer)map2.get("startlevel");
                    Module module = ModuleList.this.createModule((File)object2, (ModuleHistory)object, bl2, bl5, bl7, n);
                    NbInstaller.register(null, null);
                    this.read.add(module);
                    DiskStatus diskStatus = new DiskStatus();
                    diskStatus.module = module;
                    diskStatus.file = fileObject;
                    diskStatus.pendingInstall = bl3;
                    diskStatus.setDiskProps(map2);
                    ModuleList.this.statuses.put(string, diskStatus);
                }
                catch (Exception exception) {
                    LOG.log(Level.WARNING, "Error encountered while reading " + (String)string, exception);
                }
                ModuleList.this.ev.log("modulesFileProcessed", new Object[]{string});
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("read initial XML files: statuses=" + ModuleList.this.statuses);
            }
            ModuleList.this.ev.log("finishRead", new Object[]{this.read});
            this.task.waitFinished();
        }
    }

    private static final class DiskStatus {
        public Module module;
        public FileObject file;
        public boolean pendingInstall = false;
        public Map<String, Object> diskProps;
        public boolean dirty = false;

        void setDiskProps(Map<String, Object> map) {
            Parameters.notNull((CharSequence)"diskProps", map);
            this.diskProps = map;
        }

        public String toString() {
            return "DiskStatus[module=" + this.module + ",valid=" + this.module.isValid() + ",file=" + this.file + ",dirty=" + this.dirty + ",pendingInstall=" + this.pendingInstall + ",diskProps=" + this.diskProps + "]";
        }
    }

    private final class Listener
    implements PropertyChangeListener,
    ErrorHandler,
    EntityResolver,
    FileChangeListener,
    Runnable {
        private final RequestProcessor.Task task = RP.create((Runnable)this);
        private boolean listening = true;

        Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!ModuleList.this.triggered) {
                throw new IllegalStateException("Property change before trigger()");
            }
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getSource();
            if (!this.listening) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("ModuleList: ignoring own change " + string + " from " + object);
                }
                return;
            }
            if ("classLoader".equals(string) || "enabledModules".equals(string) || "classLoader".equals(string) || "problems".equals(string) || "valid".equals(string)) {
                return;
            }
            if ("modules".equals(string)) {
                ModuleList.this.moduleListChanged();
            } else if (object instanceof Module) {
                Module module = (Module)object;
                if (!module.isValid()) {
                    return;
                }
                DiskStatus diskStatus = (DiskStatus)ModuleList.this.statuses.get(module.getCodeNameBase());
                if (diskStatus == null) {
                    throw new IllegalStateException("Unknown module " + module + "; statuses=" + ModuleList.this.statuses);
                }
                if (diskStatus.pendingInstall && "enabled".equals(string)) {
                    throw new IllegalStateException("Got PROP_ENABLED on " + module + " before trigger()");
                }
                ModuleList.this.moduleChanged(module, diskStatus);
            } else {
                LOG.fine("Unexpected property change: " + propertyChangeEvent + " prop=" + string + " src=" + object);
            }
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            LOG.log(Level.WARNING, null, sAXParseException);
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        @Override
        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            if (string.equals(ModuleList.PUBLIC_ID)) {
                return new InputSource(ModuleList.class.getResource("module-status-1_0.dtd").toExternalForm());
            }
            return EntityCatalog.getDefault().resolveEntity(string, string2);
        }

        public void fileDeleted(FileEvent fileEvent) {
            if (this.isOurs(fileEvent)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("ModuleList: got expected deletion " + fileEvent);
                }
                return;
            }
            FileObject fileObject = fileEvent.getFile();
            this.fileDeleted0(fileObject.getName(), fileObject.getExt());
        }

        public void fileDataCreated(FileEvent fileEvent) {
            if (this.isOurs(fileEvent)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("ModuleList: got expected creation " + fileEvent);
                }
                return;
            }
            FileObject fileObject = fileEvent.getFile();
            this.fileCreated0(fileObject.getName(), fileObject.getExt());
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            if (this.isOurs((FileEvent)fileRenameEvent)) {
                throw new IllegalStateException("I don't rename anything! " + fileRenameEvent);
            }
            FileObject fileObject = fileRenameEvent.getFile();
            this.fileDeleted0(fileRenameEvent.getName(), fileRenameEvent.getExt());
            this.fileCreated0(fileObject.getName(), fileObject.getExt());
        }

        private void fileCreated0(String string, String string2) {
            if ("xml".equals(string2)) {
                String string3 = string.replace('-', '.');
                DiskStatus diskStatus = (DiskStatus)ModuleList.this.statuses.get(string3);
                LOG.fine("ModuleList: outside file creation event for " + string3);
                if (diskStatus != null) {
                    diskStatus.dirty = true;
                }
                this.runme();
            } else if ("ser".equals(string2)) {
                // empty if block
            }
        }

        private void fileDeleted0(String string, String string2) {
            if ("xml".equals(string2)) {
                String string3 = string.replace('-', '.');
                DiskStatus diskStatus = (DiskStatus)ModuleList.this.statuses.get(string3);
                LOG.fine("ModuleList: outside file deletion event for " + string3);
                if (diskStatus != null) {
                    diskStatus.dirty = true;
                }
                this.runme();
            } else if ("ser".equals(string2)) {
                // empty if block
            }
        }

        public void fileChanged(FileEvent fileEvent) {
            if (this.isOurs(fileEvent)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("ModuleList: got expected modification " + fileEvent);
                }
                return;
            }
            FileObject fileObject = fileEvent.getFile();
            String string = fileObject.getName();
            String string2 = fileObject.getExt();
            if ("xml".equals(string2)) {
                String string3 = string.replace('-', '.');
                DiskStatus diskStatus = (DiskStatus)ModuleList.this.statuses.get(string3);
                LOG.fine("ModuleList: outside file modification event for " + string3 + ": " + fileEvent);
                if (diskStatus != null) {
                    diskStatus.dirty = true;
                }
                this.runme();
            } else if ("ser".equals(string2)) {
                // empty if block
            }
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        private boolean isOurs(FileEvent fileEvent) {
            for (FileSystem.AtomicAction atomicAction : ModuleList.this.myAtomicActions) {
                if (!fileEvent.firedFrom(atomicAction)) continue;
                return true;
            }
            return false;
        }

        private void runme() {
            this.task.schedule(100);
        }

        @Override
        public void run() {
            LOG.fine("ModuleList: will process outstanding external XML changes");
            ModuleList.this.mgr.mutexPrivileged().enterWriteAccess();
            try {
                ModuleList.this.folder.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                    public void run() throws IOException {
                        Map map = Listener.this.prepareXMLFiles();
                        Map map2 = Listener.this.prepareDirtyProps(map);
                        Listener.this.listening = false;
                        try {
                            Listener.this.stepCheckReloadable(map2);
                            Listener.this.stepCreate(map, map2);
                            Listener.this.stepEnable(map2);
                            Listener.this.stepDisable(map2);
                            Listener.this.stepDelete(map);
                            Listener.this.stepCheckMisc(map2);
                            Listener.this.stepCheckSer(map, map2);
                        }
                        finally {
                            Listener.this.listening = true;
                            Listener.this.stepUpdateProps(map2);
                            Listener.this.stepMarkClean();
                        }
                    }
                });
                LOG.fine("ModuleList: finished processing outstanding external XML changes");
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, null, iOException);
            }
            finally {
                ModuleList.this.mgr.mutexPrivileged().exitWriteAccess();
            }
        }

        private Map<String, FileObject> prepareXMLFiles() {
            LOG.fine("ModuleList: prepareXMLFiles");
            HashMap<String, FileObject> hashMap = new HashMap<String, FileObject>(100);
            FileObject[] fileObjectArray = ModuleList.this.folder.getChildren();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                if (!fileObjectArray[i].hasExt("xml")) continue;
                hashMap.put(fileObjectArray[i].getName().replace('-', '.'), fileObjectArray[i]);
            }
            return hashMap;
        }

        /*
         * Exception decompiling
         */
        private Map<String, Map<String, Object>> prepareDirtyProps(Map<String, FileObject> var1_1) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void stepCheckReloadable(Map<String, Map<String, Object>> map) {
            LOG.fine("ModuleList: stepCheckReloadable");
            for (Map.Entry<String, Map<String, Object>> entry : map.entrySet()) {
                boolean bl;
                String string = entry.getKey();
                DiskStatus diskStatus = (DiskStatus)ModuleList.this.statuses.get(string);
                if (diskStatus == null) continue;
                Map<String, Object> map2 = entry.getValue();
                Boolean bl2 = (Boolean)map2.get("reloadable");
                boolean bl3 = bl = bl2 != null ? bl2 : false;
                boolean bl4 = diskStatus.module.isReloadable();
                if (bl4 == bl) continue;
                LOG.fine("Disk change in reloadable for " + string + " from " + bl4 + " to " + bl);
                diskStatus.module.setReloadable(bl);
            }
        }

        private void stepCreate(Map<String, FileObject> map, Map<String, Map<String, Object>> map2) throws IOException {
            LOG.fine("ModuleList: stepCreate");
            for (Map.Entry<String, FileObject> entry : map.entrySet()) {
                Map<String, Object> map3;
                File file4;
                Comparable<Boolean> comparable;
                File file2;
                String string = entry.getKey();
                if (ModuleList.this.statuses.containsKey(string)) continue;
                FileObject fileObject = entry.getValue();
                Map<String, Object> map4 = map2.get(string);
                if (!string.equals(map4.get("name"))) {
                    throw new IOException("Code name mismatch");
                }
                String string2 = (String)map4.get("jar");
                try {
                    file2 = ModuleList.this.findJarByName(string2, string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    File file3 = new File(fileNotFoundException.getMessage());
                    ModuleList.this.ev.log("missingJarFile", new Object[]{file3, true});
                    comparable = file3.getParentFile();
                    File[] fileArray = ((File)comparable).listFiles();
                    LOG.log(Level.FINE, "Content of {0} is:", comparable);
                    int n = 0;
                    if (fileArray != null) {
                        for (File file4 : fileArray) {
                            LOG.log(Level.FINE, "{0}. = {1}", new Object[]{++n, file4});
                        }
                        LOG.log(Level.FINE, "There was {0} files", n);
                    } else {
                        LOG.fine("Directory does not exist");
                    }
                    map2.remove(string);
                    continue;
                }
                Boolean bl = (Boolean)map4.get("reloadable");
                boolean bl2 = bl != null ? bl : false;
                comparable = (Boolean)map4.get("autoload");
                boolean bl3 = comparable != null ? (Boolean)comparable : false;
                Boolean bl4 = (Boolean)map4.get("eager");
                boolean bl5 = bl4 != null ? bl4 : false;
                Integer n = (Integer)map4.get("startlevel");
                ModuleHistory moduleHistory = new ModuleHistory(string2, "created from " + fileObject);
                file4 = ModuleList.this.createModule(file2, moduleHistory, bl2, bl3, bl5, n);
                file4.addPropertyChangeListener(this);
                if (map4.get("enabled") != null && ((Boolean)map4.get("enabled")).booleanValue()) {
                    map3 = new HashMap<String, Object>(map4);
                    map3.put("enabled", Boolean.FALSE);
                } else {
                    map3 = map4;
                }
                DiskStatus diskStatus = new DiskStatus();
                diskStatus.module = file4;
                diskStatus.file = fileObject;
                diskStatus.setDiskProps(map3);
                ModuleList.this.statuses.put(string, diskStatus);
            }
        }

        private void stepEnable(Map<String, Map<String, Object>> map) throws IOException {
            LOG.fine("ModuleList: stepEnable");
            if (LOG.isLoggable(Level.FINEST)) {
                for (Map.Entry iterator : map.entrySet()) {
                    LOG.log(Level.FINEST, "{0} = {1}", new Object[]{iterator.getKey(), iterator.getValue()});
                }
            }
            HashSet hashSet = new HashSet();
            for (Map.Entry<String, Map<String, Object>> entry : map.entrySet()) {
                String string = entry.getKey();
                Map<String, Object> map2 = entry.getValue();
                if (map2.get("enabled") == null || !((Boolean)map2.get("enabled")).booleanValue()) continue;
                DiskStatus diskStatus = (DiskStatus)ModuleList.this.statuses.get(string);
                assert (diskStatus != null) : string;
                if (diskStatus.diskProps.get("enabled") != null && ((Boolean)diskStatus.diskProps.get("enabled")).booleanValue()) continue;
                if (diskStatus.module.isEnabled()) {
                    throw new IllegalStateException("Already enabled: " + diskStatus.module);
                }
                hashSet.add(diskStatus.module);
            }
            if (LOG.isLoggable(Level.FINEST)) {
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    Module module = (Module)iterator.next();
                    LOG.log(Level.FINEST, "About to enable {0}", module);
                }
            }
            ModuleList.this.installNew(hashSet);
        }

        private void stepDisable(Map<String, Map<String, Object>> map) throws IOException {
            String string;
            LOG.fine("ModuleList: stepDisable");
            HashSet<Object> hashSet = new HashSet<Object>();
            for (Map.Entry<String, Map<String, Object>> object2 : map.entrySet()) {
                string = object2.getKey();
                Map<String, Object> map2 = object2.getValue();
                if (map2.get("enabled") != null && ((Boolean)map2.get("enabled")).booleanValue()) continue;
                DiskStatus diskStatus = (DiskStatus)ModuleList.this.statuses.get(string);
                assert (diskStatus != null) : string;
                if (!Boolean.TRUE.equals(diskStatus.diskProps.get("enabled"))) continue;
                if (!diskStatus.module.isEnabled()) {
                    throw new IllegalStateException("Already disabled: " + diskStatus.module);
                }
                hashSet.add(diskStatus.module);
            }
            if (hashSet.isEmpty()) {
                return;
            }
            List list = ModuleList.this.mgr.simulateDisable(hashSet);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                string = (Module)iterator.next();
                if (string.isAutoload() || string.isEager() || hashSet.contains(string)) continue;
                hashSet.add(string);
            }
            ModuleList.this.mgr.disable(hashSet);
        }

        private void stepDelete(Map<String, FileObject> map) throws IOException {
            Module module;
            Module module22;
            Object object;
            Object object2;
            LOG.fine("ModuleList: stepDelete");
            HashSet<Module> hashSet = new HashSet<Module>();
            Iterator iterator = ModuleList.this.statuses.entrySet().iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                object = (String)object2.getKey();
                module22 = (DiskStatus)object2.getValue();
                if (map.containsKey(object)) continue;
                module = module22.module;
                hashSet.add(module);
                iterator.remove();
            }
            if (hashSet.isEmpty()) {
                return;
            }
            object2 = new HashSet();
            for (Module module22 : hashSet) {
                if (!module22.isEnabled() || module22.isAutoload() || module22.isEager()) continue;
                object2.add(module22);
            }
            object = ModuleList.this.mgr.simulateDisable((Set)object2);
            module22 = object.iterator();
            while (module22.hasNext()) {
                module = (Module)module22.next();
                if (module.isAutoload() || module.isEager() || object2.contains(module)) continue;
                object2.add(module);
            }
            ModuleList.this.mgr.disable((Set)object2);
            module22 = hashSet.iterator();
            while (module22.hasNext()) {
                module = (Module)module22.next();
                if (module.isEnabled()) {
                    if (!module.isAutoload() && !module.isEager()) {
                        throw new IllegalStateException("Module " + module + " scheduled for deletion could not be disabled yet was not an autoload nor eager");
                    }
                    ModuleList.this.ev.log("cantDeleteEnabledAutoload", new Object[]{module});
                    module22.remove();
                    continue;
                }
                ModuleList.this.mgr.delete(module);
            }
        }

        private void stepCheckMisc(Map<String, Map<String, Object>> map) {
            LOG.fine("ModuleList: stepCheckMisc");
            String[] stringArray = new String[]{"jar", "autoload", "eager"};
            for (Map.Entry<String, Map<String, Object>> entry : map.entrySet()) {
                String string = entry.getKey();
                Map<String, Object> map2 = entry.getValue();
                DiskStatus diskStatus = (DiskStatus)ModuleList.this.statuses.get(string);
                assert (diskStatus != null) : string;
                Map<String, Object> map3 = diskStatus.diskProps;
                for (int i = 0; i < stringArray.length; ++i) {
                    Object object;
                    String string2 = stringArray[i];
                    Object object2 = map2.get(string2);
                    if (BaseUtilities.compareObjects((Object)object2, (Object)(object = map3.get(string2)))) continue;
                    ModuleList.this.ev.log("miscPropMismatch", new Object[]{diskStatus.module, string2, object2, object});
                }
            }
        }

        private void stepCheckSer(Map map, Map map2) {
        }

        private void stepUpdateProps(Map<String, Map<String, Object>> map) {
            LOG.fine("ModuleList: stepUpdateProps");
            for (Map.Entry<String, Map<String, Object>> entry : map.entrySet()) {
                String string = entry.getKey();
                DiskStatus diskStatus = (DiskStatus)ModuleList.this.statuses.get(string);
                if (diskStatus == null) continue;
                Map<String, Object> map2 = entry.getValue();
                diskStatus.setDiskProps(map2);
            }
        }

        private void stepMarkClean() {
            LOG.fine("ModuleList: stepMarkClean");
            for (DiskStatus diskStatus : ModuleList.this.statuses.values()) {
                diskStatus.dirty = false;
            }
        }
    }
}

