/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.application;

import java.lang.management.ManagementFactory;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.ApplicationDescriptorProvider;
import org.graalvm.visualvm.application.ApplicationsSorting;
import org.graalvm.visualvm.application.GeneralPropertiesProvider;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptor;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import org.graalvm.visualvm.core.model.ModelProvider;
import org.graalvm.visualvm.core.properties.PropertiesProvider;
import org.graalvm.visualvm.core.properties.PropertiesSupport;
import org.graalvm.visualvm.host.Host;
import org.graalvm.visualvm.host.LocalHostDescriptor;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

final class ApplicationSupport {
    private static ApplicationSupport instance;

    public static synchronized ApplicationSupport getInstance() {
        if (instance == null) {
            instance = new ApplicationSupport();
        }
        return instance;
    }

    Application createCurrentApplication() {
        String selfName = ManagementFactory.getRuntimeMXBean().getName();
        Integer selfPid = Integer.valueOf(selfName.substring(0, selfName.indexOf(64)));
        return new CurrentApplication(selfPid, Host.LOCALHOST, Host.LOCALHOST.getHostName() + "-" + selfPid);
    }

    private void initCurrentApplication() {
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        DataSourceDescriptor localHostDescriptor = DataSourceDescriptorFactory.getDescriptor((DataSource)Host.LOCALHOST);
                        if (localHostDescriptor instanceof LocalHostDescriptor) {
                            ((LocalHostDescriptor)localHostDescriptor).setChildrenComparator(ApplicationsSorting.instance().getInitialSorting());
                        }
                        Host.LOCALHOST.getRepository().addDataSource((DataSource)Application.CURRENT_APPLICATION);
                    }
                });
            }
        });
    }

    private ApplicationSupport() {
        DataSourceDescriptorFactory descriptorFactory = DataSourceDescriptorFactory.getDefault();
        descriptorFactory.registerProvider((ModelProvider)new ApplicationDescriptorProvider());
        PropertiesSupport.sharedInstance().registerPropertiesProvider((PropertiesProvider)new GeneralPropertiesProvider(), CurrentApplication.class);
        this.initCurrentApplication();
    }

    class CurrentApplication
    extends Application {
        private int selfPid;

        private CurrentApplication(int selfPid, Host host, String id) {
            super(host, id);
            this.selfPid = selfPid;
        }

        @Override
        public int getPid() {
            return this.selfPid;
        }
    }
}

