/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.application.type;

import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.type.ApplicationType;
import org.graalvm.visualvm.application.type.DefaultApplicationType;
import org.graalvm.visualvm.application.type.EclipseApplicationTypeFactory;
import org.graalvm.visualvm.application.type.IntellijApplicationTypeFactory;
import org.graalvm.visualvm.application.type.JDeveloperApplicationTypeFactory;
import org.graalvm.visualvm.application.type.JavaPluginApplicationTypeFactory;
import org.graalvm.visualvm.application.type.JavaWebStartApplicationTypeFactory;
import org.graalvm.visualvm.application.type.MainClassApplicationTypeFactory;
import org.graalvm.visualvm.application.type.MavenApplicationTypeFactory;
import org.graalvm.visualvm.application.type.NetBeansApplicationTypeFactory;
import org.graalvm.visualvm.core.model.ModelFactory;
import org.graalvm.visualvm.core.model.ModelProvider;

public final class ApplicationTypeFactory
extends ModelFactory<ApplicationType, Application>
implements ModelProvider<ApplicationType, Application> {
    private static ApplicationTypeFactory appTypeFactory;

    private ApplicationTypeFactory() {
    }

    public static synchronized ApplicationTypeFactory getDefault() {
        if (appTypeFactory == null) {
            appTypeFactory = new ApplicationTypeFactory();
            appTypeFactory.registerProvider(appTypeFactory);
            appTypeFactory.registerProvider((ModelProvider)new MainClassApplicationTypeFactory());
            appTypeFactory.registerProvider((ModelProvider)new NetBeansApplicationTypeFactory());
            appTypeFactory.registerProvider((ModelProvider)new JavaPluginApplicationTypeFactory());
            appTypeFactory.registerProvider((ModelProvider)new JavaWebStartApplicationTypeFactory());
            appTypeFactory.registerProvider((ModelProvider)new JDeveloperApplicationTypeFactory());
            appTypeFactory.registerProvider((ModelProvider)new MavenApplicationTypeFactory());
            appTypeFactory.registerProvider((ModelProvider)new IntellijApplicationTypeFactory());
            appTypeFactory.registerProvider((ModelProvider)new EclipseApplicationTypeFactory());
        }
        return appTypeFactory;
    }

    public static ApplicationType getApplicationTypeFor(Application app) {
        return (ApplicationType)ApplicationTypeFactory.getDefault().getModel(app);
    }

    public ApplicationType createModelFor(Application app) {
        return new DefaultApplicationType(app);
    }
}

