/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.application.type;

import java.awt.Image;
import java.util.Properties;
import java.util.Set;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.application.type.ApplicationType;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class NetBeansBasedApplicationType
extends ApplicationType {
    Application application;
    String name;
    String branding;
    Set<String> clusters;
    String fullVersionString;

    NetBeansBasedApplicationType(Application app, Jvm jvm, Set<String> cls, String br) {
        Properties p;
        this.application = app;
        this.clusters = cls;
        this.branding = br;
        if (jvm.isGetSystemPropertiesSupported() && (p = jvm.getSystemProperties()) != null) {
            this.fullVersionString = p.getProperty("netbeans.productversion");
        }
    }

    public Set<String> getClusters() {
        return this.clusters;
    }

    @Override
    public String getName() {
        if (this.fullVersionString != null) {
            String buildNo;
            int index = this.fullVersionString.indexOf("(");
            if (index != -1) {
                return this.fullVersionString.substring(0, index).trim();
            }
            index = this.fullVersionString.lastIndexOf(" ");
            if (index != -1 && (buildNo = this.fullVersionString.substring(index + 1)).length() > 19 && buildNo.charAt(8) == '-') {
                return this.fullVersionString.substring(0, index);
            }
            return this.fullVersionString;
        }
        return NbBundle.getMessage(NetBeansBasedApplicationType.class, (String)"LBL_NbPlatformApplication");
    }

    @Override
    public String getVersion() {
        return NbBundle.getMessage(NetBeansBasedApplicationType.class, (String)"LBL_Unknown");
    }

    @Override
    public String getDescription() {
        if (this.fullVersionString != null) {
            return this.fullVersionString;
        }
        return NbBundle.getMessage(NetBeansBasedApplicationType.class, (String)"DESCR_NetBeansBasedApplicationType");
    }

    @Override
    public Image getIcon() {
        String iconPath = "org/graalvm/visualvm/application/type/resources/NetBeansPlatform.png";
        return ImageUtilities.loadImage((String)iconPath, (boolean)true);
    }
}

