/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.jdk11;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.posix.headers.ZLib;
import com.oracle.svm.core.posix.jdk11.Target_java_util_zip_Inflater;
import java.util.zip.DataFormatException;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.WordFactory;

final class Util_java_util_zip_Inflater {
    Util_java_util_zip_Inflater() {
    }

    static long doInflate(Object obj, long addr, CCharPointer input, int inputLen, CCharPointer output, int outputLen) throws DataFormatException {
        Target_java_util_zip_Inflater instance = SubstrateUtil.cast(obj, Target_java_util_zip_Inflater.class);
        ZLib.z_stream strm = (ZLib.z_stream)WordFactory.pointer((long)addr);
        int inputUsed = 0;
        int outputUsed = 0;
        strm.set_next_in(input);
        strm.set_next_out(output);
        strm.set_avail_in(inputLen);
        strm.set_avail_out(outputLen);
        int ret = ZLib.inflate(strm, ZLib.Z_PARTIAL_FLUSH());
        int finished = 0;
        int needDict = 0;
        if (ret == ZLib.Z_STREAM_END() || ret == ZLib.Z_OK()) {
            if (ret == ZLib.Z_STREAM_END()) {
                finished = 1;
            }
            inputUsed = inputLen - strm.avail_in();
            outputUsed = outputLen - strm.avail_out();
        } else if (ret == ZLib.Z_NEED_DICT()) {
            needDict = 1;
            inputUsed = inputLen - strm.avail_in();
            outputUsed = outputLen - strm.avail_out();
        } else {
            if (ret == ZLib.Z_DATA_ERROR()) {
                instance.inputConsumed = inputLen - strm.avail_in();
                instance.outputConsumed = outputLen - strm.avail_out();
                throw new DataFormatException(CTypeConversion.toJavaString((CCharPointer)strm.msg()));
            }
            if (ret == ZLib.Z_MEM_ERROR()) {
                throw new OutOfMemoryError();
            }
            if (ret != ZLib.Z_BUF_ERROR()) {
                throw new InternalError(CTypeConversion.toJavaString((CCharPointer)strm.msg()));
            }
        }
        return (long)inputUsed | (long)outputUsed << 31 | (long)finished << 62 | (long)needDict << 63;
    }
}

