/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Target_java_util_concurrent_locks_AbstractOwnableSynchronizer;
import com.oracle.svm.core.Target_java_util_concurrent_locks_AbstractQueuedSynchronizer_ConditionObject;
import com.oracle.svm.core.Target_java_util_concurrent_locks_ReentrantLock;
import com.oracle.svm.core.Target_java_util_concurrent_locks_ReentrantLock_NonfairSync;
import com.oracle.svm.core.Target_java_util_concurrent_locks_ReentrantLock_Sync;
import com.oracle.svm.core.WeakIdentityHashMap;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.ThreadingSupportImpl;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMOperationControl;
import com.oracle.svm.core.util.VMError;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import org.graalvm.compiler.word.BarrieredAccess;
import org.graalvm.nativeimage.ImageSingletons;
import sun.misc.Unsafe;

public class MonitorSupport {
    private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();
    private final Map<Object, ReentrantLock> additionalMonitors = new WeakIdentityHashMap<Object, ReentrantLock>();
    private final ReentrantLock additionalMonitorsLock = new ReentrantLock();
    private final Map<Object, Condition> additionalConditions = new WeakIdentityHashMap<Object, Condition>();
    private final ReentrantLock additionalConditionsLock = new ReentrantLock();

    public static int maybeAdjustNewParkStatus(int status) {
        Object blocker = LockSupport.getBlocker(Thread.currentThread());
        if (MonitorSupport.isMonitorCondition(blocker)) {
            if (status == 673) {
                return 417;
            }
            return 401;
        }
        if (MonitorSupport.isMonitorLockSynchronizer(blocker)) {
            return 1025;
        }
        return status;
    }

    @SubstrateForeignCallTarget
    @Uninterruptible(reason="Avoid stack overflow error before yellow zone has been activated", calleeMustBe=false)
    public static void monitorEnter(Object obj) {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            VMOperationControl.guaranteeOkayToBlock("No Java synchronization must be performed within a VMOperation: if the object is already locked, the VM is at a deadlock");
            ThreadingSupportImpl.pauseRecurringCallback("No exception must flow out of the monitor code.");
            try {
                MonitorSupport.monitorEnterWithoutBlockingCheck(obj);
            }
            finally {
                ThreadingSupportImpl.resumeRecurringCallbackAtNextSafepoint();
            }
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    @RestrictHeapAccess(reason="No longer uninterruptible", overridesCallers=true, access=RestrictHeapAccess.Access.UNRESTRICTED)
    public static void monitorEnterWithoutBlockingCheck(Object obj) {
        assert (ThreadingSupportImpl.isRecurringCallbackPaused());
        assert (obj != null);
        if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return;
        }
        ReentrantLock lockObject = null;
        try {
            lockObject = ((MonitorSupport)ImageSingletons.lookup(MonitorSupport.class)).getOrCreateMonitor(obj, true);
            lockObject.lock();
        }
        catch (Throwable ex) {
            throw VMError.shouldNotReachHere("Unexpected exception in MonitorSupport.monitorEnter", ex);
        }
    }

    @SubstrateForeignCallTarget
    @Uninterruptible(reason="Avoid stack overflow error before yellow zone has been activated", calleeMustBe=false)
    public static void monitorExit(Object obj) {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            ThreadingSupportImpl.pauseRecurringCallback("No exception must flow out of the monitor code.");
            try {
                MonitorSupport.monitorExit0(obj);
            }
            finally {
                ThreadingSupportImpl.resumeRecurringCallbackAtNextSafepoint();
            }
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    @RestrictHeapAccess(reason="No longer uninterruptible", overridesCallers=true, access=RestrictHeapAccess.Access.UNRESTRICTED)
    private static void monitorExit0(Object obj) {
        assert (ThreadingSupportImpl.isRecurringCallbackPaused());
        assert (obj != null);
        if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return;
        }
        ReentrantLock lockObject = null;
        try {
            lockObject = ((MonitorSupport)ImageSingletons.lookup(MonitorSupport.class)).getOrCreateMonitor(obj, true);
            lockObject.unlock();
        }
        catch (Throwable ex) {
            throw VMError.shouldNotReachHere("Unexpected exception in MonitorSupport.monitorExit", ex);
        }
    }

    public void setExclusiveOwnerThread(Object obj, Thread thread) {
        assert (obj != null);
        VMOperation.guaranteeInProgress("patching a lock while not being at a safepoint is too dangerous");
        if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return;
        }
        Target_java_util_concurrent_locks_ReentrantLock lock = SubstrateUtil.cast(this.getOrCreateMonitor(obj, true), Target_java_util_concurrent_locks_ReentrantLock.class);
        Target_java_util_concurrent_locks_AbstractOwnableSynchronizer sync = SubstrateUtil.cast(lock.sync, Target_java_util_concurrent_locks_AbstractOwnableSynchronizer.class);
        VMError.guarantee(sync.getExclusiveOwnerThread() != null, "Cannot patch the exclusiveOwnerThread of an object that is not locked");
        sync.setExclusiveOwnerThread(thread);
    }

    public boolean holdsLock(Object obj) {
        assert (obj != null);
        if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return true;
        }
        ReentrantLock lockObject = this.getOrCreateMonitor(obj, false);
        return lockObject != null && lockObject.isHeldByCurrentThread();
    }

    @SuppressFBWarnings(value={"WA_AWAIT_NOT_IN_LOOP"}, justification="This method is a wait implementation.")
    public void wait(Object obj, long timeoutMillis) throws InterruptedException {
        assert (obj != null);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (timeoutMillis < 0L) {
            throw new IllegalArgumentException("Timeout is negative.");
        }
        if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            Thread.sleep(timeoutMillis == 0L ? Long.MAX_VALUE : timeoutMillis);
            return;
        }
        ReentrantLock lock = this.ensureLocked(obj);
        Condition condition = this.getOrCreateCondition(obj, lock, true);
        if (timeoutMillis == 0L) {
            condition.await();
        } else {
            condition.await(timeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    public void notify(Object obj, boolean notifyAll) {
        assert (obj != null);
        if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return;
        }
        ReentrantLock lock = this.ensureLocked(obj);
        Condition condition = this.getOrCreateCondition(obj, lock, false);
        if (condition != null) {
            if (notifyAll) {
                condition.signalAll();
            } else {
                condition.signal();
            }
        }
    }

    private ReentrantLock ensureLocked(Object receiver) {
        ReentrantLock lockObject = this.getOrCreateMonitor(receiver, false);
        if (lockObject == null || !lockObject.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException("Receiver is not locked by the current thread.");
        }
        return lockObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReentrantLock getOrCreateMonitor(Object obj, boolean createIfNotExisting) {
        DynamicHub hub = ObjectHeader.readDynamicHubFromObject(obj);
        int monitorOffset = hub.getMonitorOffset();
        if (monitorOffset != 0) {
            ReentrantLock existingMonitor = KnownIntrinsics.convertUnknownValue(BarrieredAccess.readObject((Object)obj, (int)monitorOffset), ReentrantLock.class);
            if (existingMonitor != null || !createIfNotExisting) {
                assert (existingMonitor == null || MonitorSupport.isMonitorLock(existingMonitor));
                return existingMonitor;
            }
            ReentrantLock newMonitor = MonitorSupport.newMonitorLock();
            if (UNSAFE.compareAndSwapObject(obj, monitorOffset, null, newMonitor)) {
                return newMonitor;
            }
            return KnownIntrinsics.convertUnknownValue(BarrieredAccess.readObject((Object)obj, (int)monitorOffset), ReentrantLock.class);
        }
        this.additionalMonitorsLock.lock();
        try {
            ReentrantLock existingEntry = this.additionalMonitors.get(obj);
            if (existingEntry != null) {
                assert (MonitorSupport.isMonitorLock(existingEntry));
                ReentrantLock newMonitor = existingEntry;
                return newMonitor;
            }
            if (!createIfNotExisting) {
                ReentrantLock newMonitor = null;
                return newMonitor;
            }
            ReentrantLock newEntry = MonitorSupport.newMonitorLock();
            ReentrantLock previousEntry = this.additionalMonitors.put(obj, newEntry);
            VMError.guarantee(previousEntry == null, "MonitorSupport.getOrCreateMonitor: Replaced monitor");
            ReentrantLock reentrantLock = newEntry;
            return reentrantLock;
        }
        finally {
            this.additionalMonitorsLock.unlock();
        }
    }

    private static ReentrantLock newMonitorLock() {
        ReentrantLock newMonitor = new ReentrantLock();
        SubstrateUtil.cast((Object)newMonitor, Target_java_util_concurrent_locks_ReentrantLock.class).sync.isObjectMonitor = true;
        assert (MonitorSupport.isMonitorLock(newMonitor));
        return newMonitor;
    }

    private static boolean isMonitorLock(ReentrantLock lock) {
        return lock != null && MonitorSupport.isMonitorLockSynchronizer(SubstrateUtil.cast((Object)lock, Target_java_util_concurrent_locks_ReentrantLock.class).sync);
    }

    private static boolean isMonitorLockSynchronizer(Object obj) {
        return obj != null && obj.getClass() == Target_java_util_concurrent_locks_ReentrantLock_NonfairSync.class && ((Target_java_util_concurrent_locks_ReentrantLock_Sync)obj).isObjectMonitor;
    }

    public ReentrantLock getMonitorForTesting(Object obj) {
        return this.getOrCreateMonitor(obj, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Condition getOrCreateCondition(Object obj, ReentrantLock lock, boolean createIfNotExisting) {
        this.additionalConditionsLock.lock();
        try {
            Condition existingEntry = this.additionalConditions.get(obj);
            if (existingEntry != null) {
                assert (MonitorSupport.isMonitorCondition(existingEntry));
                Condition condition = existingEntry;
                return condition;
            }
            if (!createIfNotExisting) {
                Condition condition = null;
                return condition;
            }
            Condition newEntry = MonitorSupport.newMonitorCondition(lock);
            Condition previousEntry = this.additionalConditions.put(obj, newEntry);
            VMError.guarantee(previousEntry == null, "MonitorSupport.getOrCreateCondition: Replaced condition");
            Condition condition = newEntry;
            return condition;
        }
        finally {
            this.additionalConditionsLock.unlock();
        }
    }

    private static Condition newMonitorCondition(ReentrantLock lock) {
        Condition condition = lock.newCondition();
        SubstrateUtil.cast((Object)condition, Target_java_util_concurrent_locks_AbstractQueuedSynchronizer_ConditionObject.class).isObjectMonitorCondition = true;
        assert (MonitorSupport.isMonitorCondition(condition));
        return condition;
    }

    private static boolean isMonitorCondition(Object obj) {
        return obj != null && obj.getClass() == Target_java_util_concurrent_locks_AbstractQueuedSynchronizer_ConditionObject.class && ((Target_java_util_concurrent_locks_AbstractQueuedSynchronizer_ConditionObject)obj).isObjectMonitorCondition;
    }
}

