/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.CardTable;
import com.oracle.svm.core.genscavenge.DiscoverableReferenceProcessing;
import com.oracle.svm.core.genscavenge.Generation;
import com.oracle.svm.core.genscavenge.HeapChunkProvider;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapOptions;
import com.oracle.svm.core.genscavenge.HeapPolicy;
import com.oracle.svm.core.genscavenge.HeapVerifier;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.OldGeneration;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.SpaceVerifierImpl;
import com.oracle.svm.core.genscavenge.ThreadLocalAllocation;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.YoungGeneration;
import com.oracle.svm.core.heap.DiscoverableReference;
import com.oracle.svm.core.heap.NativeImageInfo;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.InteriorObjRefWalker;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.VMOperation;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public class HeapVerifierImpl
implements HeapVerifier {
    private final SpaceVerifierImpl spaceVerifier = SpaceVerifierImpl.factory();
    private String cause = "Too soon to tell";
    private CardTable.ReferenceToYoungObjectVisitor referenceToYoungObjectVisitor;
    private final Log witnessLog;
    private static final NoReferencesOutsideHeapVisitor noReferencesOutsideHeapVisitor = new NoReferencesOutsideHeapVisitor();
    private static final NoReferencesToForwardedObjectsVisitor noReferencesToForwardedObjectsVisitor = new NoReferencesToForwardedObjectsVisitor();

    protected HeapVerifierImpl() {
        CardTable.ReferenceToYoungObjectReferenceVisitor refToYoungObjectReferenceVisitor = new CardTable.ReferenceToYoungObjectReferenceVisitor();
        this.referenceToYoungObjectVisitor = new CardTable.ReferenceToYoungObjectVisitor(refToYoungObjectReferenceVisitor);
        this.witnessLog = Log.log();
    }

    public static HeapVerifierImpl factory() {
        return new HeapVerifierImpl();
    }

    @Override
    public String getCause() {
        return this.cause;
    }

    @Override
    public void setCause(String causeArg) {
        this.cause = causeArg;
    }

    @Override
    public boolean verifyObjectAt(Pointer ptr) {
        VMOperation.guaranteeInProgress("Can only verify from a VMOperation.");
        Log trace = this.getTraceLog();
        trace.string("[HeapVerifierImpl.verifyObjectAt:").string("  ptr: ").hex((WordBase)ptr);
        if (ptr.isNull()) {
            this.getWitnessLog().string("[verifyObjectAt(objRef: ").hex((WordBase)ptr).string(")").string("  null ptr").string("]").newline();
            return false;
        }
        if (!HeapVerifierImpl.slowlyFindPointer(ptr)) {
            this.getWitnessLog().string("[HeapVerifierImpl.verifyObjectAt:").string("  ptr: ").hex((WordBase)ptr).string("  is not in heap.").string("]").newline();
            return false;
        }
        UnsignedWord header = ObjectHeaderImpl.readHeaderFromPointerCarefully(ptr);
        trace.string("  header: ").hex((WordBase)header);
        ObjectHeaderImpl ohi = ObjectHeaderImpl.getObjectHeaderImpl();
        if (ohi.isForwardedHeader(header)) {
            Object obj = ohi.getForwardedObject(ptr);
            Word op = Word.objectToUntrackedPointer((Object)obj);
            trace.string("  forwards to ").hex((WordBase)op).newline();
            if (!this.verifyObjectAt((Pointer)op)) {
                this.getWitnessLog().string("[HeapVerifierImpl.verifyObjectAt(objRef: ").hex((WordBase)ptr).string(")").string("  forwarded object fails to verify").string("]").newline();
                return false;
            }
        } else {
            Object obj = ptr.toObject();
            trace.string("  obj: ").hex((WordBase)Word.objectToUntrackedPointer((Object)obj)).string("  obj.getClass: ").string(obj.getClass().getName()).string("  objectHeader: ").string(ohi.toStringFromObject(obj));
            DynamicHub hub = ObjectHeaderImpl.readDynamicHubFromObjectCarefully(obj);
            if (!hub.getClass().getName().equals("java.lang.Class")) {
                this.getWitnessLog().string("[HeapVerifierImpl.verifyObjectAt(objRef: ").hex((WordBase)ptr).string(")").string("  hub is not a class").string("]").newline();
                return false;
            }
            if (HeapVerifierImpl.slowlyFindObjectInBootImage(obj)) {
                if (!ohi.isBootImageCarefully(obj)) {
                    try (Log witness = this.getWitnessLog();){
                        witness.string("[HeapVerifierImpl.verifyObjectAt(objRef: ").hex((WordBase)ptr).string(")").string("  obj: ").object(obj);
                        witness.string("  header: ").string(ohi.toStringFromHeader(header)).string("  native image object but not native image object header").string("]").newline();
                    }
                    return false;
                }
            } else if (ohi.isNonHeapAllocatedCarefully(obj)) {
                try (Log witness = this.getWitnessLog();){
                    witness.string("[HeapVerifierImpl.verifyObjectAt(objRef: ").hex((WordBase)ptr).string(")").string("  obj: ").object(obj);
                    witness.string("  header: ").string(ohi.toStringFromHeader(header)).string("  Not native image, but not heap allocated.").string("]").newline();
                }
                return false;
            }
            trace.newline();
            if (!this.noReferencesOutsideHeap(obj)) {
                this.getWitnessLog().string("[HeapVerifierImpl.verifyObjectAt(objRef: ").hex((WordBase)ptr).string(")").string("  contains references outside the heap").string("]").newline();
                return false;
            }
            if (!this.noReferencesToForwardedObjectsVerifier(obj)) {
                this.getWitnessLog().string("[HeapVerifierImpl.verifyObjectAt(objRef: ").hex((WordBase)ptr).string(")").string("  contains references to forwarded objects").string("]").newline();
                return false;
            }
            if (!HeapVerifierImpl.verifyDiscoverableReference(obj)) {
                this.getWitnessLog().string("[HeapVerifierImpl.verifyObjectAt(objRef: ").hex((WordBase)ptr).string(")").string("  DiscoverableReference fails to verify.").string("]").newline();
                return false;
            }
        }
        trace.string("  returns true]").newline();
        return true;
    }

    @Override
    public boolean verify(String message) {
        VerifyVMOperation verifyOperation = new VerifyVMOperation(message, this, HeapVerifier.Occasion.BEFORE_COLLECTION);
        verifyOperation.enqueue();
        return verifyOperation.getResult();
    }

    boolean verifyOperation(String message, HeapVerifier.Occasion occasion) {
        VMOperation.guaranteeInProgress("Can only verify from a VMOperation.");
        Log trace = this.getTraceLog();
        trace.string("[HeapVerifierImpl.verify ").string(" occasion: ").string(occasion.name()).string(" cause: ").string(message).string(":");
        trace.newline();
        this.setCause(message);
        ThreadLocalAllocation.disableThreadLocalAllocation();
        boolean result = true;
        if (!this.verifyBootImageObjects()) {
            this.getWitnessLog().string("[HeapVerifierImpl.verify:").string("  native image fails to verify").string("]").newline();
            result = false;
        }
        if (!HeapVerifierImpl.verifyYoungGeneration(occasion)) {
            this.getWitnessLog().string("[HeapVerifierImpl.verify:").string("  young generation fails to verify").string("]").newline();
            result = false;
        }
        if (!HeapVerifierImpl.verifyOldGeneration(occasion)) {
            this.getWitnessLog().string("[HeapVerifierImpl.verify:").string("  old generation fails to verify").string("]").newline();
            result = false;
        }
        trace.string("  returns: ").bool(result).string("]").newline();
        if (!result && HeapOptions.HeapVerificationFailureIsFatal.getValue().booleanValue()) {
            HeapVerifier.HeapVerificationError.throwError();
        }
        return result;
    }

    @Override
    public Log getTraceLog() {
        return HeapOptions.TraceHeapVerification.getValue() != false ? Log.log() : Log.noopLog();
    }

    @Override
    public Log getWitnessLog() {
        return this.witnessLog;
    }

    private boolean verifyBootImageObjects() {
        boolean ropResult = this.verifyBootImageObjects(NativeImageInfo.firstReadOnlyPrimitiveObject, NativeImageInfo.lastReadOnlyPrimitiveObject);
        boolean rorResult = this.verifyBootImageObjects(NativeImageInfo.firstReadOnlyReferenceObject, NativeImageInfo.lastReadOnlyReferenceObject);
        boolean rwpResult = this.verifyBootImageObjects(NativeImageInfo.firstWritablePrimitiveObject, NativeImageInfo.lastWritablePrimitiveObject);
        boolean rwrResult = this.verifyBootImageObjects(NativeImageInfo.firstWritableReferenceObject, NativeImageInfo.lastWritableReferenceObject);
        return ropResult && rorResult && rwpResult && rwrResult;
    }

    private boolean verifyBootImageObjects(Object firstObject, Object lastObject) {
        Log trace = this.getTraceLog();
        trace.string("[HeapVerifierImpl.verifyBootImageObjects:").newline();
        Word firstPointer = Word.objectToUntrackedPointer((Object)firstObject);
        Word lastPointer = Word.objectToUntrackedPointer((Object)lastObject);
        trace.string("  [ firstPointer: ").hex((WordBase)firstPointer).string("  .. lastPointer: ").hex((WordBase)lastPointer).string(" ]").newline();
        if (firstObject == null || lastObject == null) {
            trace.string("  returns: true because boundary object is null").string("]").newline();
            return true;
        }
        boolean result = true;
        Word currentPointer = firstPointer;
        while (currentPointer.belowOrEqual((UnsignedWord)lastPointer)) {
            Log witness;
            Object currentObject = currentPointer.toObject();
            if (!ObjectHeaderImpl.getObjectHeaderImpl().isNonHeapAllocatedCarefully(currentObject)) {
                result = false;
                witness = this.getWitnessLog();
                try {
                    witness.string("[HeapVerifierImpl.verifyBootImageObjects:").string("  [ firstPointer: ").hex((WordBase)firstPointer).string("  .. lastPointer: ").hex((WordBase)lastPointer).string(" ]");
                    witness.string("  current: ").hex((WordBase)currentPointer).string("  object is not NonHeapAllocated").string("]").newline();
                }
                finally {
                    if (witness != null) {
                        witness.close();
                    }
                }
            }
            if (!this.verifyObjectAt((Pointer)currentPointer)) {
                result = false;
                witness = this.getWitnessLog();
                try {
                    witness.string("[HeapVerifierImpl.verifyBootImageObjects:").string("  [ firstPointer: ").hex((WordBase)firstPointer).string("  .. lastPointer: ").hex((WordBase)lastPointer).string(" ]");
                    witness.string("  current: ").hex((WordBase)currentPointer).string("  object does not verify").string("]").newline();
                }
                finally {
                    if (witness != null) {
                        witness.close();
                    }
                }
            }
            currentPointer = LayoutEncoding.getObjectEnd(currentObject);
        }
        trace.string("  returns: ").bool(result).string("]").newline();
        return true;
    }

    private static boolean verifyYoungGeneration(HeapVerifier.Occasion occasion) {
        YoungGeneration youngGeneration = HeapImpl.getHeapImpl().getYoungGeneration();
        return ((Generation)youngGeneration).verify(occasion);
    }

    private static boolean verifyOldGeneration(HeapVerifier.Occasion occasion) {
        OldGeneration oldGeneration = HeapImpl.getHeapImpl().getOldGeneration();
        return oldGeneration.verify(occasion);
    }

    private boolean noReferencesOutsideHeap(Object obj) {
        Log trace = this.getTraceLog();
        trace.string("[HeapVerifierImpl.noReferencesToZappedObjectsVerifier:");
        trace.string("  obj: ").object(obj).string("  obj.getClass: ").string(obj.getClass().getName());
        ObjectHeaderImpl ohi = ObjectHeaderImpl.getObjectHeaderImpl();
        UnsignedWord header = ObjectHeaderImpl.readHeaderFromObjectCarefully(obj);
        trace.string("  header: ").hex((WordBase)header).string("  objectHeader: ").string(ohi.toStringFromObject(obj));
        Word objPointer = Word.objectToUntrackedPointer((Object)obj);
        trace.string("  objPointer: ").hex((WordBase)objPointer);
        boolean result = InteriorObjRefWalker.walkObject(obj, noReferencesOutsideHeapVisitor);
        if (!result) {
            try (Log witness = this.getWitnessLog();){
                witness.string("[HeapVerifierImpl.noReferencesOutsideHeap:").string("  cause: ").string(this.getCause());
                witness.string("  obj: ").string(obj.getClass().getName()).string("@").hex((WordBase)objPointer);
                witness.string("  header: ").hex((WordBase)header).string("  objectHeader: ").string(ohi.toStringFromObject(obj)).string("]").newline();
            }
        }
        trace.string("  returns: ").bool(result).string("]").newline();
        return result;
    }

    private boolean noReferencesToForwardedObjectsVerifier(Object obj) {
        Log trace = this.getTraceLog();
        trace.string("[HeapVerifierImpl.noReferencesToForwardedObjectsVerifier:");
        trace.string("  obj: ").object(obj);
        UnsignedWord header = ObjectHeaderImpl.readHeaderFromObjectCarefully(obj);
        trace.string("  header: ").hex((WordBase)header);
        Word objPointer = Word.objectToUntrackedPointer((Object)obj);
        trace.string("  objPointer: ").hex((WordBase)objPointer);
        boolean result = InteriorObjRefWalker.walkObject(obj, noReferencesToForwardedObjectsVisitor);
        if (!result) {
            try (Log witness = this.getWitnessLog();){
                witness.string("[HeapVerifierImpl.noReferencesToForwardedObjectsVerifier:").string("  cause: ").string(this.getCause()).string("  obj: ").object(obj).string("]").newline();
            }
        }
        trace.string("]").newline();
        return result;
    }

    private static boolean verifyDiscoverableReference(Object object) {
        boolean result = true;
        Object obj = KnownIntrinsics.convertUnknownValue(object, Object.class);
        if (obj instanceof DiscoverableReference) {
            DiscoverableReference dr = (DiscoverableReference)obj;
            result = DiscoverableReferenceProcessing.verify(dr);
        }
        return result;
    }

    static boolean slowlyFindPointer(Pointer p) {
        if (HeapVerifierImpl.slowlyFindPointerInBootImage(p)) {
            return true;
        }
        HeapImpl heap = HeapImpl.getHeapImpl();
        if (HeapVerifierImpl.slowlyFindPointerInYoungGeneration(p)) {
            return true;
        }
        if (HeapVerifierImpl.slowlyFindPointerInOldGeneration(p)) {
            return true;
        }
        heap.getHeapVerifierImpl().getWitnessLog().string("[HeapVerifierImpl.slowlyFindPointer:").string("  did not find pointer in heap: ").hex((WordBase)p).string("]").newline();
        return false;
    }

    private static boolean slowlyFindObjectInBootImage(Object obj) {
        Word objectPointer = Word.objectToUntrackedPointer((Object)obj);
        return HeapVerifierImpl.slowlyFindPointerInBootImage((Pointer)objectPointer);
    }

    static boolean slowlyFindPointerInBootImage(Pointer objectPointer) {
        boolean result = false;
        result |= NativeImageInfo.isInReadOnlyPrimitivePartition(objectPointer);
        result |= NativeImageInfo.isInReadOnlyReferencePartition(objectPointer);
        result |= NativeImageInfo.isInWritablePrimitivePartition(objectPointer);
        return result |= NativeImageInfo.isInWritableReferencePartition(objectPointer);
    }

    private static boolean slowlyFindPointerInYoungGeneration(Pointer p) {
        HeapImpl heap = HeapImpl.getHeapImpl();
        YoungGeneration youngGen = heap.getYoungGeneration();
        return youngGen.slowlyFindPointer(p);
    }

    private static boolean slowlyFindPointerInOldGeneration(Pointer p) {
        HeapImpl heap = HeapImpl.getHeapImpl();
        OldGeneration oldGen = heap.getOldGeneration();
        return oldGen.slowlyFindPointer(p);
    }

    private static boolean slowlyFindPointerInUnusedSpace(Pointer p) {
        return HeapChunkProvider.get().slowlyFindPointer(p);
    }

    static boolean slowlyFindPointerInSpace(Space space, Pointer p, ChunkLimit chunkLimit) {
        AlignedHeapChunk.AlignedHeader aChunk = space.getFirstAlignedHeapChunk();
        while (aChunk.isNonNull()) {
            Pointer start = AlignedHeapChunk.getAlignedHeapChunkStart(aChunk);
            Pointer limit = chunkLimit == ChunkLimit.top ? aChunk.getTop() : aChunk.getEnd();
            boolean atLeast = start.belowOrEqual((UnsignedWord)p);
            boolean atMost = p.belowThan((UnsignedWord)limit);
            if (atLeast && atMost) {
                return true;
            }
            aChunk = (AlignedHeapChunk.AlignedHeader)aChunk.getNext();
        }
        UnalignedHeapChunk.UnalignedHeader uChunk = space.getFirstUnalignedHeapChunk();
        while (uChunk.isNonNull()) {
            Pointer start = UnalignedHeapChunk.getUnalignedHeapChunkStart(uChunk);
            Pointer limit = chunkLimit == ChunkLimit.top ? uChunk.getTop() : uChunk.getEnd();
            boolean atLeast = start.belowOrEqual((UnsignedWord)p);
            boolean atMost = p.belowThan((UnsignedWord)limit);
            if (atLeast && atMost) {
                return true;
            }
            uChunk = (UnalignedHeapChunk.UnalignedHeader)uChunk.getNext();
        }
        return false;
    }

    public static int classifyObject(Object o) {
        return HeapVerifierImpl.classifyPointer((Pointer)Word.objectToUntrackedPointer((Object)o));
    }

    static int classifyPointer(Pointer p) {
        HeapImpl heap = HeapImpl.getHeapImpl();
        YoungGeneration youngGen = heap.getYoungGeneration();
        OldGeneration oldGen = heap.getOldGeneration();
        if (p.isNull()) {
            return 0;
        }
        if (HeapVerifierImpl.slowlyFindPointerInBootImage(p)) {
            return 1;
        }
        if (youngGen.slowlyFindPointer(p)) {
            return 2;
        }
        int oldGenClassification = oldGen.classifyPointer(p);
        if (oldGenClassification > 0) {
            return 2 + oldGenClassification;
        }
        if (HeapVerifierImpl.slowlyFindPointerInUnusedSpace(p)) {
            return -1;
        }
        return -2;
    }

    CardTable.ReferenceToYoungObjectVisitor getReferenceToYoungObjectVisitor() {
        return this.referenceToYoungObjectVisitor;
    }

    SpaceVerifierImpl getSpaceVerifierImpl() {
        return this.spaceVerifier;
    }

    public static enum ChunkLimit {
        top,
        end;

    }

    private static class NoReferencesToForwardedObjectsVisitor
    implements ObjectReferenceVisitor {
        private NoReferencesToForwardedObjectsVisitor() {
        }

        @Override
        public boolean visitObjectReference(Pointer objRef, boolean compressed) {
            HeapImpl heap = HeapImpl.getHeapImpl();
            HeapVerifierImpl verifier = heap.getHeapVerifierImpl();
            Word objPointer = ReferenceAccess.singleton().readObjectAsUntrackedPointer(objRef, compressed);
            if (objPointer.isNull()) {
                return true;
            }
            ObjectHeaderImpl ohi = heap.getObjectHeaderImpl();
            if (ohi.isPointerToForwardedObjectCarefully((Pointer)objPointer)) {
                try (Log witness = verifier.getWitnessLog();){
                    witness.string("[HeapVerifierImpl.noReferencesToForwardedObjectsVerifier:").string("  cause: ").string(verifier.getCause());
                    witness.string("  contains fieldPointer: ").hex((WordBase)objPointer).string("  to forwarded object at: ").hex((WordBase)objRef).string("]").newline();
                }
                return false;
            }
            return true;
        }
    }

    private static class NoReferencesOutsideHeapVisitor
    implements ObjectReferenceVisitor {
        private NoReferencesOutsideHeapVisitor() {
        }

        @Override
        public boolean visitObjectReference(Pointer objRef, boolean compressed) {
            HeapVerifierImpl verifier = HeapImpl.getHeapImpl().getHeapVerifierImpl();
            Word objPointer = ReferenceAccess.singleton().readObjectAsUntrackedPointer(objRef, compressed);
            if (objPointer.isNull()) {
                return true;
            }
            if (!compressed && (objPointer.equal((UnsignedWord)HeapPolicy.getProducedHeapChunkZapWord()) || objPointer.equal((UnsignedWord)HeapPolicy.getConsumedHeapChunkZapWord()))) {
                try (Log witness = verifier.getWitnessLog();){
                    witness.string("[HeapVerifierImpl.noReferencesOutsideHeap:").string("  cause: ").string(verifier.getCause());
                    witness.string("  contains zapped field Pointer: ").hex((WordBase)objPointer).string("  at: ").hex((WordBase)objRef).string("]").newline();
                }
                return false;
            }
            if (!HeapVerifierImpl.slowlyFindPointer((Pointer)objPointer)) {
                try (Log witness = verifier.getWitnessLog();){
                    witness.string("[HeapVerifierImpl.noReferencesOutsideHeap:").string("  cause: ").string(verifier.getCause());
                    witness.string("  at: ").hex((WordBase)objRef).string("  contains fieldPointer: ").hex((WordBase)objPointer).string("  that is not a reference to the heap").newline();
                    witness.string("    Foolishly trying to look at the object pointed to by the fieldPointer:");
                    UnsignedWord fieldHeader = ObjectHeaderImpl.readHeaderFromPointerCarefully((Pointer)objPointer);
                    ObjectHeaderImpl ohi = ObjectHeaderImpl.getObjectHeaderImpl();
                    witness.string("  fieldHeader: ").string(ohi.toStringFromHeader(fieldHeader));
                    Object fieldObject = objPointer.toObject();
                    witness.string("  fieldObject: ").object(fieldObject).string("]").newline();
                }
                return false;
            }
            Word readWord = (Word)objPointer.readWord(0);
            if (readWord.equal(HeapPolicy.getProducedHeapChunkZapWord()) || readWord.equal(HeapPolicy.getConsumedHeapChunkZapWord())) {
                try (Log witness = verifier.getWitnessLog();){
                    witness.string("[HeapVerifierImpl.noReferencesOutsideHeap:").string("  cause: ").string(verifier.getCause());
                    witness.string("  contains fieldPointer: ").hex((WordBase)objPointer).string("  to zapped memory: ").hex((WordBase)readWord).string("  at: ").hex((WordBase)objRef).string("]").newline();
                }
                return false;
            }
            return true;
        }
    }

    protected static final class VerifyVMOperation
    extends JavaVMOperation {
        private final String message;
        private final HeapVerifierImpl verifier;
        private final HeapVerifier.Occasion occasion;
        private boolean result;

        VerifyVMOperation(String message, HeapVerifierImpl verifier, HeapVerifier.Occasion occasion) {
            super("HeapVerification", VMOperation.SystemEffect.SAFEPOINT);
            this.message = message;
            this.verifier = verifier;
            this.occasion = occasion;
            this.result = false;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while verifying the heap.")
        public void operate() {
            HeapVerifierImpl previousVerifier = HeapImpl.getHeapImpl().getHeapVerifierImpl();
            HeapImpl.getHeapImpl().setHeapVerifierImpl(this.verifier);
            this.result = this.verifier.verifyOperation(this.message, this.occasion);
            HeapImpl.getHeapImpl().setHeapVerifierImpl(previousVerifier);
        }

        public boolean getResult() {
            return this.result;
        }
    }
}

