/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.MemoryCheckpoint;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_8)
public final class CEntryPointEnterNode
extends FixedWithNextNode
implements Lowerable,
MemoryCheckpoint.Single {
    public static final NodeClass<CEntryPointEnterNode> TYPE = NodeClass.create(CEntryPointEnterNode.class);
    protected final EnterAction enterAction;
    @Node.OptionalInput
    protected ValueNode parameter;
    private final boolean ensureJavaThread;

    public static CEntryPointEnterNode createIsolate(ValueNode parameters) {
        return new CEntryPointEnterNode(EnterAction.CreateIsolate, parameters, false);
    }

    public static CEntryPointEnterNode attachThread(ValueNode isolate, boolean ensureJavaThread) {
        return new CEntryPointEnterNode(EnterAction.AttachThread, isolate, ensureJavaThread);
    }

    public static CEntryPointEnterNode enter(ValueNode isolateThread) {
        return new CEntryPointEnterNode(EnterAction.Enter, isolateThread, false);
    }

    public static CEntryPointEnterNode enterIsolate(ValueNode isolate) {
        return new CEntryPointEnterNode(EnterAction.EnterIsolate, isolate, false);
    }

    protected CEntryPointEnterNode(EnterAction enterAction, ValueNode parameter, boolean ensureJavaThread) {
        super(TYPE, StampFactory.forKind((JavaKind)JavaKind.Int));
        this.enterAction = enterAction;
        this.parameter = parameter;
        this.ensureJavaThread = ensureJavaThread;
    }

    public EnterAction getEnterAction() {
        return this.enterAction;
    }

    public ValueNode getParameter() {
        return this.parameter;
    }

    public boolean getEnsureJavaThread() {
        return this.ensureJavaThread;
    }

    public void lower(LoweringTool tool) {
        tool.getLowerer().lower((Node)this, tool);
    }

    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    public static enum EnterAction {
        CreateIsolate,
        AttachThread,
        Enter,
        EnterIsolate;

    }
}

