/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.nodes.VerificationMarkerNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import com.oracle.svm.core.nodes.CFunctionEpilogueNode;
import com.oracle.svm.core.nodes.CFunctionPrologueNode;
import com.oracle.svm.core.stack.JavaFrameAnchor;
import com.oracle.svm.core.stack.JavaFrameAnchors;
import com.oracle.svm.core.thread.Safepoint;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.Map;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.LocationIdentity;

public final class CFunctionSnippets
extends SubstrateTemplates
implements Snippets {
    private final SnippetTemplate.SnippetInfo prologue = this.snippet(CFunctionSnippets.class, "prologueSnippet", new LocationIdentity[0]);
    private final SnippetTemplate.SnippetInfo epilogue = this.snippet(CFunctionSnippets.class, "epilogueSnippet", new LocationIdentity[0]);
    private static final StackValueNode.StackSlotIdentity frameAnchorIdentity = new StackValueNode.StackSlotIdentity("CFunctionSnippets.frameAnchorIdentifier");

    @Snippet
    private static JavaFrameAnchor prologueSnippet() {
        JavaFrameAnchor anchor = (JavaFrameAnchor)StackValueNode.stackValue(1L, SizeOf.get(JavaFrameAnchor.class), frameAnchorIdentity);
        JavaFrameAnchors.pushFrameAnchor(anchor);
        return anchor;
    }

    @Snippet
    private static void epilogueSnippet() {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            Safepoint.transitionNativeToJava();
        }
        JavaFrameAnchors.popFrameAnchor();
    }

    private CFunctionSnippets(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, factories, providers, snippetReflection);
        lowerings.put(CFunctionPrologueNode.class, new CFunctionPrologueLowering());
        lowerings.put(CFunctionEpilogueNode.class, new CFunctionEpilogueLowering());
    }

    private static void matchCallStructure(CFunctionPrologueNode prologueNode) {
        CFunctionPrologueNode cur = prologueNode;
        CFunctionPrologueNode singleInvoke = null;
        ArrayList<CFunctionPrologueNode> seenNodes = new ArrayList<CFunctionPrologueNode>();
        while (true) {
            seenNodes.add(cur);
            if (cur instanceof Invoke) {
                if (singleInvoke != null) {
                    throw VMError.shouldNotReachHere("Found more than one invoke: " + seenNodes);
                }
                if (cur instanceof InvokeWithExceptionNode) {
                    throw VMError.shouldNotReachHere("Found InvokeWithExceptionNode: " + (Object)((Object)cur) + " in " + seenNodes);
                }
                InvokeNode invoke = (InvokeNode)cur;
                VMError.guarantee(invoke.classInit() == null, "Re-using the classInit field to store the JavaFrameAnchor");
                invoke.setClassInit((ValueNode)prologueNode);
                singleInvoke = cur;
            }
            if (cur instanceof CFunctionEpilogueNode) {
                prologueNode.getMarker().setEpilogueMarker(((CFunctionEpilogueNode)((Object)cur)).getMarker());
                return;
            }
            if (!(cur instanceof FixedWithNextNode)) {
                throw VMError.shouldNotReachHere("Did not find a matching CFunctionEpilogueNode in same block: " + seenNodes);
            }
            cur = ((FixedWithNextNode)cur).next();
        }
    }

    @AutomaticFeature
    static class CFunctionSnippetsFeature
    implements GraalFeature {
        CFunctionSnippetsFeature() {
        }

        @Override
        public void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
            new CFunctionSnippets(options, factories, providers, snippetReflection, lowerings);
        }
    }

    class CFunctionEpilogueLowering
    implements NodeLoweringProvider<CFunctionEpilogueNode> {
        CFunctionEpilogueLowering() {
        }

        @Override
        public void lower(CFunctionEpilogueNode node, LoweringTool tool) {
            node.graph().addAfterFixed((FixedWithNextNode)node, (FixedNode)node.graph().add((Node)new VerificationMarkerNode(node.getMarker())));
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(CFunctionSnippets.this.epilogue, node.graph().getGuardsStage(), tool.getLoweringStage());
            CFunctionSnippets.this.template((ValueNode)node, args).instantiate(CFunctionSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }

    class CFunctionPrologueLowering
    implements NodeLoweringProvider<CFunctionPrologueNode> {
        CFunctionPrologueLowering() {
        }

        @Override
        public void lower(CFunctionPrologueNode node, LoweringTool tool) {
            CFunctionSnippets.matchCallStructure(node);
            node.graph().addBeforeFixed((FixedNode)node, (FixedWithNextNode)node.graph().add((Node)new VerificationMarkerNode(node.getMarker())));
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(CFunctionSnippets.this.prologue, node.graph().getGuardsStage(), tool.getLoweringStage());
            CFunctionSnippets.this.template((ValueNode)node, args).instantiate(CFunctionSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

