/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.graal.snippets.StackOverflowCheckNode;
import com.oracle.svm.core.meta.SharedMethod;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.phases.Phase;
import org.graalvm.nativeimage.c.function.CFunction;

final class InsertStackOverflowCheckPhase
extends Phase {
    InsertStackOverflowCheckPhase() {
    }

    public boolean checkContract() {
        return false;
    }

    protected void run(StructuredGraph graph) {
        if (graph.method().getAnnotation(Uninterruptible.class) != null) {
            return;
        }
        if (((SharedMethod)graph.method()).isEntryPoint()) {
            return;
        }
        if (graph.method().getAnnotation(CFunction.class) != null) {
            return;
        }
        StackOverflowCheckNode stackOverflowCheckNode = (StackOverflowCheckNode)graph.add((Node)new StackOverflowCheckNode());
        graph.addAfterFixed((FixedWithNextNode)graph.start(), (FixedNode)stackOverflowCheckNode);
    }
}

