/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;

@TargetClass(className="java.util.concurrent.atomic.AtomicIntegerFieldUpdater$AtomicIntegerFieldUpdaterImpl")
final class Target_java_util_concurrent_atomic_AtomicIntegerFieldUpdater_AtomicIntegerFieldUpdaterImpl {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.AtomicFieldUpdaterOffset)
    private long offset;
    @Alias
    private Class<?> cclass;
    @Alias
    private Class<?> tclass;

    @Substitute
    Target_java_util_concurrent_atomic_AtomicIntegerFieldUpdater_AtomicIntegerFieldUpdaterImpl(Class<?> tclass, String fieldName, Class<?> caller) {
        int modifiers;
        Field field;
        try {
            field = tclass.getDeclaredField(fieldName);
            modifiers = field.getModifiers();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (field.getType() != Integer.TYPE) {
            throw new IllegalArgumentException("Must be integer type");
        }
        if (!Modifier.isVolatile(modifiers)) {
            throw new IllegalArgumentException("Must be volatile type");
        }
        this.cclass = tclass;
        this.tclass = tclass;
        this.offset = GraalUnsafeAccess.getUnsafe().objectFieldOffset(field);
    }
}

