/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.headers.Errno;
import com.oracle.svm.core.posix.JavaNetNetUtilMD;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.Target_jvm;
import com.oracle.svm.core.posix.VmPrimsJNI;
import com.oracle.svm.core.posix.headers.LibC;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.impl.DeprecatedPlatform;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;
import sun.net.ConnectionResetException;

@TargetClass(className="java.net.SocketOutputStream")
@Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
final class Target_java_net_SocketOutputStream {
    Target_java_net_SocketOutputStream() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    private void socketWrite0(FileDescriptor fdObj, byte[] data, int offArg, int lenArg) throws IOException {
        int buflen;
        int off = offArg;
        int len = lenArg;
        CCharPointer bufP = (CCharPointer)WordFactory.nullPointer();
        CCharPointer BUF = (CCharPointer)StackValue.get((int)JavaNetNetUtilMD.MAX_BUFFER_LEN(), CCharPointer.class);
        if (fdObj == null) {
            throw new SocketException("socket closed");
        }
        int fd = PosixUtils.getFD(fdObj);
        if (fd == -1) {
            throw new SocketException("Socket closed");
        }
        if (len <= JavaNetNetUtilMD.MAX_BUFFER_LEN()) {
            bufP = BUF;
            buflen = JavaNetNetUtilMD.MAX_BUFFER_LEN();
        } else {
            buflen = Integer.min(JavaNetNetUtilMD.MAX_HEAP_BUFFER_LEN(), len);
            bufP = (CCharPointer)LibC.malloc(WordFactory.unsigned((int)buflen));
            if (bufP.isNull()) {
                bufP = BUF;
                buflen = JavaNetNetUtilMD.MAX_HEAP_BUFFER_LEN();
            }
        }
        try {
            while (len > 0) {
                int chunkLen;
                int loff = 0;
                int llen = chunkLen = Integer.min(buflen, len);
                VmPrimsJNI.GetByteArrayRegion(data, off, chunkLen, bufP);
                while (llen > 0) {
                    int n = JavaNetNetUtilMD.NET_Send(fd, bufP.addressOf(loff), llen, 0);
                    if (n > 0) {
                        llen -= n;
                        loff += n;
                        continue;
                    }
                    if (n == Target_jvm.JVM_IO_INTR()) {
                        throw new InterruptedIOException();
                    }
                    if (Errno.errno() == Errno.ECONNRESET()) {
                        throw new ConnectionResetException("Connection reset");
                    }
                    throw new SocketException(PosixUtils.lastErrorString("Write failed"));
                }
                len -= chunkLen;
                off += chunkLen;
            }
        }
        finally {
            if (bufP.notEqual((ComparableWord)BUF) && bufP.isNonNull()) {
                LibC.free((PointerBase)bufP);
                bufP = (CCharPointer)WordFactory.nullPointer();
            }
        }
    }
}

