/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.posix.JavaUtilZipSubstitutions;
import com.oracle.svm.core.posix.Util_java_util_zip_Inflater;
import com.oracle.svm.core.posix.headers.LibC;
import com.oracle.svm.core.posix.headers.ZLib;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.impl.DeprecatedPlatform;
import org.graalvm.word.WordFactory;

@Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
@TargetClass(value=Inflater.class)
final class Target_java_util_zip_Inflater {
    @Alias
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private byte[] buf;
    @Alias
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    int off;
    @Alias
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    int len;
    @Alias
    private boolean finished;
    @Alias
    private boolean needDict;

    Target_java_util_zip_Inflater() {
    }

    @Substitute
    private static long init(boolean nowrap) {
        ZLib.z_stream strm = (ZLib.z_stream)LibC.calloc(WordFactory.unsigned((int)1), SizeOf.unsigned(ZLib.z_stream.class));
        if (strm.isNull()) {
            throw new OutOfMemoryError();
        }
        int ret = ZLib.inflateInit2(strm, nowrap ? -ZLib.MAX_WBITS() : ZLib.MAX_WBITS());
        if (ret == ZLib.Z_OK()) {
            return strm.rawValue();
        }
        LibC.free(strm);
        if (ret == ZLib.Z_MEM_ERROR()) {
            throw new OutOfMemoryError();
        }
        throw new InternalError(CTypeConversion.toJavaString((CCharPointer)strm.msg()));
    }

    @Substitute
    private static void setDictionary(long addr, byte[] b, int off, int len) {
        try (PinnedObject pinned = PinnedObject.create((Object)b);){
            CCharPointer bytes = (CCharPointer)pinned.addressOfArrayElement(off);
            JavaUtilZipSubstitutions.Util_java_util_zip_Inflater.doSetDictionary(addr, bytes, len);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private int inflateBytes(long addr, byte[] b, int off, int len) throws DataFormatException {
        ZLib.z_stream strm = (ZLib.z_stream)WordFactory.pointer((long)addr);
        try (PinnedObject pinnedInBuf = PinnedObject.create((Object)this.buf);
             PinnedObject pinnedOutBuf = PinnedObject.create((Object)b);){
            strm.set_next_in((CCharPointer)pinnedInBuf.addressOfArrayElement(this.off));
            strm.set_next_out((CCharPointer)pinnedOutBuf.addressOfArrayElement(off));
            strm.set_avail_in(this.len);
            strm.set_avail_out(len);
            int ret = ZLib.inflate(strm, ZLib.Z_PARTIAL_FLUSH());
            if (ret == ZLib.Z_STREAM_END()) {
                this.finished = true;
                int n = Util_java_util_zip_Inflater.update(this, len, strm);
                return n;
            }
            if (ret == ZLib.Z_OK()) {
                int n = Util_java_util_zip_Inflater.update(this, len, strm);
                return n;
            }
            if (ret == ZLib.Z_NEED_DICT()) {
                this.needDict = true;
                Util_java_util_zip_Inflater.update(this, len, strm);
                int n = 0;
                return n;
            }
            if (ret == ZLib.Z_BUF_ERROR()) {
                int n = 0;
                return n;
            }
            if (ret == ZLib.Z_DATA_ERROR()) {
                throw new DataFormatException(CTypeConversion.toJavaString((CCharPointer)strm.msg()));
            }
            if (ret != ZLib.Z_MEM_ERROR()) throw new InternalError(CTypeConversion.toJavaString((CCharPointer)strm.msg()));
            throw new OutOfMemoryError();
        }
    }

    @Substitute
    private static int getAdler(long addr) {
        ZLib.z_stream strm = (ZLib.z_stream)WordFactory.pointer((long)addr);
        return (int)strm.adler().rawValue();
    }

    @Substitute
    private static void reset(long addr) {
        if (ZLib.inflateReset((ZLib.z_stream)WordFactory.pointer((long)addr)) != ZLib.Z_OK()) {
            throw new InternalError();
        }
    }

    @Substitute
    private static void end(long addr) {
        ZLib.z_stream strm = (ZLib.z_stream)WordFactory.pointer((long)addr);
        if (ZLib.inflateEnd(strm) == ZLib.Z_STREAM_ERROR()) {
            throw new InternalError();
        }
        LibC.free(strm);
    }
}

