/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.posix.Java_lang_Process_Supplement;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.Target_java_lang_ProcessBuilder_NullInputStream;
import com.oracle.svm.core.posix.Target_java_lang_ProcessBuilder_NullOutputStream;
import com.oracle.svm.core.posix.Target_java_lang_UNIXProcess;
import com.oracle.svm.core.posix.Target_java_lang_UNIXProcess_ProcessPipeInputStream;
import com.oracle.svm.core.posix.Target_java_lang_UNIXProcess_ProcessPipeOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

final class UNIXProcess_Support {
    UNIXProcess_Support() {
    }

    static void doInitStreams(final Target_java_lang_UNIXProcess proc, int[] fds, boolean forceNullOutputStream) {
        Object in = Target_java_lang_ProcessBuilder_NullOutputStream.INSTANCE;
        if (fds[0] != -1 && !forceNullOutputStream) {
            in = new Target_java_lang_UNIXProcess_ProcessPipeOutputStream(fds[0]);
        }
        proc.stdin = SubstrateUtil.cast(in, OutputStream.class);
        Object out = Target_java_lang_ProcessBuilder_NullInputStream.INSTANCE;
        if (fds[1] != -1 && !forceNullOutputStream) {
            out = new Target_java_lang_UNIXProcess_ProcessPipeInputStream(fds[1]);
        }
        proc.stdout = SubstrateUtil.cast(out, InputStream.class);
        Object err = Target_java_lang_ProcessBuilder_NullInputStream.INSTANCE;
        if (fds[2] != -1 && !forceNullOutputStream) {
            err = new Target_java_lang_UNIXProcess_ProcessPipeInputStream(fds[2]);
        }
        proc.stderr = SubstrateUtil.cast(err, InputStream.class);
        Thread reaperThread = Java_lang_Process_Supplement.reaperFactory.newThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int status = PosixUtils.waitForProcessExit(proc.pid);
                Target_java_lang_UNIXProcess target_java_lang_UNIXProcess = proc;
                synchronized (target_java_lang_UNIXProcess) {
                    proc.exitcode = status;
                    proc.hasExited = true;
                    proc.notifyAll();
                }
                if (proc.stdout != Target_java_lang_ProcessBuilder_NullInputStream.INSTANCE) {
                    SubstrateUtil.cast(proc.stdout, Target_java_lang_UNIXProcess_ProcessPipeInputStream.class).processExited();
                }
                if (proc.stderr != Target_java_lang_ProcessBuilder_NullInputStream.INSTANCE) {
                    SubstrateUtil.cast(proc.stderr, Target_java_lang_UNIXProcess_ProcessPipeInputStream.class).processExited();
                }
                if (proc.stdin != Target_java_lang_ProcessBuilder_NullOutputStream.INSTANCE) {
                    SubstrateUtil.cast(proc.stdin, Target_java_lang_UNIXProcess_ProcessPipeOutputStream.class).processExited();
                }
            }
        });
        reaperThread.start();
    }
}

