/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.headers.Errno;
import com.oracle.svm.core.os.IsDefined;
import com.oracle.svm.core.posix.JavaNetNetUtil;
import com.oracle.svm.core.posix.JavaNetNetUtilMD;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.Target_java_net_DatagramSocketImpl;
import com.oracle.svm.core.posix.Target_java_net_InetAddress;
import com.oracle.svm.core.posix.Target_java_net_NetworkInterface;
import com.oracle.svm.core.posix.Target_java_net_PlainDatagramSocketImpl;
import com.oracle.svm.core.posix.Util_java_net_Inet4Address;
import com.oracle.svm.core.posix.Util_java_net_NetworkInterface;
import com.oracle.svm.core.posix.VmPrimsJVM;
import com.oracle.svm.core.posix.headers.LibC;
import com.oracle.svm.core.posix.headers.NetinetIn;
import com.oracle.svm.core.posix.headers.Socket;
import com.oracle.svm.core.posix.headers.linux.LinuxIn;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Objects;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

class Util_java_net_PlainDatagramSocketImpl {
    Util_java_net_PlainDatagramSocketImpl() {
    }

    static int getFD(Target_java_net_PlainDatagramSocketImpl self) {
        FileDescriptor fdObj = SubstrateUtil.cast((Object)self, Target_java_net_DatagramSocketImpl.class).fd;
        if (fdObj == null) {
            return -1;
        }
        return PosixUtils.getFD(fdObj);
    }

    static Object getMulticastInterface(int fd, int opt) throws SocketException {
        boolean isIPV4 = true;
        if (IsDefined.socket_AF_INET6() && JavaNetNetUtil.ipv6_available()) {
            isIPV4 = false;
        }
        if (isIPV4) {
            NetinetIn.in_addr inP = (NetinetIn.in_addr)StackValue.get(NetinetIn.in_addr.class);
            CIntPointer len_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
            if (VmPrimsJVM.JVM_GetSockOpt(fd, NetinetIn.IPPROTO_IP(), NetinetIn.IP_MULTICAST_IF(), (CCharPointer)inP, len_Pointer) < 0) {
                throw new SocketException(PosixUtils.lastErrorString("Error getting socket option"));
            }
            Inet4Address addr = Util_java_net_Inet4Address.new_Inet4Address();
            JavaNetNetUtil.setInetAddress_addr(addr, NetinetIn.ntohl(inP.s_addr()));
            if (opt == 16) {
                return addr;
            }
            NetworkInterface ni = Target_java_net_NetworkInterface.getByInetAddress0(addr);
            if (ni != null) {
                return ni;
            }
            ni = Util_java_net_NetworkInterface.newNetworkInterface();
            Util_java_net_NetworkInterface.fromNetworkInterface((NetworkInterface)ni).index = -1;
            InetAddress[] addrArray = new InetAddress[]{addr};
            Util_java_net_NetworkInterface.fromNetworkInterface((NetworkInterface)ni).addrs = addrArray;
            Util_java_net_NetworkInterface.fromNetworkInterface((NetworkInterface)ni).name = "";
            return ni;
        }
        if (IsDefined.socket_AF_INET6() && (opt == 16 || opt == 31)) {
            CCharPointer index_Pointer = (CCharPointer)StackValue.get(CCharPointer.class);
            index_Pointer.write((byte)0);
            CIntPointer len_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
            len_Pointer.write(SizeOf.get(CCharPointer.class));
            if (VmPrimsJVM.JVM_GetSockOpt(fd, NetinetIn.IPPROTO_IPV6(), NetinetIn.IPV6_MULTICAST_IF(), index_Pointer, len_Pointer) < 0) {
                throw new SocketException(PosixUtils.lastErrorString("Error getting socket option"));
            }
            if (index_Pointer.read() > 0) {
                NetworkInterface ni = Target_java_net_NetworkInterface.getByIndex0(index_Pointer.read());
                if (ni == null) {
                    throw new SocketException("IPV6_MULTICAST_IF returned index to unrecognized interface: " + index_Pointer.read());
                }
                if (opt == 31) {
                    return ni;
                }
                InetAddress[] addrArray = Util_java_net_NetworkInterface.fromNetworkInterface((NetworkInterface)ni).addrs;
                if (addrArray.length < 1) {
                    throw new SocketException("IPV6_MULTICAST_IF returned interface without IP bindings");
                }
                InetAddress addr = addrArray[0];
                return addr;
            }
            InetAddress addr = Target_java_net_InetAddress.anyLocalAddress();
            if (opt == 16) {
                return addr;
            }
            NetworkInterface ni = Util_java_net_NetworkInterface.newNetworkInterface();
            Util_java_net_NetworkInterface.fromNetworkInterface((NetworkInterface)ni).index = -1;
            InetAddress[] addrArray = new InetAddress[]{addr};
            Util_java_net_NetworkInterface.fromNetworkInterface((NetworkInterface)ni).addrs = addrArray;
            Util_java_net_NetworkInterface.fromNetworkInterface((NetworkInterface)ni).name = "";
            return ni;
        }
        return null;
    }

    static void setMulticastInterface(int fd, int opt, Object value) throws SocketException {
        if (opt == 16) {
            if (IsDefined.socket_AF_INET6()) {
                if (IsDefined.__linux__()) {
                    Util_java_net_PlainDatagramSocketImpl.mcast_set_if_by_addr_v4(fd, (InetAddress)value);
                    if (JavaNetNetUtil.ipv6_available()) {
                        Util_java_net_PlainDatagramSocketImpl.mcast_set_if_by_addr_v6(fd, (InetAddress)value);
                    }
                } else if (JavaNetNetUtil.ipv6_available()) {
                    Util_java_net_PlainDatagramSocketImpl.mcast_set_if_by_addr_v6(fd, (InetAddress)value);
                } else {
                    Util_java_net_PlainDatagramSocketImpl.mcast_set_if_by_addr_v4(fd, (InetAddress)value);
                }
            } else {
                Util_java_net_PlainDatagramSocketImpl.mcast_set_if_by_addr_v4(fd, (InetAddress)value);
            }
        }
        if (opt == 31) {
            if (IsDefined.socket_AF_INET6()) {
                if (IsDefined.__linux__()) {
                    Util_java_net_PlainDatagramSocketImpl.mcast_set_if_by_if_v4(fd, (NetworkInterface)value);
                    if (JavaNetNetUtil.ipv6_available()) {
                        Util_java_net_PlainDatagramSocketImpl.mcast_set_if_by_if_v6(fd, (NetworkInterface)value);
                    }
                } else if (JavaNetNetUtil.ipv6_available()) {
                    Util_java_net_PlainDatagramSocketImpl.mcast_set_if_by_if_v6(fd, (NetworkInterface)value);
                } else {
                    Util_java_net_PlainDatagramSocketImpl.mcast_set_if_by_if_v4(fd, (NetworkInterface)value);
                }
            } else {
                Util_java_net_PlainDatagramSocketImpl.mcast_set_if_by_if_v4(fd, (NetworkInterface)value);
            }
        }
    }

    static void mcast_set_if_by_addr_v4(int fd, InetAddress value) throws SocketException {
        NetinetIn.in_addr in = (NetinetIn.in_addr)StackValue.get(NetinetIn.in_addr.class);
        in.set_s_addr(NetinetIn.htonl(JavaNetNetUtilMD.getInetAddress_addr(value)));
        if (VmPrimsJVM.JVM_SetSockOpt(fd, NetinetIn.IPPROTO_IP(), NetinetIn.IP_MULTICAST_IF(), (CCharPointer)in, SizeOf.get(NetinetIn.in_addr.class)) < 0) {
            throw new SocketException(PosixUtils.lastErrorString("Error setting socket option"));
        }
    }

    static void mcast_set_if_by_if_v4(int fd, NetworkInterface value) throws SocketException {
        NetinetIn.in_addr in = (NetinetIn.in_addr)StackValue.get(NetinetIn.in_addr.class);
        InetAddress[] addrArray = Util_java_net_NetworkInterface.fromNetworkInterface((NetworkInterface)value).addrs;
        int len = addrArray.length;
        if (len < 1) {
            throw new SocketException("bad argument for IP_MULTICAST_IF2: No IP addresses bound to interface");
        }
        for (int i = 0; i < len; ++i) {
            InetAddress addr = addrArray[i];
            int family = JavaNetNetUtil.getInetAddress_family(addr);
            if (family != Target_java_net_InetAddress.IPv4) continue;
            in.set_s_addr(NetinetIn.htonl(JavaNetNetUtilMD.getInetAddress_addr(addr)));
            break;
        }
        if (VmPrimsJVM.JVM_SetSockOpt(fd, NetinetIn.IPPROTO_IP(), NetinetIn.IP_MULTICAST_IF(), (CCharPointer)in, SizeOf.get(NetinetIn.in_addr.class)) < 0) {
            throw new SocketException("Error setting socket option");
        }
    }

    static void mcast_set_if_by_if_v6(int fd, NetworkInterface value) throws SocketException {
        CIntPointer index_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        index_Pointer.write(Util_java_net_NetworkInterface.fromNetworkInterface((NetworkInterface)value).index);
        if (VmPrimsJVM.JVM_SetSockOpt(fd, NetinetIn.IPPROTO_IP(), NetinetIn.IPV6_MULTICAST_IF(), (CCharPointer)index_Pointer, SizeOf.get(CIntPointer.class)) < 0) {
            if (Errno.errno() == Errno.EINVAL() && index_Pointer.read() > 0) {
                throw new SocketException("IPV6_MULTICAST_IF failed (interface has IPv4 address only?");
            }
            throw new SocketException(PosixUtils.lastErrorString("Error setting socket option"));
        }
    }

    static void mcast_set_if_by_addr_v6(int fd, InetAddress valueArg) throws SocketException {
        NetworkInterface value = Target_java_net_NetworkInterface.getByInetAddress0(valueArg);
        if (value == null) {
            throw new SocketException("bad argument for IP_MULTICAST_IF: address not bound to any interface");
        }
        Util_java_net_PlainDatagramSocketImpl.mcast_set_if_by_if_v6(fd, value);
    }

    static void setMulticastLoopbackMode(int fd, int opt, Object value) throws SocketException {
        if (IsDefined.socket_AF_INET6()) {
            if (IsDefined.__linux__()) {
                Util_java_net_PlainDatagramSocketImpl.mcast_set_loop_v4(fd, (Boolean)value);
                if (JavaNetNetUtil.ipv6_available()) {
                    Util_java_net_PlainDatagramSocketImpl.mcast_set_loop_v6(fd, (Boolean)value);
                }
            } else if (JavaNetNetUtil.ipv6_available()) {
                Util_java_net_PlainDatagramSocketImpl.mcast_set_loop_v6(fd, (Boolean)value);
            } else {
                Util_java_net_PlainDatagramSocketImpl.mcast_set_loop_v4(fd, (Boolean)value);
            }
        } else {
            Util_java_net_PlainDatagramSocketImpl.mcast_set_loop_v4(fd, (Boolean)value);
        }
    }

    static void mcast_set_loop_v4(int fd, boolean value) throws SocketException {
        CCharPointer loopback_Pointer = (CCharPointer)StackValue.get(CCharPointer.class);
        boolean on = value;
        loopback_Pointer.write((byte)(!on ? 1 : 0));
        if (JavaNetNetUtilMD.NET_SetSockOpt(fd, NetinetIn.IPPROTO_IP(), NetinetIn.IP_MULTICAST_LOOP(), (WordPointer)loopback_Pointer, SizeOf.get(CCharPointer.class)) < 0) {
            throw new SocketException(PosixUtils.lastErrorString("Error setting socket option"));
        }
    }

    static void mcast_set_loop_v6(int fd, boolean value) throws SocketException {
        CIntPointer loopback_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        boolean on = value;
        loopback_Pointer.write(!on ? 1 : 0);
        if (JavaNetNetUtilMD.NET_SetSockOpt(fd, NetinetIn.IPPROTO_IPV6(), NetinetIn.IPV6_MULTICAST_LOOP(), (WordPointer)loopback_Pointer, SizeOf.get(CIntPointer.class)) < 0) {
            throw new SocketException(PosixUtils.lastErrorString("Error setting socket option"));
        }
    }

    static void setTTL(int fd, int ttl) throws SocketException {
        CCharPointer ittl_Pointer = (CCharPointer)StackValue.get(CCharPointer.class);
        ittl_Pointer.write((byte)ttl);
        if (Socket.setsockopt(fd, NetinetIn.IPPROTO_IP(), NetinetIn.IP_MULTICAST_TTL(), (PointerBase)ittl_Pointer, SizeOf.get(CCharPointer.class)) < 0) {
            throw new SocketException(PosixUtils.lastErrorString("Error setting socket option"));
        }
    }

    static void setHopLimit(int fd, int ttl) throws SocketException {
        CCharPointer ittl_Pointer = (CCharPointer)StackValue.get(CCharPointer.class);
        ittl_Pointer.write((byte)ttl);
        if (Socket.setsockopt(fd, NetinetIn.IPPROTO_IPV6(), NetinetIn.IPV6_MULTICAST_HOPS(), (PointerBase)ittl_Pointer, SizeOf.get(CCharPointer.class)) < 0) {
            throw new SocketException(PosixUtils.lastErrorString("Error setting socket option"));
        }
    }

    static Boolean createBoolean(boolean b) {
        return b;
    }

    static Boolean createBoolean(int i) {
        return CTypeConversion.toBoolean((int)i);
    }

    static Integer createInteger(int i) {
        return i;
    }

    static boolean not(byte b) {
        return !CTypeConversion.toBoolean((int)b);
    }

    static boolean not(int i) {
        return !CTypeConversion.toBoolean((int)i);
    }

    static void mcast_join_leave_linux(Target_java_net_PlainDatagramSocketImpl self, InetAddress iaObj, NetworkInterface niObj, boolean join) throws IOException {
        FileDescriptor fdObj = self.fdAlias;
        if (fdObj == null) {
            throw new SocketException("Socket closed");
        }
        int fd = PosixUtils.getFD(fdObj);
        Objects.requireNonNull(iaObj, "iaObj");
        boolean ipv6_join_leave = JavaNetNetUtil.ipv6_available();
        int family = JavaNetNetUtil.getInetAddress_family(iaObj);
        if (family == Target_java_net_InetAddress.IPv4) {
            ipv6_join_leave = false;
        }
        if (!ipv6_join_leave) {
            LinuxIn.ip_mreqn mname = (LinuxIn.ip_mreqn)StackValue.get(LinuxIn.ip_mreqn.class);
            int mname_len = 0;
            if (niObj != null) {
                if (JavaNetNetUtil.ipv6_available()) {
                    mname.imr_multiaddr().set_s_addr(NetinetIn.htonl(JavaNetNetUtilMD.getInetAddress_addr(iaObj)));
                    mname.imr_address().set_s_addr(0);
                    mname.set_imr_ifindex(niObj.getIndex());
                    mname_len = SizeOf.get(LinuxIn.ip_mreqn.class);
                } else {
                    Enumeration<InetAddress> addresses = niObj.getInetAddresses();
                    if (!addresses.hasMoreElements()) {
                        throw new SocketException("bad argument for IP_ADD_MEMBERSHIP: No IP address bound to interface");
                    }
                    InetAddress addr = addresses.nextElement();
                    mname.imr_multiaddr().set_s_addr(NetinetIn.htonl(JavaNetNetUtilMD.getInetAddress_addr(iaObj)));
                    mname.imr_address().set_s_addr(NetinetIn.htonl(JavaNetNetUtilMD.getInetAddress_addr(addr)));
                    mname.set_imr_ifindex(0);
                    mname_len = SizeOf.get(NetinetIn.ip_mreq.class);
                }
            }
            if (niObj == null) {
                CIntPointer lenPtr;
                if (JavaNetNetUtil.ipv6_available()) {
                    CIntPointer indexPtr = (CIntPointer)StackValue.get(CIntPointer.class);
                    lenPtr = (CIntPointer)StackValue.get(CIntPointer.class);
                    lenPtr.write(SizeOf.get(CIntPointer.class));
                    if (Socket.getsockopt(fd, NetinetIn.IPPROTO_IPV6(), NetinetIn.IPV6_MULTICAST_IF(), (PointerBase)indexPtr, lenPtr) < 0) {
                        throw new SocketException(PosixUtils.lastErrorString("getsockopt IPV6_MULTICAST_IF failed"));
                    }
                    mname.imr_multiaddr().set_s_addr(NetinetIn.htonl(JavaNetNetUtilMD.getInetAddress_addr(iaObj)));
                    mname.imr_address().set_s_addr(0);
                    mname.set_imr_ifindex(indexPtr.read());
                    mname_len = SizeOf.get(LinuxIn.ip_mreqn.class);
                } else {
                    NetinetIn.in_addr inP = (NetinetIn.in_addr)StackValue.get(NetinetIn.in_addr.class);
                    lenPtr = (CIntPointer)StackValue.get(CIntPointer.class);
                    lenPtr.write(SizeOf.get(NetinetIn.in_addr.class));
                    if (Socket.getsockopt(fd, NetinetIn.IPPROTO_IP(), NetinetIn.IP_MULTICAST_IF(), inP, lenPtr) < 0) {
                        throw new SocketException(PosixUtils.lastErrorString("getsockopt IP_MULTICAST_IF failed"));
                    }
                    mname.imr_address().set_s_addr(inP.s_addr());
                    mname.set_imr_ifindex(0);
                    mname.imr_multiaddr().set_s_addr(NetinetIn.htonl(JavaNetNetUtilMD.getInetAddress_addr(iaObj)));
                    mname_len = SizeOf.get(NetinetIn.ip_mreq.class);
                }
            }
            if (Socket.setsockopt(fd, NetinetIn.IPPROTO_IP(), join ? NetinetIn.IP_ADD_MEMBERSHIP() : NetinetIn.IP_DROP_MEMBERSHIP(), mname, mname_len) < 0) {
                if (Errno.errno() == Errno.ENOPROTOOPT()) {
                    if (JavaNetNetUtil.ipv6_available()) {
                        ipv6_join_leave = true;
                        Errno.set_errno(0);
                    } else {
                        Errno.set_errno(Errno.ENOPROTOOPT());
                    }
                }
                if (Errno.errno() > 0) {
                    if (join) {
                        throw new SocketException(PosixUtils.lastErrorString("setsockopt IP_ADD_MEMBERSHIP failed"));
                    }
                    if (Errno.errno() == Errno.ENOENT()) {
                        throw new SocketException("Not a member of the multicast group");
                    }
                    throw new SocketException(PosixUtils.lastErrorString("setsockopt IP_DROP_MEMBERSHIP failed"));
                }
            }
            if (!ipv6_join_leave) {
                return;
            }
        }
        NetinetIn.ipv6_mreq mname6 = (NetinetIn.ipv6_mreq)StackValue.get(NetinetIn.ipv6_mreq.class);
        CCharPointer caddr = (CCharPointer)StackValue.get((int)16, CCharPointer.class);
        int n = family = JavaNetNetUtil.getInetAddress_family(iaObj) == Target_java_net_InetAddress.IPv4 ? Socket.AF_INET() : Socket.AF_INET6();
        if (family == Socket.AF_INET()) {
            LibC.memset(caddr, WordFactory.signed((int)0), WordFactory.unsigned((int)16));
            int address = JavaNetNetUtilMD.getInetAddress_addr(iaObj);
            caddr.write(10, (byte)-1);
            caddr.write(11, (byte)-1);
            caddr.write(12, (byte)(address >> 24 & 0xFF));
            caddr.write(13, (byte)(address >> 16 & 0xFF));
            caddr.write(14, (byte)(address >> 8 & 0xFF));
            caddr.write(15, (byte)(address & 0xFF));
        } else {
            JavaNetNetUtil.getInet6Address_ipAddress((Inet6Address)iaObj, caddr);
        }
        LibC.memcpy(mname6.ipv6mr_multiaddr(), (PointerBase)caddr, SizeOf.unsigned(NetinetIn.in6_addr.class));
        if (niObj == null) {
            int rt_index;
            CIntPointer indexPtr = (CIntPointer)StackValue.get(CIntPointer.class);
            CIntPointer lenPtr = (CIntPointer)StackValue.get(CIntPointer.class);
            lenPtr.write(SizeOf.get(CIntPointer.class));
            if (Socket.getsockopt(fd, NetinetIn.IPPROTO_IPV6(), NetinetIn.IPV6_MULTICAST_IF(), (PointerBase)indexPtr, lenPtr) < 0) {
                throw new SocketException(PosixUtils.lastErrorString("setsockopt IPV6_MULTICAST_IF failed"));
            }
            if (indexPtr.read() == 0 && (rt_index = JavaNetNetUtilMD.getDefaultIPv6Interface(mname6.ipv6mr_multiaddr())) > 0) {
                indexPtr.write(rt_index);
            }
            mname6.set_ipv6mr_interface(indexPtr.read());
        } else {
            int idx = niObj.getIndex();
            mname6.set_ipv6mr_interface(idx);
        }
        if (Socket.setsockopt(fd, NetinetIn.IPPROTO_IPV6(), join ? NetinetIn.IPV6_ADD_MEMBERSHIP() : NetinetIn.IPV6_DROP_MEMBERSHIP(), mname6, SizeOf.get(NetinetIn.ipv6_mreq.class)) < 0) {
            if (join) {
                throw new SocketException(PosixUtils.lastErrorString("setsockopt IPV6_ADD_MEMBERSHIP failed"));
            }
            if (Errno.errno() == Errno.ENOENT()) {
                throw new SocketException("Not a member of the multicast group");
            }
            throw new SocketException(PosixUtils.lastErrorString("setsockopt IPV6_DROP_MEMBERSHIP failed"));
        }
    }

    static void mcast_join_leave_non_linux(Target_java_net_PlainDatagramSocketImpl self, InetAddress iaObj, NetworkInterface niObj, boolean join) throws IOException {
        int family;
        FileDescriptor fdObj = self.fdAlias;
        if (fdObj == null) {
            throw new SocketException("Socket closed");
        }
        int fd = PosixUtils.getFD(fdObj);
        Objects.requireNonNull(iaObj, "iaObj");
        boolean ipv6_join_leave = JavaNetNetUtil.ipv6_available();
        if (!ipv6_join_leave) {
            NetinetIn.ip_mreq mname = (NetinetIn.ip_mreq)StackValue.get(NetinetIn.ip_mreq.class);
            int mname_len = 0;
            if (niObj != null) {
                Enumeration<InetAddress> addresses = niObj.getInetAddresses();
                if (!addresses.hasMoreElements()) {
                    throw new SocketException("bad argument for IP_ADD_MEMBERSHIP: No IP address bound to interface");
                }
                InetAddress addr = addresses.nextElement();
                mname.imr_multiaddr().set_s_addr(NetinetIn.htonl(JavaNetNetUtilMD.getInetAddress_addr(iaObj)));
                mname.imr_interface().set_s_addr(NetinetIn.htonl(JavaNetNetUtilMD.getInetAddress_addr(addr)));
                mname_len = SizeOf.get(NetinetIn.ip_mreq.class);
            }
            if (niObj == null) {
                NetinetIn.in_addr inP = (NetinetIn.in_addr)StackValue.get(NetinetIn.in_addr.class);
                CIntPointer lenPtr = (CIntPointer)StackValue.get(CIntPointer.class);
                if (Socket.getsockopt(fd, NetinetIn.IPPROTO_IP(), NetinetIn.IP_MULTICAST_IF(), inP, lenPtr) < 0) {
                    throw new SocketException(PosixUtils.lastErrorString("getsockopt IP_MULTICAST_IF failed"));
                }
                mname.imr_interface().set_s_addr(inP.s_addr());
                mname.imr_multiaddr().set_s_addr(NetinetIn.htonl(JavaNetNetUtilMD.getInetAddress_addr(iaObj)));
                mname_len = SizeOf.get(NetinetIn.ip_mreq.class);
            }
            if (Socket.setsockopt(fd, NetinetIn.IPPROTO_IP(), join ? NetinetIn.IP_ADD_MEMBERSHIP() : NetinetIn.IP_DROP_MEMBERSHIP(), mname, mname_len) < 0 && Errno.errno() > 0) {
                if (join) {
                    throw new SocketException(PosixUtils.lastErrorString("setsockopt IP_ADD_MEMBERSHIP failed"));
                }
                if (Errno.errno() == Errno.ENOENT()) {
                    throw new SocketException("Not a member of the multicast group");
                }
                throw new SocketException(PosixUtils.lastErrorString("setsockopt IP_DROP_MEMBERSHIP failed"));
            }
            if (!ipv6_join_leave) {
                return;
            }
        }
        NetinetIn.ipv6_mreq mname6 = (NetinetIn.ipv6_mreq)StackValue.get(NetinetIn.ipv6_mreq.class);
        CCharPointer caddr = (CCharPointer)StackValue.get((int)16, CCharPointer.class);
        int n = family = JavaNetNetUtil.getInetAddress_family(iaObj) == Target_java_net_InetAddress.IPv4 ? Socket.AF_INET() : Socket.AF_INET6();
        if (family == Socket.AF_INET()) {
            LibC.memset(caddr, WordFactory.signed((int)0), WordFactory.unsigned((int)16));
            int address = JavaNetNetUtilMD.getInetAddress_addr(iaObj);
            caddr.write(10, (byte)-1);
            caddr.write(11, (byte)-1);
            caddr.write(12, (byte)(address >> 24 & 0xFF));
            caddr.write(13, (byte)(address >> 16 & 0xFF));
            caddr.write(14, (byte)(address >> 8 & 0xFF));
            caddr.write(15, (byte)(address & 0xFF));
        } else {
            JavaNetNetUtil.getInet6Address_ipAddress((Inet6Address)iaObj, caddr);
        }
        LibC.memcpy(mname6.ipv6mr_multiaddr(), (PointerBase)caddr, SizeOf.unsigned(NetinetIn.in6_addr.class));
        if (niObj == null) {
            CIntPointer indexPtr = (CIntPointer)StackValue.get(CIntPointer.class);
            CIntPointer lenPtr = (CIntPointer)StackValue.get(CIntPointer.class);
            lenPtr.write(SizeOf.get(CIntPointer.class));
            if (Socket.getsockopt(fd, NetinetIn.IPPROTO_IPV6(), NetinetIn.IPV6_MULTICAST_IF(), (PointerBase)indexPtr, lenPtr) < 0) {
                throw new SocketException(PosixUtils.lastErrorString("setsockopt IPV6_MULTICAST_IF failed"));
            }
            if (IsDefined.MACOSX() && family == Socket.AF_INET6() && indexPtr.read() == 0) {
                indexPtr.write(Target_java_net_NetworkInterface.defaultIndex);
            }
            mname6.set_ipv6mr_interface(indexPtr.read());
        } else {
            int idx = niObj.getIndex();
            mname6.set_ipv6mr_interface(idx);
        }
        if (Socket.setsockopt(fd, NetinetIn.IPPROTO_IPV6(), join ? NetinetIn.IPV6_JOIN_GROUP() : NetinetIn.IPV6_LEAVE_GROUP(), mname6, SizeOf.get(NetinetIn.ipv6_mreq.class)) < 0) {
            if (join) {
                throw new SocketException(PosixUtils.lastErrorString("setsockopt IPV6_JOIN_GROUP failed"));
            }
            if (Errno.errno() == Errno.ENOENT()) {
                throw new SocketException("Not a member of the multicast group");
            }
            throw new SocketException(PosixUtils.lastErrorString("setsockopt IPV6_LEAVE_GROUP failed"));
        }
    }

    static void mcast_join_leave(Target_java_net_PlainDatagramSocketImpl self, InetAddress iaObj, NetworkInterface niObj, boolean join) throws IOException {
        if (IsDefined.__linux__()) {
            Util_java_net_PlainDatagramSocketImpl.mcast_join_leave_linux(self, iaObj, niObj, join);
        } else {
            Util_java_net_PlainDatagramSocketImpl.mcast_join_leave_non_linux(self, iaObj, niObj, join);
        }
    }
}

