/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.posix.PosixUtils;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.word.WordBase;

class ProcFSSupport {
    private static final int ST_ADDR_START = 1;
    private static final int ST_ADDR_END = 2;
    private static final int ST_PERMS = 3;
    private static final int ST_OFFSET = 4;
    private static final int ST_DEV = 5;
    private static final int ST_INODE = 6;
    private static final int ST_SPACE = 7;
    private static final int ST_FILENAME = 8;
    private static final int ST_SKIP = 9;

    ProcFSSupport() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Uninterruptible(reason="Called during isolate initialization.")
    static boolean findMapping(int fd, CCharPointer buffer, int bufferLen, WordBase beginAddress, WordBase endAddress, CLongPointer startAddrPtr, CLongPointer fileOffsetPtr, CLongPointer inodePtr, boolean needName) {
        int readOffset = 0;
        int endOffset = 0;
        int position = 0;
        int state = 1;
        long start = 0L;
        long end = 0L;
        long fileOffset = 0L;
        long inode = 0L;
        block11: while (true) {
            if (position == endOffset) {
                int readBytes = PosixUtils.readBytes(fd, buffer, bufferLen, readOffset);
                if (readBytes <= 0) {
                    return false;
                }
                position = readOffset;
                endOffset = readOffset + readBytes;
                continue;
            }
            int b = buffer.read(position++) & 0xFF;
            switch (state) {
                case 1: {
                    if (b == 45) {
                        state = beginAddress.rawValue() >= start ? 2 : 9;
                        break;
                    }
                    if (48 <= b && b <= 57) {
                        start = (start << 4) + (long)(b - 48);
                        break;
                    }
                    if (97 <= b && b <= 102) {
                        start = (start << 4) + (long)(b - 97 + 10);
                        break;
                    }
                    return false;
                }
                case 2: {
                    if (b == 32) {
                        state = endAddress.rawValue() <= end ? 3 : 9;
                        break;
                    }
                    if (48 <= b && b <= 57) {
                        end = (end << 4) + (long)(b - 48);
                        break;
                    }
                    if (97 <= b && b <= 102) {
                        end = (end << 4) + (long)(b - 97 + 10);
                        break;
                    }
                    return false;
                }
                case 3: {
                    if (b != 32) break;
                    fileOffset = 0L;
                    state = 4;
                    break;
                }
                case 4: {
                    if (b == 32) {
                        state = 5;
                        break;
                    }
                    if (48 <= b && b <= 57) {
                        fileOffset = (fileOffset << 4) + (long)(b - 48);
                        break;
                    }
                    if (97 <= b && b <= 102) {
                        fileOffset = (fileOffset << 4) + (long)(b - 97 + 10);
                        break;
                    }
                    return false;
                }
                case 5: {
                    if (b != 32) break;
                    inode = 0L;
                    state = 6;
                    break;
                }
                case 6: {
                    if (b == 32) {
                        readOffset = 0;
                        if (!needName) {
                            buffer.write(0, (byte)0);
                            break block11;
                        }
                        state = 7;
                        break;
                    }
                    if (48 <= b && b <= 57) {
                        inode = (inode << 3) + (inode << 1) + (long)(b - 48);
                        break;
                    }
                    return false;
                }
                case 7: {
                    if (b == 32) break;
                    state = 8;
                }
                case 8: {
                    if (b == 10) {
                        buffer.write(readOffset, (byte)0);
                        break block11;
                    }
                    if (readOffset < position - 1) {
                        buffer.write(readOffset, (byte)(b & 0xFF));
                    }
                    if (++readOffset < bufferLen) break;
                    return false;
                }
                case 9: {
                    if (b != 10) break;
                    start = 0L;
                    end = 0L;
                    state = 1;
                }
            }
        }
        if (startAddrPtr.isNonNull()) {
            startAddrPtr.write(start);
        }
        if (fileOffsetPtr.isNonNull()) {
            fileOffsetPtr.write(fileOffset);
        }
        if (inodePtr.isNonNull()) {
            inodePtr.write(inode);
        }
        return true;
    }
}

