/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.core.windows.WindowsUtils;
import com.oracle.svm.core.windows.headers.Process;
import com.oracle.svm.core.windows.headers.WinBase;
import java.nio.file.Files;
import java.nio.file.Path;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.ProcessPropertiesSupport;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.WINDOWS.class})
public class WindowsProcessPropertiesSupport
implements ProcessPropertiesSupport {
    public String getExecutableName() {
        CCharPointer path = (CCharPointer)StackValue.get((int)260, CCharPointer.class);
        WinBase.HMODULE hModule = WinBase.GetModuleHandleA(WordFactory.nullPointer());
        int result = WinBase.GetModuleFileNameA(hModule, path, 260);
        return result == 0 ? null : CTypeConversion.toJavaString((CCharPointer)path);
    }

    public void exec(Path executable, String[] args) {
        if (!Files.isExecutable(executable)) {
            throw new RuntimeException("Path " + executable + " does not point to executable file");
        }
        try (CTypeConversion.CCharPointerHolder pathHolder = CTypeConversion.toCString((CharSequence)executable.toString());
             CTypeConversion.CCharPointerPointerHolder argvHolder = CTypeConversion.toCStrings((CharSequence[])args);){
            if (Process._execv(pathHolder.get(), argvHolder.get()) != 0) {
                String msg = WindowsUtils.lastErrorString("Executing " + executable + " with arguments " + String.join((CharSequence)" ", args) + " failed");
                throw new RuntimeException(msg);
            }
        }
    }

    public long getProcessID() {
        throw VMError.unimplemented();
    }

    public long getProcessID(java.lang.Process process) {
        throw VMError.unimplemented();
    }

    public String getObjectFile(String symbol) {
        throw VMError.unimplemented();
    }

    public String getObjectFile(CEntryPointLiteral<?> symbol) {
        WinBase.HMODULEPointer module = (WinBase.HMODULEPointer)StackValue.get(WinBase.HMODULEPointer.class);
        if (!WinBase.GetModuleHandleExA(WinBase.GET_MODULE_HANDLE_EX_FLAG_FROM_ADDRESS() | WinBase.GET_MODULE_HANDLE_EX_FLAG_UNCHANGED_REFCOUNT(), (PointerBase)symbol.getFunctionPointer(), module)) {
            return null;
        }
        CCharPointer path = (CCharPointer)StackValue.get((int)260, CCharPointer.class);
        int result = WinBase.GetModuleFileNameA(module.read(), path, 260);
        return result == 0 ? null : CTypeConversion.toJavaString((CCharPointer)path);
    }

    public String setLocale(String category, String locale) {
        throw VMError.unimplemented();
    }

    public boolean destroy(long processID) {
        throw VMError.unimplemented();
    }

    public boolean destroyForcibly(long processID) {
        throw VMError.unimplemented();
    }

    public boolean isAlive(long processID) {
        throw VMError.unimplemented();
    }

    public int waitForProcessExit(long processID) {
        throw VMError.unimplemented();
    }

    @AutomaticFeature
    public static class ImagePropertiesFeature
    implements Feature {
        public void afterRegistration(Feature.AfterRegistrationAccess access) {
            ImageSingletons.add(ProcessPropertiesSupport.class, (Object)new WindowsProcessPropertiesSupport());
        }
    }
}

