/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.meta;

import com.oracle.svm.core.graal.meta.SubstrateMemoryAccessProvider;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.meta.SubstrateMetaAccess;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import org.graalvm.compiler.word.BarrieredAccess;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;
import sun.misc.Unsafe;

public final class SubstrateMemoryAccessProviderImpl
implements SubstrateMemoryAccessProvider {
    private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();
    public static final SubstrateMemoryAccessProviderImpl SINGLETON = new SubstrateMemoryAccessProviderImpl();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private SubstrateMemoryAccessProviderImpl() {
    }

    static JavaConstant readUnsafeConstant(JavaKind kind, JavaConstant base, long displacement, boolean isVolatile) {
        if (kind == JavaKind.Object) {
            return SubstrateMemoryAccessProviderImpl.readObjectConstant((Constant)base, displacement, null, isVolatile);
        }
        return SubstrateMemoryAccessProviderImpl.readPrimitiveConstant(kind, (Constant)base, displacement, kind.getByteCount() * 8, isVolatile);
    }

    public JavaConstant readObjectConstant(Constant baseConstant, long displacement) {
        return SubstrateMemoryAccessProviderImpl.readObjectConstant(baseConstant, displacement, null, false);
    }

    @Override
    public JavaConstant readNarrowObjectConstant(Constant baseConstant, long displacement, CompressEncoding encoding) {
        return SubstrateMemoryAccessProviderImpl.readObjectConstant(baseConstant, displacement, encoding, false);
    }

    private static JavaConstant readObjectConstant(Constant baseConstant, long displacement, CompressEncoding compressedEncoding, boolean isVolatile) {
        SignedWord offset = WordFactory.signed((long)displacement);
        if (baseConstant instanceof SubstrateObjectConstant) {
            if (compressedEncoding != null) {
                assert (ReferenceAccess.singleton().haveCompressedReferences());
                if (!compressedEncoding.equals((Object)ReferenceAccess.singleton().getCompressEncoding())) {
                    return null;
                }
            }
            Object baseObject = SubstrateObjectConstant.asObject(baseConstant);
            assert (baseObject != null) : "SubstrateObjectConstant does not wrap null value";
            SubstrateMetaAccess metaAccess = SubstrateMetaAccess.singleton();
            ResolvedJavaType baseObjectType = metaAccess.lookupJavaType((Class)baseObject.getClass());
            SubstrateMemoryAccessProviderImpl.checkRead(JavaKind.Object, displacement, baseObjectType, baseObject);
            Object rawValue = BarrieredAccess.readObject((Object)baseObject, (WordBase)offset);
            if (isVolatile) {
                UNSAFE.loadFence();
            }
            return SubstrateObjectConstant.forObject(rawValue, compressedEncoding != null);
        }
        if (baseConstant instanceof PrimitiveConstant) {
            assert (compressedEncoding == null);
            PrimitiveConstant prim = (PrimitiveConstant)baseConstant;
            if (!prim.getJavaKind().isNumericInteger()) {
                return null;
            }
            Word baseAddress = (Word)WordFactory.unsigned((long)prim.asLong());
            if (baseAddress.equal(0)) {
                return null;
            }
            Word address = baseAddress.add(offset);
            Object rawValue = ReferenceAccess.singleton().readObjectAt((Pointer)address, false);
            if (isVolatile) {
                UNSAFE.loadFence();
            }
            return SubstrateObjectConstant.forObject(rawValue, false);
        }
        return null;
    }

    private static void checkRead(JavaKind kind, long displacement, ResolvedJavaType type, Object object) {
        if (kind != JavaKind.Object) {
            throw VMError.unimplemented();
        }
        if (type.isArray()) {
            int length = KnownIntrinsics.readArrayLength(object);
            if (length < 1) {
                throw new IllegalArgumentException("Unsafe array access: reading element of kind " + kind + " at offset " + displacement + " from zero-sized array " + type.toJavaName());
            }
            int encoding = KnownIntrinsics.readHub(object).getLayoutEncoding();
            UnsignedWord unsignedDisplacement = WordFactory.unsigned((long)displacement);
            UnsignedWord maxDisplacement = LayoutEncoding.getArrayElementOffset(encoding, length - 1);
            if (displacement < 0L || maxDisplacement.belowThan(unsignedDisplacement)) {
                int elementSize = LayoutEncoding.getArrayIndexScale(encoding);
                UnsignedWord index = unsignedDisplacement.subtract(LayoutEncoding.getArrayBaseOffset(encoding)).unsignedDivide(elementSize);
                throw new IllegalArgumentException("Unsafe array access: reading element of kind " + kind + " at offset " + displacement + " (index ~ " + index.rawValue() + ") in " + type.toJavaName() + " object of length " + length);
            }
        } else {
            ResolvedJavaField field = type.findInstanceFieldWithOffset(displacement, JavaKind.Object);
            if (field == null) {
                throw new IllegalArgumentException("Unsafe object access: field not found for read of kind Object at offset " + displacement + " in " + type.toJavaName() + " object");
            }
            if (field.getJavaKind() != JavaKind.Object) {
                throw new IllegalArgumentException("Unsafe object access: field " + field.format("%H.%n:%T") + " not of expected kind Object at offset " + displacement + " in " + type.toJavaName() + " object");
            }
        }
    }

    public JavaConstant readPrimitiveConstant(JavaKind kind, Constant baseConstant, long displacement, int bits) {
        return SubstrateMemoryAccessProviderImpl.readPrimitiveConstant(kind, baseConstant, displacement, bits, false);
    }

    private static JavaConstant readPrimitiveConstant(JavaKind kind, Constant baseConstant, long displacement, int bits, boolean isVolatile) {
        long rawValue;
        SignedWord offset = WordFactory.signed((long)displacement);
        if (baseConstant instanceof SubstrateObjectConstant) {
            Object baseObject = SubstrateObjectConstant.asObject(baseConstant);
            assert (baseObject != null) : "SubstrateObjectConstant does not wrap null value";
            switch (bits) {
                case 8: {
                    rawValue = BarrieredAccess.readByte((Object)baseObject, (WordBase)offset);
                    break;
                }
                case 16: {
                    rawValue = BarrieredAccess.readShort((Object)baseObject, (WordBase)offset);
                    break;
                }
                case 32: {
                    rawValue = BarrieredAccess.readInt((Object)baseObject, (WordBase)offset);
                    break;
                }
                case 64: {
                    rawValue = BarrieredAccess.readLong((Object)baseObject, (WordBase)offset);
                    break;
                }
                default: {
                    throw VMError.shouldNotReachHere();
                }
            }
        } else if (baseConstant instanceof PrimitiveConstant) {
            PrimitiveConstant prim = (PrimitiveConstant)baseConstant;
            if (!prim.getJavaKind().isNumericInteger()) {
                return null;
            }
            Pointer basePointer = (Pointer)WordFactory.unsigned((long)prim.asLong());
            if (basePointer.equal(0)) {
                return null;
            }
            switch (bits) {
                case 8: {
                    rawValue = basePointer.readByte((WordBase)offset);
                    break;
                }
                case 16: {
                    rawValue = basePointer.readShort((WordBase)offset);
                    break;
                }
                case 32: {
                    rawValue = basePointer.readInt((WordBase)offset);
                    break;
                }
                case 64: {
                    rawValue = basePointer.readLong((WordBase)offset);
                    break;
                }
                default: {
                    throw VMError.shouldNotReachHere();
                }
            }
        } else {
            return null;
        }
        if (isVolatile) {
            UNSAFE.loadFence();
        }
        return SubstrateMemoryAccessProviderImpl.toConstant(kind, rawValue);
    }

    public static JavaConstant toConstant(JavaKind kind, long rawValue) {
        switch (kind) {
            case Boolean: {
                return JavaConstant.forBoolean((rawValue != 0L ? 1 : 0) != 0);
            }
            case Byte: {
                return JavaConstant.forByte((byte)((byte)rawValue));
            }
            case Char: {
                return JavaConstant.forChar((char)((char)rawValue));
            }
            case Short: {
                return JavaConstant.forShort((short)((short)rawValue));
            }
            case Int: {
                return JavaConstant.forInt((int)((int)rawValue));
            }
            case Long: {
                return JavaConstant.forLong((long)rawValue);
            }
            case Float: {
                return JavaConstant.forFloat((float)Float.intBitsToFloat((int)rawValue));
            }
            case Double: {
                return JavaConstant.forDouble((double)Double.longBitsToDouble(rawValue));
            }
        }
        throw VMError.shouldNotReachHere();
    }
}

