/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.configure.ResourceConfigurationParser;
import com.oracle.svm.core.configure.ResourcesRegistry;
import com.oracle.svm.core.jdk.LocalizationFeature;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.config.ConfigurationParserUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public final class ResourcesFeature
implements Feature {
    private boolean sealed = false;
    private Set<String> newResources = Collections.newSetFromMap(new ConcurrentHashMap());
    private int loadedConfigurations;

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(ResourcesRegistry.class, (Object)new ResourcesRegistryImpl());
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        ImageClassLoader imageClassLoader = ((FeatureImpl.BeforeAnalysisAccessImpl)access).getImageClassLoader();
        ResourceConfigurationParser parser = new ResourceConfigurationParser((ResourcesRegistry)ImageSingletons.lookup(ResourcesRegistry.class));
        this.loadedConfigurations = ConfigurationParserUtils.parseAndRegisterConfigurations(parser, imageClassLoader, "resource", ConfigurationFiles.Options.ResourceConfigurationFiles, ConfigurationFiles.Options.ResourceConfigurationResources, "resource-config.json");
        this.newResources.addAll(Arrays.asList(Options.IncludeResources.getValue()));
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        if (this.newResources.isEmpty()) {
            return;
        }
        access.requireAnalysisIteration();
        for (String regExp : this.newResources) {
            if (regExp.length() == 0) continue;
            Pattern pattern = Pattern.compile(regExp);
            HashSet<File> todo = new HashSet<File>();
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader instanceof URLClassLoader) {
                for (URL url : ((URLClassLoader)contextClassLoader).getURLs()) {
                    try {
                        File file = new File(url.toURI());
                        todo.add(file);
                    }
                    catch (IllegalArgumentException | URISyntaxException e) {
                        throw UserError.abort("Unable to handle imagecp element '" + url.toExternalForm() + "'. Make sure that all imagecp entries are either directories or valid jar files.");
                    }
                }
            }
            for (File element : todo) {
                try {
                    DebugContext debugContext = ((FeatureImpl.DuringAnalysisAccessImpl)access).getDebugContext();
                    if (element.isDirectory()) {
                        this.scanDirectory(debugContext, element, "", pattern);
                        continue;
                    }
                    ResourcesFeature.scanJar(debugContext, element, pattern);
                }
                catch (IOException ex) {
                    throw UserError.abort("Unable to handle classpath element '" + element + "'. Make sure that all classpath entries are either directories or valid jar files.");
                }
            }
        }
        this.newResources.clear();
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.sealed = true;
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        if (!ImageSingletons.contains(FallbackFeature.class)) {
            return;
        }
        FallbackFeature.FallbackImageRequest resourceFallback = ((FallbackFeature)ImageSingletons.lookup(FallbackFeature.class)).resourceFallback;
        if (resourceFallback != null && Options.IncludeResources.getValue().length == 0 && this.loadedConfigurations == 0) {
            throw resourceFallback;
        }
    }

    private void scanDirectory(DebugContext debugContext, File f, String relativePath, Pattern ... patterns) throws IOException {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            if (files == null) {
                throw UserError.abort("Cannot scan directory " + f);
            }
            for (File ch : files) {
                this.scanDirectory(debugContext, ch, relativePath.isEmpty() ? ch.getName() : relativePath + "/" + ch.getName(), patterns);
            }
        } else if (ResourcesFeature.matches(patterns, relativePath)) {
            try (FileInputStream is = new FileInputStream(f);){
                try (DebugContext.Scope s = debugContext.scope((Object)"registerResource");){
                    debugContext.log("ResourcesFeature: registerResource: " + relativePath);
                }
                Resources.registerResource(relativePath, is);
            }
        }
    }

    private static void scanJar(DebugContext debugContext, File element, Pattern ... patterns) throws IOException {
        JarFile jf = new JarFile(element);
        Enumeration<JarEntry> en = jf.entries();
        while (en.hasMoreElements()) {
            JarEntry e = en.nextElement();
            if (e.getName().endsWith("/") || !ResourcesFeature.matches(patterns, e.getName())) continue;
            InputStream is = jf.getInputStream(e);
            try {
                try (DebugContext.Scope s = debugContext.scope((Object)"registerResource");){
                    debugContext.log("ResourcesFeature: registerResource: " + e.getName());
                }
                Resources.registerResource(e.getName(), is);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
    }

    private static boolean matches(Pattern[] patterns, String relativePath) {
        for (Pattern p : patterns) {
            if (!p.matcher(relativePath).matches()) continue;
            return true;
        }
        return false;
    }

    private class ResourcesRegistryImpl
    implements ResourcesRegistry {
        private ResourcesRegistryImpl() {
        }

        @Override
        public void addResources(String pattern) {
            UserError.guarantee(!ResourcesFeature.this.sealed, "Resources added too late", new Object[0]);
            ResourcesFeature.this.newResources.add(pattern);
        }

        @Override
        public void addResourceBundles(String name) {
            ((LocalizationFeature)ImageSingletons.lookup(LocalizationFeature.class)).addBundleToCache(name);
        }
    }

    public static class Options {
        @Option(help={"Regexp to match names of resources to be included in the image."}, type=OptionType.User)
        public static final HostedOptionKey<String[]> IncludeResources = new HostedOptionKey<String[]>(new String[0]);
    }
}

