/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.codegen;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.util.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.graalvm.nativeimage.Platform;

public class CCompilerInvoker {
    protected final NativeLibraries nativeLibs;
    protected final Path tempDirectory;
    private String lastExecutedCommand = "";

    public CCompilerInvoker(NativeLibraries nativeLibs, Path tempDirectory) {
        this.nativeLibs = nativeLibs;
        this.tempDirectory = tempDirectory;
    }

    public Process startPreprocessor(List<String> options, Path sourceFile) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(Platform.includedIn(Platform.WINDOWS.class) ? "CL" : "gcc");
        command.add("-E");
        command.add(sourceFile.normalize().toString());
        command.addAll(options);
        return this.startCommand(command);
    }

    public Path compileAndParseError(List<String> options, Path source, Path target) {
        try {
            Process compilingProcess = this.startCompiler(options, source.normalize(), target.normalize());
            InputStream es = compilingProcess.getErrorStream();
            InputStream is = compilingProcess.getInputStream();
            List<String> lines = FileUtils.readAllLines(es);
            FileUtils.readAllLines(is);
            int status = compilingProcess.waitFor();
            boolean errorReported = false;
            for (String line : lines) {
                if (!line.contains(": error:") && !line.contains(": fatal error:")) continue;
                this.reportCompilerError(source, line);
                errorReported = true;
            }
            if (status != 0 && !errorReported) {
                this.reportCompilerError(source, lines.toString());
            }
            compilingProcess.destroy();
            return target;
        }
        catch (InterruptedException ex) {
            throw new InterruptImageBuilding();
        }
        catch (IOException ex) {
            throw UserError.abort("Unable to compile C-ABI query code. Make sure native software development toolchain is installed on your system.", ex);
        }
    }

    public static String getCCompilerPath() {
        Path path;
        String compilerPath = SubstrateOptions.CCompilerPath.getValue();
        if (compilerPath != null && (Files.isDirectory(path = Paths.get(compilerPath, new String[0]), new LinkOption[0]) || !Files.isExecutable(path))) {
            throw UserError.abort(SubstrateOptionsParser.commandArgument(SubstrateOptions.CCompilerPath, compilerPath) + " does not specify a path to an executable.");
        }
        return compilerPath;
    }

    public Process startCompiler(List<String> options, Path source, Path target) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        String compilerPath = CCompilerInvoker.getCCompilerPath();
        if (compilerPath == null) {
            compilerPath = Platform.includedIn(Platform.WINDOWS.class) ? "CL" : "gcc";
        }
        command.add(compilerPath);
        command.addAll(Arrays.asList(SubstrateOptions.CCompilerOption.getValue()));
        command.addAll(options);
        command.add(source.normalize().toString());
        if (target != null) {
            if (Platform.includedIn(Platform.WINDOWS.class)) {
                command.add("/Fe" + target.normalize().toString());
            } else {
                command.add("-o");
                command.add(target.normalize().toString());
            }
        }
        return this.startCommand(command);
    }

    protected String commandString(List<String> command) {
        StringBuilder sb = new StringBuilder();
        for (String s : command) {
            sb.append(' ').append(s);
        }
        return sb.toString();
    }

    public String lastExecutedCommand() {
        return this.lastExecutedCommand;
    }

    public Process startCommand(List<String> command) throws IOException {
        Process proc = null;
        ProcessBuilder pb = new ProcessBuilder(new String[0]).command(command).directory(this.tempDirectory.toFile());
        proc = pb.start();
        this.lastExecutedCommand = this.commandString(pb.command());
        return proc;
    }

    public int runCommandToExit(List<String> command) {
        int status;
        try {
            Process p = this.startCommand(command);
            FileUtils.drainInputStream(p.getInputStream(), System.err);
            status = p.waitFor();
        }
        catch (IOException e) {
            throw new RuntimeException("Error when running command: " + command + "(wd: " + this.tempDirectory.toString() + ")", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting for command: " + command);
        }
        if (status != 0) {
            throw new IllegalStateException("command returned " + status);
        }
        return status;
    }

    protected void reportCompilerError(Path queryFile, String line) {
        throw VMError.shouldNotReachHere(line);
    }
}

