/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import com.oracle.svm.core.jni.JNIRuntimeAccess;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.InternalPlatform;

@Platforms(value={InternalPlatform.PLATFORM_JNI.class})
@AutomaticFeature
class JNIRegistrationsJavaZip
extends JNIRegistrationUtil
implements Feature {
    JNIRegistrationsJavaZip() {
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        JNIRegistrationsJavaZip.rerunClassInit((Feature.FeatureAccess)a, "java.util.zip.Inflater", "java.util.zip.Deflater");
        if (JavaVersionUtil.JAVA_SPEC >= 11) {
            JNIRegistrationsJavaZip.rerunClassInit((Feature.FeatureAccess)a, "java.util.zip.Adler32", "java.util.zip.CRC32");
            JNIRegistrationsJavaZip.rerunClassInit((Feature.FeatureAccess)a, "sun.net.www.protocol.jar.JarFileFactory", "sun.net.www.protocol.jar.JarURLConnection");
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        if (JavaVersionUtil.JAVA_SPEC >= 11) {
            a.registerReachabilityHandler(JNIRegistrationsJavaZip::registerJDK11InflaterInitIDs, new Object[]{JNIRegistrationsJavaZip.method((Feature.FeatureAccess)a, "java.util.zip.Inflater", "initIDs", new Class[0])});
        } else {
            a.registerReachabilityHandler(JNIRegistrationsJavaZip::registerJDK8InflaterInitIDs, new Object[]{JNIRegistrationsJavaZip.method((Feature.FeatureAccess)a, "java.util.zip.Inflater", "initIDs", new Class[0])});
            a.registerReachabilityHandler(JNIRegistrationsJavaZip::registerJDK8DeflaterInitIDs, new Object[]{JNIRegistrationsJavaZip.method((Feature.FeatureAccess)a, "java.util.zip.Deflater", "initIDs", new Class[0])});
        }
    }

    private static void registerJDK11InflaterInitIDs(Feature.DuringAnalysisAccess a) {
        JNIRuntimeAccess.register(JNIRegistrationsJavaZip.fields((Feature.FeatureAccess)a, "java.util.zip.Inflater", "inputConsumed", "outputConsumed"));
    }

    private static void registerJDK8InflaterInitIDs(Feature.DuringAnalysisAccess a) {
        JNIRuntimeAccess.register(JNIRegistrationsJavaZip.fields((Feature.FeatureAccess)a, "java.util.zip.Inflater", "needDict", "finished", "buf", "off", "len"));
    }

    private static void registerJDK8DeflaterInitIDs(Feature.DuringAnalysisAccess a) {
        JNIRuntimeAccess.register(JNIRegistrationsJavaZip.fields((Feature.FeatureAccess)a, "java.util.zip.Deflater", "level", "strategy", "setParams", "finish", "finished", "buf", "off", "len"));
    }
}

