/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.svm.hosted.c.GraalAccess;
import java.lang.annotation.Annotation;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;

public class SubstitutionType
implements ResolvedJavaType,
OriginalClassProvider {
    private final ResolvedJavaType original;
    private final ResolvedJavaType annotated;

    public SubstitutionType(ResolvedJavaType original, ResolvedJavaType annotated) {
        this.annotated = annotated;
        this.original = original;
    }

    public ResolvedJavaType getOriginal() {
        return this.original;
    }

    public ResolvedJavaType getAnnotated() {
        return this.annotated;
    }

    public String getName() {
        return this.original.getName();
    }

    public JavaKind getJavaKind() {
        return this.annotated.getJavaKind();
    }

    public ResolvedJavaType resolve(ResolvedJavaType accessingClass) {
        return this;
    }

    public boolean hasFinalizer() {
        return this.annotated.hasFinalizer();
    }

    public Assumptions.AssumptionResult<Boolean> hasFinalizableSubclass() {
        return this.annotated.hasFinalizableSubclass();
    }

    public boolean isInterface() {
        return this.annotated.isInterface();
    }

    public boolean isInstanceClass() {
        return this.annotated.isInstanceClass();
    }

    public boolean isArray() {
        return this.annotated.isArray();
    }

    public boolean isPrimitive() {
        return this.annotated.isPrimitive();
    }

    public boolean isEnum() {
        return this.annotated.isEnum();
    }

    public int getModifiers() {
        int result = this.annotated.getModifiers();
        if (!this.original.isLeaf()) {
            result &= 0xFFFFFFEF;
        }
        return result;
    }

    public boolean isInitialized() {
        return this.annotated.isInitialized();
    }

    public void initialize() {
        this.original.initialize();
        this.annotated.initialize();
    }

    public boolean isAssignableFrom(ResolvedJavaType other) {
        return this.annotated.isAssignableFrom(other) || this.original.isAssignableFrom(other);
    }

    public boolean isInstance(JavaConstant obj) {
        return this.annotated.isInstance(obj) || this.original.isInstance(obj);
    }

    public ResolvedJavaType getSuperclass() {
        return this.annotated.getSuperclass();
    }

    public ResolvedJavaType[] getInterfaces() {
        return this.annotated.getInterfaces();
    }

    public ResolvedJavaType findLeastCommonAncestor(ResolvedJavaType otherType) {
        return this.annotated.findLeastCommonAncestor(otherType);
    }

    public ResolvedJavaType getSingleImplementor() {
        return this.annotated.getSingleImplementor();
    }

    public Assumptions.AssumptionResult<ResolvedJavaType> findLeafConcreteSubtype() {
        return null;
    }

    public ResolvedJavaType getComponentType() {
        return this.annotated.getComponentType();
    }

    public ResolvedJavaType getArrayClass() {
        return this.annotated.getArrayClass();
    }

    public ResolvedJavaMethod resolveConcreteMethod(ResolvedJavaMethod method, ResolvedJavaType callerType) {
        ResolvedJavaMethod result = this.annotated.resolveConcreteMethod(method, callerType);
        if (result == null) {
            result = this.original.resolveConcreteMethod(method, callerType);
        }
        return result;
    }

    public ResolvedJavaMethod resolveMethod(ResolvedJavaMethod method, ResolvedJavaType callerType) {
        ResolvedJavaMethod result = this.annotated.resolveMethod(method, callerType);
        if (result == null) {
            result = this.original.resolveMethod(method, callerType);
        }
        return result;
    }

    public Assumptions.AssumptionResult<ResolvedJavaMethod> findUniqueConcreteMethod(ResolvedJavaMethod method) {
        return null;
    }

    public ResolvedJavaField[] getInstanceFields(boolean includeSuperclasses) {
        return this.annotated.getInstanceFields(includeSuperclasses);
    }

    public ResolvedJavaField[] getStaticFields() {
        return this.annotated.getStaticFields();
    }

    public Annotation[] getAnnotations() {
        return this.annotated.getAnnotations();
    }

    public Annotation[] getDeclaredAnnotations() {
        return this.annotated.getDeclaredAnnotations();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)this.annotated.getAnnotation(annotationClass);
    }

    public ResolvedJavaField findInstanceFieldWithOffset(long offset, JavaKind expectedKind) {
        return this.annotated.findInstanceFieldWithOffset(offset, expectedKind);
    }

    public String getSourceFileName() {
        return this.annotated.getSourceFileName();
    }

    public boolean isLocal() {
        return this.annotated.isLocal();
    }

    public boolean isMember() {
        return this.annotated.isMember();
    }

    public ResolvedJavaType getEnclosingType() {
        return this.annotated.getEnclosingType();
    }

    public ResolvedJavaMethod[] getDeclaredConstructors() {
        return this.annotated.getDeclaredConstructors();
    }

    public ResolvedJavaMethod[] getDeclaredMethods() {
        return this.annotated.getDeclaredMethods();
    }

    public ResolvedJavaMethod getClassInitializer() {
        return this.annotated.getClassInitializer();
    }

    public boolean isLinked() {
        assert (this.original.isLinked() && this.annotated.isLinked());
        return true;
    }

    public boolean isCloneableWithAllocation() {
        throw JVMCIError.unimplemented();
    }

    public ResolvedJavaType getHostClass() {
        return this.original.getHostClass();
    }

    public Class<?> getJavaClass() {
        return OriginalClassProvider.getJavaClass((SnippetReflectionProvider)GraalAccess.getOriginalSnippetReflection(), (ResolvedJavaType)this.original);
    }

    public String toString() {
        return "SubstitutionType<definition " + this.original.toString() + ", implementation " + this.annotated.toString() + ">";
    }
}

