/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.hosted;

import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import java.lang.reflect.Field;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;

public class FieldOffsetComputer
implements RecomputeFieldValue.CustomFieldValueComputer {
    @Override
    public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
        VMError.guarantee(metaAccess instanceof HostedMetaAccess, "Field offset computation must be done during compilation.");
        HostedField hostedField = ((HostedMetaAccess)metaAccess).optionalLookupJavaField((Field)receiver);
        if (hostedField != null && hostedField.wrapped.isUnsafeAccessed()) {
            int location = hostedField.getLocation();
            VMError.guarantee(location > 0, "Incorrect field location: " + location + " for " + hostedField.format("%H.%n"));
            return location;
        }
        return -1;
    }
}

