/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.api;

import com.oracle.svm.core.graal.phases.DeadStoreRemovalPhase;
import com.oracle.svm.truffle.api.SubstrateKnownTruffleTypes;
import com.oracle.svm.truffle.api.SubstratePEGraphDecoder;
import com.oracle.svm.truffle.api.SubstrateTruffleGraphBuilderPlugins;
import com.oracle.svm.truffle.api.TruffleBoundaryPhase;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.graph.SourceLanguagePositionProvider;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.LoopExplosionPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.ParameterPlugin;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.PEGraphDecoder;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleInliningPlan;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;
import org.graalvm.compiler.truffle.compiler.TruffleConstantFieldProvider;
import org.graalvm.compiler.truffle.compiler.substitutions.KnownTruffleTypes;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class SubstratePartialEvaluator
extends PartialEvaluator {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstratePartialEvaluator(Providers providers, GraphBuilderConfiguration configForRoot, SnippetReflectionProvider snippetReflection, Architecture architecture) {
        super(providers, configForRoot, snippetReflection, architecture, (KnownTruffleTypes)new SubstrateKnownTruffleTypes(providers.getMetaAccess()));
    }

    protected PEGraphDecoder createGraphDecoder(StructuredGraph graph, HighTierContext tierContext, LoopExplosionPlugin loopExplosionPlugin, InvocationPlugins invocationPlugins, InlineInvokePlugin[] inlineInvokePlugins, ParameterPlugin parameterPlugin, NodePlugin[] nodePlugins, SourceLanguagePositionProvider sourceLanguagePositionProvider, EconomicMap<ResolvedJavaMethod, EncodedGraph> graphCache) {
        TruffleConstantFieldProvider compilationLocalConstantProvider = new TruffleConstantFieldProvider(this.providers.getConstantFieldProvider(), this.providers.getMetaAccess());
        return new SubstratePEGraphDecoder(this.architecture, graph, (CoreProviders)this.providers.copyWith((ConstantFieldProvider)compilationLocalConstantProvider), loopExplosionPlugin, invocationPlugins, inlineInvokePlugins, parameterPlugin, nodePlugins, this.callInlinedMethod, this.callInlinedAgnosticMethod, sourceLanguagePositionProvider);
    }

    protected StructuredGraph.Builder customizeStructuredGraphBuilder(StructuredGraph.Builder builder) {
        return super.customizeStructuredGraphBuilder(builder).recordInlinedMethods(false);
    }

    protected void doGraphPE(CompilableTruffleAST callTarget, StructuredGraph graph, HighTierContext tierContext, TruffleInliningPlan inliningDecision, InlineInvokePlugin inlineInvokePlugin, EconomicMap<ResolvedJavaMethod, EncodedGraph> graphCache) {
        super.doGraphPE(callTarget, graph, tierContext, inliningDecision, inlineInvokePlugin, graphCache);
        new DeadStoreRemovalPhase().apply(graph);
        new TruffleBoundaryPhase().apply(graph);
    }

    protected void registerTruffleInvocationPlugins(InvocationPlugins invocationPlugins, boolean canDelayIntrinsification) {
        super.registerTruffleInvocationPlugins(invocationPlugins, canDelayIntrinsification);
        SubstrateTruffleGraphBuilderPlugins.registerCompilationFinalReferencePlugins(invocationPlugins, canDelayIntrinsification, (SubstrateKnownTruffleTypes)this.getKnownTruffleTypes());
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected InvocationPlugins createDecodingInvocationPlugins(GraphBuilderConfiguration.Plugins parent) {
        InvocationPlugins decodingInvocationPlugins = new InvocationPlugins();
        this.registerTruffleInvocationPlugins(decodingInvocationPlugins, false);
        decodingInvocationPlugins.closeRegistration();
        return decodingInvocationPlugins;
    }

    protected NodePlugin[] createNodePlugins(GraphBuilderConfiguration.Plugins plugins) {
        return null;
    }
}

