/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import java.util.Collections;
import java.util.List;
import org.graalvm.compiler.core.llvm.LLVMUtils;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
@Platforms(value={Platform.AMD64.class})
class LLVMAMD64TargetSpecificFeature
implements Feature {
    private static final int AMD64_RSP_IDX = 7;
    private static final int AMD64_RBP_IDX = 6;

    LLVMAMD64TargetSpecificFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return ((String)SubstrateOptions.CompilerBackend.getValue()).equals("llvm");
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(LLVMUtils.TargetSpecific.class, (Object)new LLVMUtils.TargetSpecific(){

            public String getRegisterInlineAsm(String register) {
                return "movq %" + register + ", $0";
            }

            public String getJumpInlineAsm() {
                return "jmpq *$0";
            }

            public String getLLVMArchName() {
                return "x86-64";
            }

            public int getCallFrameSeparation() {
                return FrameAccess.returnAddressSize();
            }

            public int getFramePointerOffset() {
                return -FrameAccess.wordSize();
            }

            public int getStackPointerDwarfRegNum() {
                return 7;
            }

            public int getFramePointerDwarfRegNum() {
                return 6;
            }

            public List<String> getLLCAdditionalOptions() {
                return Collections.singletonList("-no-x86-call-frame-opt");
            }
        });
    }
}

