/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.c.function.CEntryPointBuiltins;
import com.oracle.svm.core.c.function.CEntryPointNativeFunctions;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.graal.code.SubstrateCallingConvention;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionType;
import com.oracle.svm.core.graal.code.SubstrateLIRGenerator;
import com.oracle.svm.core.graal.llvm.LLVMFeature;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.graal.snippets.CEntryPointSnippets;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.LLVM;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.spi.LIRKindTool;
import org.graalvm.compiler.core.llvm.LLVMGenerationResult;
import org.graalvm.compiler.core.llvm.LLVMGenerator;
import org.graalvm.compiler.core.llvm.LLVMIRBuilder;
import org.graalvm.compiler.core.llvm.LLVMUtils;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.util.GuardedAnnotationAccess;

public class SubstrateLLVMGenerator
extends LLVMGenerator
implements SubstrateLIRGenerator {
    private LLVM.LLVMValueRef[] registerStackSlots = new LLVM.LLVMValueRef[LLVMFeature.SPECIAL_REGISTER_COUNT];
    private final boolean isEntryPoint;
    private List<String> aliases;
    private final boolean canModifySpecialRegisters;
    private final boolean returnsCEnum;

    SubstrateLLVMGenerator(Providers providers, LLVMGenerationResult generationResult, ResolvedJavaMethod method, LLVM.LLVMContextRef context, int debugLevel) {
        super(providers, generationResult, method, new LLVMIRBuilder(SubstrateUtil.uniqueShortName((ResolvedJavaMethod)method), context), (LIRKindTool)new LLVMUtils.LLVMKindTool(context), debugLevel);
        ResolvedJavaType returnType;
        this.isEntryPoint = SubstrateLLVMGenerator.isEntryPoint(method);
        this.canModifySpecialRegisters = this.canModifySpecialRegisters(method);
        this.aliases = new ArrayList<String>();
        if (this.isEntryPoint) {
            CEntryPointData cEntryPointData;
            this.aliases.add(SubstrateUtil.mangleName((String)this.builder.getFunctionName()));
            Object entryPointData = ((HostedMethod)method).getWrapped().getEntryPointData();
            if (entryPointData instanceof CEntryPointData && (cEntryPointData = (CEntryPointData)entryPointData).getPublishAs() != CEntryPointOptions.Publish.NotPublished) {
                String entryPointSymbolName = cEntryPointData.getSymbolName();
                assert (!entryPointSymbolName.isEmpty());
                this.aliases.add(entryPointSymbolName);
            }
        }
        this.returnsCEnum = (returnType = method.getSignature().getReturnType(null).resolve(null)).isEnum() && GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)returnType, CEnum.class);
    }

    boolean isEntryPoint() {
        return this.isEntryPoint;
    }

    List<String> getAliases() {
        return this.aliases;
    }

    private static boolean isEntryPoint(ResolvedJavaMethod method) {
        return ((HostedMethod)method).isEntryPoint();
    }

    private boolean canModifySpecialRegisters(ResolvedJavaMethod method) {
        return method.getDeclaringClass().equals(this.getMetaAccess().lookupJavaType(CEntryPointSnippets.class)) || method.getDeclaringClass().equals(this.getMetaAccess().lookupJavaType(CEntryPointNativeFunctions.class)) || method.getDeclaringClass().equals(this.getMetaAccess().lookupJavaType(CEntryPointBuiltins.class));
    }

    public SubstrateRegisterConfig getRegisterConfig() {
        return (SubstrateRegisterConfig)super.getRegisterConfig();
    }

    public void allocateRegisterSlots() {
        if (!this.isEntryPoint) {
            return;
        }
        for (int i = 0; i < this.registerStackSlots.length; ++i) {
            this.registerStackSlots[i] = this.builder.buildArrayAlloca(1);
        }
    }

    public void emitVerificationMarker(Object marker) {
    }

    protected LLVM.LLVMValueRef convertEnumReturnValue(LLVM.LLVMValueRef longValue) {
        if (this.returnsCEnum) {
            return this.builder.buildTrunc(longValue, JavaKind.Int.getBitCount());
        }
        return super.convertEnumReturnValue(longValue);
    }

    public void emitFarReturn(AllocatableValue result, Value sp, Value setjmpBuffer) {
        throw VMError.unimplemented();
    }

    public void emitDeadEnd() {
        this.emitPrintf("Dead end");
        this.builder.buildUnreachable();
    }

    protected ResolvedJavaMethod findForeignCallTarget(ForeignCallDescriptor descriptor) {
        return ((SnippetRuntime.SubstrateForeignCallDescriptor)descriptor).findMethod(this.getMetaAccess());
    }

    public String getFunctionName(ResolvedJavaMethod method) {
        return SubstrateUtil.uniqueShortName((ResolvedJavaMethod)method);
    }

    protected JavaKind getTypeKind(ResolvedJavaType type, boolean forMainFunction) {
        if (forMainFunction && this.isEntryPoint && type.isEnum() && GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)type, CEnum.class)) {
            return JavaKind.Int;
        }
        return ((HostedType)type).getStorageKind();
    }

    protected LLVM.LLVMTypeRef[] getLLVMFunctionArgTypes(ResolvedJavaMethod method, boolean forMainFunction) {
        LLVM.LLVMTypeRef[] parameterTypes;
        LLVM.LLVMTypeRef[] newParameterTypes = parameterTypes = super.getLLVMFunctionArgTypes(method, forMainFunction);
        if (!SubstrateLLVMGenerator.isEntryPoint(method) && this.registerStackSlots.length > 0) {
            newParameterTypes = new LLVM.LLVMTypeRef[this.registerStackSlots.length + parameterTypes.length];
            for (int i = 0; i < this.registerStackSlots.length; ++i) {
                newParameterTypes[i] = this.canModifySpecialRegisters(method) ? this.builder.rawPointerType() : this.builder.longType();
            }
            System.arraycopy(parameterTypes, 0, newParameterTypes, LLVMFeature.SPECIAL_REGISTER_COUNT, parameterTypes.length);
        }
        return newParameterTypes;
    }

    public Variable emitReadRegister(Register register, ValueKind<?> kind) {
        LLVM.LLVMValueRef value;
        if (register.equals((Object)this.getRegisterConfig().getThreadRegister())) {
            value = this.getSpecialRegister(LLVMFeature.THREAD_POINTER_INDEX);
        } else if (register.equals((Object)this.getRegisterConfig().getHeapBaseRegister())) {
            value = this.getSpecialRegister(LLVMFeature.HEAP_BASE_INDEX);
        } else if (register.equals((Object)this.getRegisterConfig().getFrameRegister())) {
            value = this.builder.buildReadRegister(this.builder.register(this.getRegisterConfig().getFrameRegister().name));
        } else {
            throw VMError.shouldNotReachHere();
        }
        return new LLVMUtils.LLVMVariable(value);
    }

    public void emitWriteRegister(Register dst, Value src, ValueKind<?> kind) {
        if (dst.equals((Object)this.getRegisterConfig().getThreadRegister())) {
            assert (this.isEntryPoint || this.canModifySpecialRegisters);
            this.builder.buildStore(LLVMUtils.getVal((Value)src), this.getSpecialRegisterPointer(LLVMFeature.THREAD_POINTER_INDEX));
            return;
        }
        if (dst.equals((Object)this.getRegisterConfig().getHeapBaseRegister())) {
            assert (this.isEntryPoint || this.canModifySpecialRegisters);
            this.builder.buildStore(LLVMUtils.getVal((Value)src), this.getSpecialRegisterPointer(LLVMFeature.HEAP_BASE_INDEX));
            return;
        }
        throw VMError.shouldNotReachHere();
    }

    private LLVM.LLVMValueRef getSpecialRegisterPointer(int index) {
        if (this.isEntryPoint) {
            return this.registerStackSlots[index];
        }
        if (this.canModifySpecialRegisters) {
            return this.builder.getParam(index);
        }
        throw VMError.shouldNotReachHere();
    }

    LLVM.LLVMValueRef getSpecialRegister(int index) {
        LLVM.LLVMValueRef specialRegister;
        if (this.isEntryPoint || this.canModifySpecialRegisters) {
            LLVM.LLVMValueRef specialRegisterPointer = this.getSpecialRegisterPointer(index);
            specialRegister = this.builder.buildLoad(specialRegisterPointer, this.builder.longType());
        } else {
            specialRegister = this.builder.getParam(index);
        }
        return specialRegister;
    }

    private LLVM.LLVMValueRef getSpecialRegisterArgument(int index, ResolvedJavaMethod targetMethod) {
        LLVM.LLVMValueRef specialRegisterArg;
        if (targetMethod != null && this.canModifySpecialRegisters(targetMethod)) {
            assert (this.isEntryPoint || this.canModifySpecialRegisters);
            specialRegisterArg = this.builder.buildBitcast(this.getSpecialRegisterPointer(index), this.builder.rawPointerType());
        } else {
            specialRegisterArg = this.isEntryPoint || this.canModifySpecialRegisters ? this.builder.buildLoad(this.getSpecialRegisterPointer(index), this.builder.longType()) : this.getSpecialRegister(index);
        }
        return specialRegisterArg;
    }

    public LLVM.LLVMValueRef[] getCallArguments(LLVM.LLVMValueRef[] args, CallingConvention.Type callType, ResolvedJavaMethod targetMethod) {
        LLVM.LLVMValueRef[] newArgs = args;
        if (!((SubstrateCallingConventionType)callType).nativeABI && this.registerStackSlots.length > 0) {
            newArgs = new LLVM.LLVMValueRef[this.registerStackSlots.length + args.length];
            for (int i = 0; i < this.registerStackSlots.length; ++i) {
                newArgs[i] = this.getSpecialRegisterArgument(i, targetMethod);
            }
            System.arraycopy(args, 0, newArgs, LLVMFeature.SPECIAL_REGISTER_COUNT, args.length);
        }
        return newArgs;
    }

    public LLVM.LLVMTypeRef[] getUnknownCallArgumentTypes(LLVM.LLVMTypeRef[] types, CallingConvention.Type callType) {
        LLVM.LLVMTypeRef[] newTypes = types;
        if (!((SubstrateCallingConventionType)callType).nativeABI && this.registerStackSlots.length > 0) {
            newTypes = new LLVM.LLVMTypeRef[this.registerStackSlots.length + types.length];
            for (int i = 0; i < this.registerStackSlots.length; ++i) {
                newTypes[i] = this.builder.longType();
            }
            System.arraycopy(types, 0, newTypes, LLVMFeature.SPECIAL_REGISTER_COUNT, types.length);
        }
        return newTypes;
    }

    protected CallingConvention.Type getCallingConventionType(CallingConvention callingConvention) {
        return ((SubstrateCallingConvention)callingConvention).getType();
    }

    public LLVM.LLVMValueRef getRetrieveExceptionFunction() {
        return this.getFunction((ResolvedJavaMethod)LLVMFeature.retrieveExceptionMethod);
    }
}

