/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.trufflenode;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Layout;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSBuiltinObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.trufflenode.ContextData;
import com.oracle.truffle.trufflenode.GraalJSAccess;

public final class JSExternalObject
extends JSBuiltinObject {
    public static final String CLASS_NAME = "external";
    public static final JSExternalObject INSTANCE = new JSExternalObject();
    private static final HiddenKey POINTER_KEY = new HiddenKey("pointer");
    private static final Property POINTER_PROPERTY;

    private JSExternalObject() {
    }

    public static DynamicObject create(JSContext context, long pointer) {
        ContextData contextData = GraalJSAccess.getContextEmbedderData(context);
        DynamicObject obj = contextData.getExternalObjectShape().newInstance();
        JSExternalObject.setPointer(obj, pointer);
        return obj;
    }

    public static Shape makeInitialShape(JSContext ctx) {
        Shape initialShape = ctx.getEmptyShapeNullPrototype().changeType((ObjectType)INSTANCE);
        initialShape = initialShape.addProperty(POINTER_PROPERTY);
        return initialShape;
    }

    public static boolean isJSExternalObject(Object obj) {
        return JSObject.isDynamicObject((Object)obj) && JSExternalObject.isJSExternalObject((DynamicObject)obj);
    }

    public static boolean isJSExternalObject(DynamicObject obj) {
        return JSExternalObject.isInstance((DynamicObject)obj, (JSClass)INSTANCE);
    }

    public String getClassName(DynamicObject object) {
        return CLASS_NAME;
    }

    public static void setPointer(DynamicObject obj, long pointer) {
        assert (JSExternalObject.isJSExternalObject(obj));
        POINTER_PROPERTY.setSafe(obj, (Object)pointer, null);
    }

    public static long getPointer(DynamicObject obj) {
        assert (JSExternalObject.isJSExternalObject(obj));
        return (Long)POINTER_PROPERTY.get(obj, JSExternalObject.isJSExternalObject(obj));
    }

    static {
        Shape.Allocator allocator = JSShape.makeAllocator((Layout)JSObject.LAYOUT);
        POINTER_PROPERTY = JSObjectUtil.makeHiddenProperty((HiddenKey)POINTER_KEY, (Location)allocator.locationForType(Long.TYPE));
    }
}

