/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.trufflenode.info;

import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.trufflenode.info.Script;
import java.nio.ByteBuffer;

public final class UnboundScript {
    private static final boolean IS_WINDOWS = System.getProperty("os.name").contains("Windows");
    private static int lastId;
    private final int id;
    private final Source source;
    private final Object parseResult;

    private UnboundScript(Source source, Object parseResult, int id) {
        this.source = source;
        this.parseResult = parseResult;
        this.id = id;
        assert (parseResult instanceof FunctionNode || parseResult instanceof ByteBuffer);
    }

    public UnboundScript(Source source, Object parseResult) {
        this(source, parseResult, ++lastId);
    }

    public UnboundScript(Script script) {
        this(script.getScriptNode().getRootNode().getSourceSection().getSource(), script.getParseResult(), script.getId());
    }

    public static Source createSource(String code, String fileName) {
        Source source;
        String name = UnboundScript.sourcefileName(fileName);
        if (UnboundScript.isCoreModule(name)) {
            source = Source.newBuilder((String)"js", (CharSequence)code, (String)name).build();
        } else {
            TruffleFile truffleFile = JavaScriptLanguage.getCurrentEnv().getPublicTruffleFile(name);
            source = Source.newBuilder((String)"js", (TruffleFile)truffleFile).content((CharSequence)code).name(name).build();
        }
        return source;
    }

    public static boolean isCoreModule(String name) {
        if (IS_WINDOWS) {
            return !name.contains(":");
        }
        return !name.startsWith("/");
    }

    private static String sourcefileName(String fileName) {
        return fileName == null ? "unknown source" : fileName;
    }

    public int getId() {
        return this.id;
    }

    public Source getSource() {
        return this.source;
    }

    public Object getParseResult() {
        return this.parseResult;
    }
}

