/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.processor;

import java.io.PrintWriter;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import org.graalvm.compiler.processor.AbstractProcessor;
import org.graalvm.compiler.replacements.processor.InjectedDependencies;

public abstract class GeneratedPlugin {
    protected final ExecutableElement intrinsicMethod;
    private boolean needInjectionProvider;
    private String pluginName;

    public GeneratedPlugin(ExecutableElement intrinsicMethod) {
        this.intrinsicMethod = intrinsicMethod;
        this.needInjectionProvider = false;
        this.pluginName = "Plugin_" + intrinsicMethod.getEnclosingElement().getSimpleName() + "_" + intrinsicMethod.getSimpleName().toString();
    }

    protected abstract TypeElement getAnnotationClass(AbstractProcessor var1);

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public void generate(AbstractProcessor processor, PrintWriter out) {
        out.printf("//        class: %s\n", this.intrinsicMethod.getEnclosingElement());
        out.printf("//       method: %s\n", this.intrinsicMethod);
        out.printf("// generated-by: %s\n", this.getClass().getName());
        out.printf("final class %s extends GeneratedInvocationPlugin {\n", this.pluginName);
        out.printf("\n", new Object[0]);
        out.printf("    @Override\n", new Object[0]);
        out.printf("    public boolean execute(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode[] args) {\n", new Object[0]);
        out.printf("        if (!b.isPluginEnabled(this)) {\n", new Object[0]);
        out.printf("            return false;\n", new Object[0]);
        out.printf("        }\n", new Object[0]);
        InjectedDependencies deps = this.createExecute(processor, out);
        out.printf("    }\n", new Object[0]);
        out.printf("    @Override\n", new Object[0]);
        out.printf("    public Class<? extends Annotation> getSource() {\n", new Object[0]);
        out.printf("        return %s.class;\n", this.getAnnotationClass(processor).getQualifiedName().toString().replace('$', '.'));
        out.printf("    }\n", new Object[0]);
        this.createPrivateMembers(processor, out, deps);
        out.printf("}\n", new Object[0]);
    }

    public void register(PrintWriter out) {
        out.printf("        plugins.register(new %s(", this.pluginName);
        if (this.needInjectionProvider) {
            out.printf("injection", new Object[0]);
        }
        out.printf("), %s.class, \"%s\"", this.intrinsicMethod.getEnclosingElement(), this.intrinsicMethod.getSimpleName());
        if (!this.intrinsicMethod.getModifiers().contains((Object)Modifier.STATIC)) {
            out.printf(", InvocationPlugin.Receiver.class", new Object[0]);
        }
        for (VariableElement variableElement : this.intrinsicMethod.getParameters()) {
            out.printf(", %s.class", GeneratedPlugin.getErasedType(variableElement.asType()));
        }
        out.printf(");\n", new Object[0]);
    }

    public abstract void extraImports(Set<String> var1);

    protected abstract InjectedDependencies createExecute(AbstractProcessor var1, PrintWriter var2);

    static String getErasedType(TypeMirror type) {
        switch (type.getKind()) {
            case DECLARED: {
                DeclaredType declared = (DeclaredType)type;
                TypeElement element = (TypeElement)declared.asElement();
                return element.getQualifiedName().toString();
            }
            case TYPEVAR: {
                return GeneratedPlugin.getErasedType(((TypeVariable)type).getUpperBound());
            }
            case WILDCARD: {
                return GeneratedPlugin.getErasedType(((WildcardType)type).getExtendsBound());
            }
            case ARRAY: {
                return GeneratedPlugin.getErasedType(((ArrayType)type).getComponentType()) + "[]";
            }
        }
        return type.toString();
    }

    static boolean hasRawtypeWarning(TypeMirror type) {
        switch (type.getKind()) {
            case DECLARED: {
                DeclaredType declared = (DeclaredType)type;
                return declared.getTypeArguments().size() > 0;
            }
            case TYPEVAR: {
                return false;
            }
            case WILDCARD: {
                return false;
            }
            case ARRAY: {
                return GeneratedPlugin.hasRawtypeWarning(((ArrayType)type).getComponentType());
            }
        }
        return false;
    }

    static boolean hasUncheckedWarning(TypeMirror type) {
        switch (type.getKind()) {
            case DECLARED: {
                DeclaredType declared = (DeclaredType)type;
                for (TypeMirror typeMirror : declared.getTypeArguments()) {
                    if (!GeneratedPlugin.hasUncheckedWarning(typeMirror)) continue;
                    return true;
                }
                return false;
            }
            case TYPEVAR: {
                return true;
            }
            case WILDCARD: {
                return ((WildcardType)type).getExtendsBound() != null;
            }
            case ARRAY: {
                return GeneratedPlugin.hasUncheckedWarning(((ArrayType)type).getComponentType());
            }
        }
        return false;
    }

    private void createPrivateMembers(AbstractProcessor processor, PrintWriter out, InjectedDependencies deps) {
        if (!deps.isEmpty()) {
            out.printf("\n", new Object[0]);
            for (InjectedDependencies.Dependency dep : deps) {
                out.printf("    private final %s %s;\n", dep.type, dep.name);
            }
            out.printf("\n", new Object[0]);
            out.printf("    %s(NodeIntrinsicPluginFactory.InjectionProvider injection) {\n", this.pluginName);
            for (InjectedDependencies.Dependency dep : deps) {
                out.printf("        this.%s = %s;\n", dep.name, dep.inject(processor, this.intrinsicMethod));
            }
            out.printf("    }\n", new Object[0]);
            this.needInjectionProvider = true;
        }
    }

    protected static String getReturnKind(ExecutableElement method) {
        switch (method.getReturnType().getKind()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: {
                return "Int";
            }
            case LONG: {
                return "Long";
            }
            case FLOAT: {
                return "Float";
            }
            case DOUBLE: {
                return "Double";
            }
            case VOID: {
                return "Void";
            }
            case DECLARED: 
            case TYPEVAR: 
            case ARRAY: {
                return "Object";
            }
        }
        throw new IllegalArgumentException(method.getReturnType().toString());
    }

    protected static void constantArgument(AbstractProcessor processor, PrintWriter out, InjectedDependencies deps, int argIdx, TypeMirror type, int nodeIdx) {
        if (GeneratedPlugin.hasRawtypeWarning(type)) {
            out.printf("        @SuppressWarnings({\"rawtypes\"})\n", new Object[0]);
        }
        out.printf("        %s arg%d;\n", GeneratedPlugin.getErasedType(type), argIdx);
        out.printf("        if (args[%d].isConstant()) {\n", nodeIdx);
        if (type.equals(processor.getType("jdk.vm.ci.meta.ResolvedJavaType"))) {
            out.printf("            jdk.vm.ci.meta.JavaConstant cst = args[%d].asJavaConstant();\n", nodeIdx);
            out.printf("            arg%d = %s.asJavaType(cst);\n", argIdx, deps.use(InjectedDependencies.WellKnownDependency.CONSTANT_REFLECTION));
            out.printf("            if (arg%d == null) {\n", argIdx);
            out.printf("                arg%d = %s.asObject(jdk.vm.ci.meta.ResolvedJavaType.class, cst);\n", argIdx, deps.use(InjectedDependencies.WellKnownDependency.SNIPPET_REFLECTION));
            out.printf("            }\n", new Object[0]);
        } else {
            switch (type.getKind()) {
                case BOOLEAN: {
                    out.printf("            arg%d = args[%d].asJavaConstant().asInt() != 0;\n", argIdx, nodeIdx);
                    break;
                }
                case BYTE: {
                    out.printf("            arg%d = (byte) args[%d].asJavaConstant().asInt();\n", argIdx, nodeIdx);
                    break;
                }
                case CHAR: {
                    out.printf("            arg%d = (char) args[%d].asJavaConstant().asInt();\n", argIdx, nodeIdx);
                    break;
                }
                case SHORT: {
                    out.printf("            arg%d = (short) args[%d].asJavaConstant().asInt();\n", argIdx, nodeIdx);
                    break;
                }
                case INT: {
                    out.printf("            arg%d = args[%d].asJavaConstant().asInt();\n", argIdx, nodeIdx);
                    break;
                }
                case LONG: {
                    out.printf("            arg%d = args[%d].asJavaConstant().asLong();\n", argIdx, nodeIdx);
                    break;
                }
                case FLOAT: {
                    out.printf("            arg%d = args[%d].asJavaConstant().asFloat();\n", argIdx, nodeIdx);
                    break;
                }
                case DOUBLE: {
                    out.printf("            arg%d = args[%d].asJavaConstant().asDouble();\n", argIdx, nodeIdx);
                    break;
                }
                case DECLARED: 
                case ARRAY: {
                    out.printf("            arg%d = %s.asObject(%s.class, args[%d].asJavaConstant());\n", argIdx, deps.use(InjectedDependencies.WellKnownDependency.SNIPPET_REFLECTION), GeneratedPlugin.getErasedType(type), nodeIdx);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(type.toString());
                }
            }
        }
        out.printf("        } else {\n", new Object[0]);
        out.printf("            assert b.canDeferPlugin(this) : b.getClass().toString();\n", new Object[0]);
        out.printf("            return false;\n", new Object[0]);
        out.printf("        }\n", new Object[0]);
    }
}

