/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.processor;

import java.util.HashMap;
import java.util.Iterator;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.graalvm.compiler.processor.AbstractProcessor;
import org.graalvm.compiler.replacements.processor.GeneratedPlugin;

public class InjectedDependencies
implements Iterable<Dependency> {
    private final HashMap<String, Dependency> deps = new HashMap();

    public String use(WellKnownDependency wellKnown) {
        if (wellKnown.generateMember != null) {
            this.deps.put(wellKnown.type, wellKnown.generateMember);
        }
        return wellKnown.expr;
    }

    public String use(AbstractProcessor processor, DeclaredType type) {
        for (WellKnownDependency wellKnown : WellKnownDependency.values()) {
            if (!processor.env().getTypeUtils().isAssignable(wellKnown.getType(processor), type)) continue;
            return this.use(wellKnown);
        }
        String typeName = type.toString();
        Dependency ret = this.deps.get(typeName);
        if (ret == null) {
            ret = new InjectedDependency("injected" + type.asElement().getSimpleName(), typeName);
            this.deps.put(typeName, ret);
        }
        return ret.name;
    }

    @Override
    public Iterator<Dependency> iterator() {
        return this.deps.values().iterator();
    }

    public boolean isEmpty() {
        return this.deps.isEmpty();
    }

    public static enum WellKnownDependency {
        CONSTANT_REFLECTION("b.getConstantReflection()", "jdk.vm.ci.meta.ConstantReflectionProvider"),
        META_ACCESS("b.getMetaAccess()", "jdk.vm.ci.meta.MetaAccessProvider"),
        ASSUMPTIONS("b.getAssumptions()", "jdk.vm.ci.meta.Assumptions"),
        OPTIONVALUES("b.getOptions()", "org.graalvm.compiler.options.OptionValues"),
        INJECTED_STAMP(new InjectedStampDependency()),
        SNIPPET_REFLECTION(new InjectedDependency("snippetReflection", "org.graalvm.compiler.api.replacements.SnippetReflectionProvider")),
        STAMP_PROVIDER("b.getStampProvider()", "org.graalvm.compiler.nodes.spi.StampProvider"),
        INTRINSIC_CONTEXT("b.getIntrinsic()", "org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext"),
        STRUCTURED_GRAPH("b.getGraph()", "org.graalvm.compiler.nodes.StructuredGraph");

        private final String expr;
        private final String type;
        private final Dependency generateMember;

        private WellKnownDependency(String expr, String type) {
            this.expr = expr;
            this.type = type;
            this.generateMember = null;
        }

        private WellKnownDependency(Dependency generateMember) {
            this.expr = generateMember.name;
            this.type = generateMember.type;
            this.generateMember = generateMember;
        }

        private TypeMirror getType(AbstractProcessor processor) {
            return processor.getType(this.type);
        }
    }

    private static final class InjectedStampDependency
    extends Dependency {
        private InjectedStampDependency() {
            super("stamp", "org.graalvm.compiler.core.common.type.Stamp");
        }

        @Override
        public String inject(AbstractProcessor processor, ExecutableElement inject) {
            AnnotationMirror nodeIntrinsic = processor.getAnnotation((Element)inject, processor.getType("org.graalvm.compiler.graph.Node.NodeIntrinsic"));
            boolean nonNull = nodeIntrinsic != null && (Boolean)AbstractProcessor.getAnnotationValue((AnnotationMirror)nodeIntrinsic, (String)"injectedStampIsNonNull", Boolean.class) != false;
            return String.format("injection.getInjectedStamp(%s.class, %s)", GeneratedPlugin.getErasedType(inject.getReturnType()), nonNull);
        }
    }

    private static final class InjectedDependency
    extends Dependency {
        private InjectedDependency(String name, String type) {
            super(name, type);
        }

        @Override
        public String inject(AbstractProcessor processor, ExecutableElement inject) {
            return String.format("injection.getInjectedArgument(%s.class)", this.type);
        }
    }

    public static abstract class Dependency {
        public final String name;
        public final String type;

        private Dependency(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public abstract String inject(AbstractProcessor var1, ExecutableElement var2);
    }
}

