/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.application.views.monitor;

import java.util.Set;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.application.jvm.JvmFactory;
import org.graalvm.visualvm.application.snapshot.ApplicationSnapshot;
import org.graalvm.visualvm.application.views.monitor.ApplicationMonitorModel;
import org.graalvm.visualvm.application.views.monitor.ApplicationMonitorView;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.snapshot.Snapshot;
import org.graalvm.visualvm.core.ui.DataSourceView;
import org.graalvm.visualvm.core.ui.PluggableDataSourceViewProvider;

public class ApplicationMonitorViewProvider
extends PluggableDataSourceViewProvider<Application> {
    protected boolean supportsViewFor(Application application) {
        if (application.getState() != 1) {
            return false;
        }
        Jvm jvm = JvmFactory.getJVMFor((Application)application);
        return jvm.isMonitoringSupported();
    }

    protected DataSourceView createView(Application application) {
        return new ApplicationMonitorView(ApplicationMonitorModel.create(application, true));
    }

    public Set<Integer> getPluggableLocations(DataSourceView view) {
        return ALL_LOCATIONS;
    }

    protected boolean supportsSaveViewFor(Application application, Class<? extends Snapshot> snapshotClass) {
        return ApplicationSnapshot.class.isAssignableFrom(snapshotClass);
    }

    protected void saveView(Application application, Snapshot snapshot) {
        ApplicationMonitorView view = (ApplicationMonitorView)this.getCachedView((DataSource)application);
        if (view != null) {
            view.getModel().save(snapshot);
        } else {
            ApplicationMonitorModel.create(application, false).save(snapshot);
        }
    }
}

