/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.application.views.threads;

import java.lang.management.ThreadMXBean;
import java.util.Set;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.snapshot.ApplicationSnapshot;
import org.graalvm.visualvm.application.views.threads.ApplicationThreadsView;
import org.graalvm.visualvm.application.views.threads.PersistenceSupport;
import org.graalvm.visualvm.application.views.threads.ThreadMXBeanDataManager;
import org.graalvm.visualvm.application.views.threads.VisualVMThreadsDataManager;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.snapshot.Snapshot;
import org.graalvm.visualvm.core.ui.DataSourceView;
import org.graalvm.visualvm.core.ui.PluggableDataSourceViewProvider;
import org.graalvm.visualvm.tools.jmx.JmxModel;
import org.graalvm.visualvm.tools.jmx.JmxModelFactory;
import org.graalvm.visualvm.tools.jmx.JvmMXBeans;
import org.graalvm.visualvm.tools.jmx.JvmMXBeansFactory;

public class ApplicationThreadsViewProvider
extends PluggableDataSourceViewProvider<Application> {
    protected boolean supportsViewFor(Application application) {
        if (application.getState() != 1) {
            return false;
        }
        return ApplicationThreadsViewProvider.resolveThreads(application) != null;
    }

    protected DataSourceView createView(Application application) {
        return new ApplicationThreadsView((DataSource)application);
    }

    public Set<Integer> getPluggableLocations(DataSourceView view) {
        return ALL_LOCATIONS;
    }

    protected boolean supportsSaveViewFor(Application application, Class<? extends Snapshot> snapshotClass) {
        return ApplicationSnapshot.class.isAssignableFrom(snapshotClass);
    }

    protected void saveView(Application application, Snapshot snapshot) {
        VisualVMThreadsDataManager tmanager = null;
        ApplicationThreadsView view = (ApplicationThreadsView)this.getCachedView((DataSource)application);
        if (view != null) {
            tmanager = view.getDataManager();
        } else {
            ThreadMXBean tbean = ApplicationThreadsViewProvider.resolveThreads(application);
            if (tbean != null) {
                tmanager = new ThreadMXBeanDataManager(tbean);
                ((ThreadMXBeanDataManager)tmanager).refreshThreadsSync();
            }
        }
        if (tmanager != null) {
            PersistenceSupport.saveDataManager(tmanager, snapshot.getStorage());
        }
    }

    static ThreadMXBean resolveThreads(Application application) {
        JmxModel jmxModel = JmxModelFactory.getJmxModelFor((Application)application);
        if (jmxModel != null && jmxModel.getConnectionState() == JmxModel.ConnectionState.CONNECTED && jmxModel.isTakeThreadDumpSupported()) {
            JvmMXBeans mxbeans = JvmMXBeansFactory.getJvmMXBeans((JmxModel)jmxModel);
            return mxbeans == null ? null : mxbeans.getThreadMXBean();
        }
        return null;
    }
}

