/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.nfi.NFISymbol;
import com.oracle.truffle.nfi.Parser;
import com.oracle.truffle.nfi.spi.NativeSymbolLibrary;
import com.oracle.truffle.nfi.spi.types.NativeSignature;

@GenerateUncached
abstract class BindSignatureNode
extends Node {
    BindSignatureNode() {
    }

    abstract Object execute(Object var1, Object var2) throws UnsupportedMessageException, UnsupportedTypeException;

    static String asString(InteropLibrary interop, Object signature) throws UnsupportedTypeException {
        try {
            return interop.asString(signature);
        }
        catch (UnsupportedMessageException ex) {
            CompilerDirectives.transferToInterpreter();
            throw UnsupportedTypeException.create((Object[])new Object[]{signature});
        }
    }

    static Object parseSignature(Object symbol, Object signature, InteropLibrary interop, NativeSymbolLibrary symbolLibrary) throws UnsupportedMessageException, UnsupportedTypeException {
        String sigString = BindSignatureNode.asString(interop, signature);
        NativeSignature parsed = BindSignatureNode.parseSignature(sigString);
        return symbolLibrary.prepareSignature(symbol, parsed);
    }

    @CompilerDirectives.TruffleBoundary
    static NativeSignature parseSignature(String signature) {
        return Parser.parseSignature(signature);
    }

    @Specialization(limit="5", guards={"signature == cachedSignature"})
    static Object doCachedSignature(Object symbol, Object signature, @Cached(value="signature") Object cachedSignature, @CachedLibrary(value="cachedSignature") InteropLibrary interop, @CachedLibrary(value="symbol") NativeSymbolLibrary symbolLibrary, @Cached(value="parseSignature(symbol, cachedSignature, interop, symbolLibrary)") Object parsedSignature) {
        return NFISymbol.createBound(symbol, parsedSignature);
    }

    @Specialization(limit="5", guards={"cachedSignature.equals(asString(interop, signature))"}, replaces={"doCachedSignature"})
    static Object doCachedSignatureString(Object symbol, Object signature, @CachedLibrary(value="signature") InteropLibrary interop, @Cached(value="asString(interop, signature)") String cachedSignature, @CachedLibrary(value="symbol") NativeSymbolLibrary symbolLibrary, @Cached(value="parseSignature(symbol, signature, interop, symbolLibrary)") Object parsedSignature) {
        return NFISymbol.createBound(symbol, parsedSignature);
    }

    @Specialization(limit="3", replaces={"doCachedSignature", "doCachedSignatureString"})
    static Object doGeneric(Object symbol, Object signature, @CachedLibrary(value="signature") InteropLibrary interop, @CachedLibrary(value="symbol") NativeSymbolLibrary symbolLibrary) throws UnsupportedMessageException, UnsupportedTypeException {
        return NFISymbol.createBound(symbol, BindSignatureNode.parseSignature(symbol, signature, interop, symbolLibrary));
    }
}

