/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.nfi.NFIContext;
import com.oracle.truffle.nfi.NFILibrary;
import com.oracle.truffle.nfi.NFIRootNode;
import com.oracle.truffle.nfi.NFISymbol;
import com.oracle.truffle.nfi.NativeSource;
import com.oracle.truffle.nfi.Parser;
import com.oracle.truffle.nfi.spi.NFIBackend;

@TruffleLanguage.Registration(id="nfi", name="TruffleNFI", version="0.1", characterMimeTypes={"application/x-native"}, internal=true)
public class NFILanguage
extends TruffleLanguage<NFIContext> {
    public static final String MIME_TYPE = "application/x-native";

    protected NFIContext createContext(TruffleLanguage.Env env) {
        return new NFIContext(env);
    }

    protected boolean patchContext(NFIContext context, TruffleLanguage.Env newEnv) {
        context.patch(newEnv);
        return true;
    }

    protected CallTarget parse(TruffleLanguage.ParsingRequest request) throws Exception {
        CharSequence nfiSource = request.getSource().getCharacters();
        NativeSource source = Parser.parseNFISource(nfiSource);
        String backendId = source.isDefaultBackend() ? "native" : source.getNFIBackendId();
        NFIBackend backend = ((NFIContext)NFILanguage.getCurrentContext(NFILanguage.class)).getBackend(backendId);
        CallTarget loadLibrary = backend.parse(source.getLibraryDescriptor());
        return Truffle.getRuntime().createCallTarget((RootNode)new NFIRootNode(this, loadLibrary, source));
    }

    protected boolean isObjectOfLanguage(Object object) {
        return object instanceof NFILibrary || object instanceof NFISymbol;
    }

    protected boolean isThreadAccessAllowed(Thread thread, boolean singleThreaded) {
        return true;
    }
}

