/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.nfi.NFIRootNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=NFIRootNode.class)
final class NFIRootNodeFactory {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    NFIRootNodeFactory() {
    }

    @GeneratedBy(value=NFIRootNode.LookupAndBindNode.class)
    static final class LookupAndBindNodeGen
    extends NFIRootNode.LookupAndBindNode {
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private InteropLibrary symInterop;
        @Node.Child
        private InteropLibrary lookupAndBind0_libInterop_;

        private LookupAndBindNodeGen(String name, String signature) {
            super(name, signature);
        }

        @Override
        Object execute(Object arg0Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0 && this.lookupAndBind0_libInterop_.accepts(arg0Value)) {
                    return this.doLookupAndBind(arg0Value, this.lookupAndBind0_libInterop_, this.symInterop);
                }
                if ((state & 2) != 0) {
                    return this.lookupAndBind1Boundary(state, arg0Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object lookupAndBind1Boundary(int state, Object arg0Value) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Object object = this.doLookupAndBind(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value), this.symInterop);
                return object;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object arg0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                Object object;
                if (exclude == 0) {
                    boolean LookupAndBind0_duplicateFound_ = false;
                    if ((state & 1) != 0 && this.lookupAndBind0_libInterop_.accepts(arg0Value)) {
                        LookupAndBind0_duplicateFound_ = true;
                    }
                    if (!LookupAndBind0_duplicateFound_ && (state & 1) == 0) {
                        this.lookupAndBind0_libInterop_ = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg0Value)));
                        if (this.symInterop == null) {
                            this.symInterop = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(1)));
                        }
                        this.state_ = state |= 1;
                        LookupAndBind0_duplicateFound_ = true;
                    }
                    if (LookupAndBind0_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        Object object2 = this.doLookupAndBind(arg0Value, this.lookupAndBind0_libInterop_, this.symInterop);
                        return object2;
                    }
                }
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    if (this.symInterop == null) {
                        this.symInterop = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(1)));
                    }
                    this.exclude_ = exclude |= 1;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    object = this.doLookupAndBind(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value), this.symInterop);
                }
                catch (Throwable throwable) {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                    throw throwable;
                }
                NodeUtil.popEncapsulatingNode((Node)prev_);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static NFIRootNode.LookupAndBindNode create(String name, String signature) {
            return new LookupAndBindNodeGen(name, signature);
        }
    }
}

