/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.nfi.impl.NativeArgumentBuffer;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=SerializeArgumentLibrary.class)
final class SerializeArgumentLibraryGen
extends LibraryFactory<SerializeArgumentLibrary> {
    private static final Class<SerializeArgumentLibrary> LIBRARY_CLASS = SerializeArgumentLibraryGen.lazyLibraryClass();
    private static final Message PUT_BYTE = new MessageImpl("putByte", 0, Void.TYPE, Object.class, NativeArgumentBuffer.class);
    private static final Message PUT_U_BYTE = new MessageImpl("putUByte", 1, Void.TYPE, Object.class, NativeArgumentBuffer.class);
    private static final Message PUT_SHORT = new MessageImpl("putShort", 2, Void.TYPE, Object.class, NativeArgumentBuffer.class);
    private static final Message PUT_U_SHORT = new MessageImpl("putUShort", 3, Void.TYPE, Object.class, NativeArgumentBuffer.class);
    private static final Message PUT_INT = new MessageImpl("putInt", 4, Void.TYPE, Object.class, NativeArgumentBuffer.class);
    private static final Message PUT_U_INT = new MessageImpl("putUInt", 5, Void.TYPE, Object.class, NativeArgumentBuffer.class);
    private static final Message PUT_LONG = new MessageImpl("putLong", 6, Void.TYPE, Object.class, NativeArgumentBuffer.class);
    private static final Message PUT_U_LONG = new MessageImpl("putULong", 7, Void.TYPE, Object.class, NativeArgumentBuffer.class);
    private static final Message PUT_FLOAT = new MessageImpl("putFloat", 8, Void.TYPE, Object.class, NativeArgumentBuffer.class);
    private static final Message PUT_DOUBLE = new MessageImpl("putDouble", 9, Void.TYPE, Object.class, NativeArgumentBuffer.class);
    private static final Message PUT_POINTER = new MessageImpl("putPointer", 10, Void.TYPE, Object.class, NativeArgumentBuffer.class, Integer.TYPE);
    private static final Message PUT_STRING = new MessageImpl("putString", 11, Void.TYPE, Object.class, NativeArgumentBuffer.class, Integer.TYPE);
    private static final SerializeArgumentLibraryGen INSTANCE = new SerializeArgumentLibraryGen();

    private SerializeArgumentLibraryGen() {
        super(LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(PUT_BYTE, PUT_U_BYTE, PUT_SHORT, PUT_U_SHORT, PUT_INT, PUT_U_INT, PUT_LONG, PUT_U_LONG, PUT_FLOAT, PUT_DOUBLE, PUT_POINTER, PUT_STRING)));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        if (receiver instanceof Character) {
            return SerializeArgumentLibrary.CharConversion.class;
        }
        if (receiver instanceof boolean[]) {
            return SerializeArgumentLibrary.BooleanArrayConversion.class;
        }
        if (receiver instanceof byte[]) {
            return SerializeArgumentLibrary.ByteArrayConversion.class;
        }
        if (receiver instanceof short[]) {
            return SerializeArgumentLibrary.ShortArrayConversion.class;
        }
        if (receiver instanceof char[]) {
            return SerializeArgumentLibrary.CharArrayConversion.class;
        }
        if (receiver instanceof int[]) {
            return SerializeArgumentLibrary.IntArrayConversion.class;
        }
        if (receiver instanceof long[]) {
            return SerializeArgumentLibrary.LongArrayConversion.class;
        }
        if (receiver instanceof float[]) {
            return SerializeArgumentLibrary.FloatArrayConversion.class;
        }
        if (receiver instanceof double[]) {
            return SerializeArgumentLibrary.DoubleArrayConversion.class;
        }
        return SerializeArgumentLibrary.DefaultConversion.class;
    }

    protected SerializeArgumentLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        SerializeArgumentLibrary lib = (SerializeArgumentLibrary)originalLib;
        MessageImpl messageImpl = (MessageImpl)message;
        if (messageImpl.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (messageImpl.index) {
            case 0: {
                lib.putByte(receiver, (NativeArgumentBuffer)args[offset]);
                return null;
            }
            case 1: {
                lib.putUByte(receiver, (NativeArgumentBuffer)args[offset]);
                return null;
            }
            case 2: {
                lib.putShort(receiver, (NativeArgumentBuffer)args[offset]);
                return null;
            }
            case 3: {
                lib.putUShort(receiver, (NativeArgumentBuffer)args[offset]);
                return null;
            }
            case 4: {
                lib.putInt(receiver, (NativeArgumentBuffer)args[offset]);
                return null;
            }
            case 5: {
                lib.putUInt(receiver, (NativeArgumentBuffer)args[offset]);
                return null;
            }
            case 6: {
                lib.putLong(receiver, (NativeArgumentBuffer)args[offset]);
                return null;
            }
            case 7: {
                lib.putULong(receiver, (NativeArgumentBuffer)args[offset]);
                return null;
            }
            case 8: {
                lib.putFloat(receiver, (NativeArgumentBuffer)args[offset]);
                return null;
            }
            case 9: {
                lib.putDouble(receiver, (NativeArgumentBuffer)args[offset]);
                return null;
            }
            case 10: {
                lib.putPointer(receiver, (NativeArgumentBuffer)args[offset], (Integer)args[offset + 1]);
                return null;
            }
            case 11: {
                lib.putString(receiver, (NativeArgumentBuffer)args[offset], (Integer)args[offset + 1]);
                return null;
            }
        }
        CompilerDirectives.transferToInterpreter();
        throw new AbstractMethodError(message.toString());
    }

    protected SerializeArgumentLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected SerializeArgumentLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<SerializeArgumentLibrary> lazyLibraryClass() {
        try {
            return Class.forName("com.oracle.truffle.nfi.impl.SerializeArgumentLibrary", false, SerializeArgumentLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=SerializeArgumentLibrary.class)
    private static abstract class CachedDispatch
    extends SerializeArgumentLibrary {
        @Node.Child
        SerializeArgumentLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(SerializeArgumentLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public void putByte(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            while (true) {
                CachedDispatch current = this;
                do {
                    SerializeArgumentLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.putByte(receiver_, buffer);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public void putUByte(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            while (true) {
                CachedDispatch current = this;
                do {
                    SerializeArgumentLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.putUByte(receiver_, buffer);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public void putShort(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            while (true) {
                CachedDispatch current = this;
                do {
                    SerializeArgumentLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.putShort(receiver_, buffer);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public void putUShort(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            while (true) {
                CachedDispatch current = this;
                do {
                    SerializeArgumentLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.putUShort(receiver_, buffer);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public void putInt(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            while (true) {
                CachedDispatch current = this;
                do {
                    SerializeArgumentLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.putInt(receiver_, buffer);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public void putUInt(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            while (true) {
                CachedDispatch current = this;
                do {
                    SerializeArgumentLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.putUInt(receiver_, buffer);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public void putLong(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            while (true) {
                CachedDispatch current = this;
                do {
                    SerializeArgumentLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.putLong(receiver_, buffer);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public void putULong(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            while (true) {
                CachedDispatch current = this;
                do {
                    SerializeArgumentLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.putULong(receiver_, buffer);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public void putFloat(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            while (true) {
                CachedDispatch current = this;
                do {
                    SerializeArgumentLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.putFloat(receiver_, buffer);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public void putDouble(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            while (true) {
                CachedDispatch current = this;
                do {
                    SerializeArgumentLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.putDouble(receiver_, buffer);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public void putPointer(Object receiver_, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
            while (true) {
                CachedDispatch current = this;
                do {
                    SerializeArgumentLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.putPointer(receiver_, buffer, ptrSize);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public void putString(Object receiver_, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
            while (true) {
                CachedDispatch current = this;
                do {
                    SerializeArgumentLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.putString(receiver_, buffer, ptrSize);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(Object receiver_) {
            CachedDispatch current = this;
            SerializeArgumentLibrary thisLibrary = current.library;
            if (thisLibrary == null) {
                this.library = (SerializeArgumentLibrary)this.insert((Node)((SerializeArgumentLibrary)INSTANCE.create(receiver_)));
            } else {
                Lock lock = this.getLock();
                lock.lock();
                try {
                    int count = 0;
                    do {
                        SerializeArgumentLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (SerializeArgumentLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((SerializeArgumentLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    @GeneratedBy(value=SerializeArgumentLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch {
        private final int limit_;

        CachedDispatchFirst(SerializeArgumentLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library == null) continue;
                ++count;
            } while ((current = current.next) != null);
            return NodeCost.fromCount((int)count);
        }
    }

    @GeneratedBy(value=SerializeArgumentLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(SerializeArgumentLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw new AssertionError();
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }

    @GeneratedBy(value=SerializeArgumentLibrary.class)
    private static final class UncachedDispatch
    extends SerializeArgumentLibrary {
        private UncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void putByte(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            ((SerializeArgumentLibrary)INSTANCE.getUncached(receiver_)).putByte(receiver_, buffer);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void putUByte(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            ((SerializeArgumentLibrary)INSTANCE.getUncached(receiver_)).putUByte(receiver_, buffer);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void putShort(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            ((SerializeArgumentLibrary)INSTANCE.getUncached(receiver_)).putShort(receiver_, buffer);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void putUShort(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            ((SerializeArgumentLibrary)INSTANCE.getUncached(receiver_)).putUShort(receiver_, buffer);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void putInt(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            ((SerializeArgumentLibrary)INSTANCE.getUncached(receiver_)).putInt(receiver_, buffer);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void putUInt(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            ((SerializeArgumentLibrary)INSTANCE.getUncached(receiver_)).putUInt(receiver_, buffer);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void putLong(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            ((SerializeArgumentLibrary)INSTANCE.getUncached(receiver_)).putLong(receiver_, buffer);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void putULong(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            ((SerializeArgumentLibrary)INSTANCE.getUncached(receiver_)).putULong(receiver_, buffer);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void putFloat(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            ((SerializeArgumentLibrary)INSTANCE.getUncached(receiver_)).putFloat(receiver_, buffer);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void putDouble(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            ((SerializeArgumentLibrary)INSTANCE.getUncached(receiver_)).putDouble(receiver_, buffer);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void putPointer(Object receiver_, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
            ((SerializeArgumentLibrary)INSTANCE.getUncached(receiver_)).putPointer(receiver_, buffer, ptrSize);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void putString(Object receiver_, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
            ((SerializeArgumentLibrary)INSTANCE.getUncached(receiver_)).putString(receiver_, buffer, ptrSize);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=SerializeArgumentLibrary.class)
    private static final class CachedToUncachedDispatch
    extends SerializeArgumentLibrary {
        private CachedToUncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void putByte(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                ((SerializeArgumentLibrary)INSTANCE.getUncached(receiver_)).putByte(receiver_, buffer);
                return;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void putUByte(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                ((SerializeArgumentLibrary)INSTANCE.getUncached(receiver_)).putUByte(receiver_, buffer);
                return;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void putShort(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                ((SerializeArgumentLibrary)INSTANCE.getUncached(receiver_)).putShort(receiver_, buffer);
                return;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void putUShort(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                ((SerializeArgumentLibrary)INSTANCE.getUncached(receiver_)).putUShort(receiver_, buffer);
                return;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void putInt(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                ((SerializeArgumentLibrary)INSTANCE.getUncached(receiver_)).putInt(receiver_, buffer);
                return;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void putUInt(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                ((SerializeArgumentLibrary)INSTANCE.getUncached(receiver_)).putUInt(receiver_, buffer);
                return;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void putLong(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                ((SerializeArgumentLibrary)INSTANCE.getUncached(receiver_)).putLong(receiver_, buffer);
                return;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void putULong(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                ((SerializeArgumentLibrary)INSTANCE.getUncached(receiver_)).putULong(receiver_, buffer);
                return;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void putFloat(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                ((SerializeArgumentLibrary)INSTANCE.getUncached(receiver_)).putFloat(receiver_, buffer);
                return;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void putDouble(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                ((SerializeArgumentLibrary)INSTANCE.getUncached(receiver_)).putDouble(receiver_, buffer);
                return;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void putPointer(Object receiver_, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                ((SerializeArgumentLibrary)INSTANCE.getUncached(receiver_)).putPointer(receiver_, buffer, ptrSize);
                return;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void putString(Object receiver_, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                ((SerializeArgumentLibrary)INSTANCE.getUncached(receiver_)).putString(receiver_, buffer, ptrSize);
                return;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }

    @GeneratedBy(value=SerializeArgumentLibrary.class)
    private static final class Proxy
    extends SerializeArgumentLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public void putByte(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            try {
                this.lib.send(receiver_, PUT_BYTE, new Object[]{buffer});
                return;
            }
            catch (UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        @Override
        public void putUByte(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            try {
                this.lib.send(receiver_, PUT_U_BYTE, new Object[]{buffer});
                return;
            }
            catch (UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        @Override
        public void putShort(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            try {
                this.lib.send(receiver_, PUT_SHORT, new Object[]{buffer});
                return;
            }
            catch (UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        @Override
        public void putUShort(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            try {
                this.lib.send(receiver_, PUT_U_SHORT, new Object[]{buffer});
                return;
            }
            catch (UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        @Override
        public void putInt(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            try {
                this.lib.send(receiver_, PUT_INT, new Object[]{buffer});
                return;
            }
            catch (UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        @Override
        public void putUInt(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            try {
                this.lib.send(receiver_, PUT_U_INT, new Object[]{buffer});
                return;
            }
            catch (UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        @Override
        public void putLong(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            try {
                this.lib.send(receiver_, PUT_LONG, new Object[]{buffer});
                return;
            }
            catch (UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        @Override
        public void putULong(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            try {
                this.lib.send(receiver_, PUT_U_LONG, new Object[]{buffer});
                return;
            }
            catch (UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        @Override
        public void putFloat(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            try {
                this.lib.send(receiver_, PUT_FLOAT, new Object[]{buffer});
                return;
            }
            catch (UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        @Override
        public void putDouble(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            try {
                this.lib.send(receiver_, PUT_DOUBLE, new Object[]{buffer});
                return;
            }
            catch (UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        @Override
        public void putPointer(Object receiver_, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
            try {
                this.lib.send(receiver_, PUT_POINTER, new Object[]{buffer, ptrSize});
                return;
            }
            catch (UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        @Override
        public void putString(Object receiver_, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
            try {
                this.lib.send(receiver_, PUT_STRING, new Object[]{buffer, ptrSize});
                return;
            }
            catch (UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=SerializeArgumentLibrary.class)
    private static class MessageImpl
    extends Message {
        final int index;

        MessageImpl(String name, int index, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, returnType, (Class[])parameters);
            this.index = index;
        }
    }
}

