/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.matchers;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.regex.tregex.matchers.InvertibleCharMatcher;
import com.oracle.truffle.regex.tregex.matchers.SingleCharMatcherNodeGen;
import com.oracle.truffle.regex.tregex.util.DebugUtil;

public abstract class SingleCharMatcher
extends InvertibleCharMatcher {
    private final char c;

    SingleCharMatcher(boolean invert, char c) {
        super(invert);
        this.c = c;
    }

    public static SingleCharMatcher create(boolean invert, char c) {
        return SingleCharMatcherNodeGen.create(invert, c);
    }

    public char getChar() {
        return this.c;
    }

    @Specialization
    public boolean match(char m, boolean compactString) {
        return this.result((!compactString || this.c < '\u0100') && this.c == m);
    }

    @Override
    public int estimatedCost() {
        return 1;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.modifiersToString() + DebugUtil.charToString(this.c);
    }
}

