/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.RegexFlags;
import com.oracle.truffle.regex.RegexOptions;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.charset.CharSet;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.Constants;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.buffer.IntRangesBuffer;
import com.oracle.truffle.regex.tregex.buffer.ObjectArrayBuffer;
import com.oracle.truffle.regex.tregex.parser.Counter;
import com.oracle.truffle.regex.tregex.parser.RegexLexer;
import com.oracle.truffle.regex.tregex.parser.RegexProperties;
import com.oracle.truffle.regex.tregex.parser.Token;
import com.oracle.truffle.regex.tregex.parser.ast.BackReference;
import com.oracle.truffle.regex.tregex.parser.ast.CharacterClass;
import com.oracle.truffle.regex.tregex.parser.ast.Group;
import com.oracle.truffle.regex.tregex.parser.ast.LookAheadAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.LookAroundAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.PositionAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTRootNode;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTSubtreeRootNode;
import com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import com.oracle.truffle.regex.tregex.parser.ast.Term;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.CalcMinPathsVisitor;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.CopyVisitor;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.DeleteVisitor;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.DepthFirstTraversalRegexASTVisitor;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.InitIDVisitor;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.MarkLookBehindEntriesVisitor;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.SetSourceSectionVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;

public final class RegexParser {
    private static final Group WORD_BOUNDARY_SUBSTITUTION;
    private static final Group NON_WORD_BOUNDARY_SUBSTITUTION;
    private static final Group UNICODE_IGNORE_CASE_WORD_BOUNDARY_SUBSTITUTION;
    private static final Group UNICODE_IGNORE_CASE_NON_WORD_BOUNDARY_SUBSTITUTION;
    private static final Group MULTI_LINE_CARET_SUBSTITUTION;
    private static final Group MULTI_LINE_DOLLAR_SUBSTITUTION;
    private static final Group NO_LEAD_SURROGATE_BEHIND;
    private static final Group NO_TRAIL_SURROGATE_AHEAD;
    private final RegexAST ast;
    private final RegexSource source;
    private final RegexFlags flags;
    private final RegexOptions options;
    private final RegexLexer lexer;
    private final RegexProperties properties;
    private final Counter.ThresholdCounter groupCount;
    private final CopyVisitor copyVisitor;
    private final DeleteVisitor deleteVisitor;
    private final SetSourceSectionVisitor setSourceSectionVisitor;
    private Sequence curSequence;
    private Group curGroup;
    private Term curTerm;
    private final CompilationBuffer compilationBuffer;

    @CompilerDirectives.TruffleBoundary
    public RegexParser(RegexSource source, RegexOptions options, CompilationBuffer compilationBuffer) throws RegexSyntaxException {
        this.source = source;
        this.flags = RegexFlags.parseFlags(source.getFlags());
        this.options = options;
        this.lexer = new RegexLexer(source, this.flags, options);
        this.ast = new RegexAST(source, this.flags, options);
        this.properties = this.ast.getProperties();
        this.groupCount = this.ast.getGroupCount();
        this.copyVisitor = new CopyVisitor(this.ast);
        this.deleteVisitor = new DeleteVisitor(this.ast);
        this.setSourceSectionVisitor = options.isDumpAutomata() ? new SetSourceSectionVisitor(this.ast) : null;
        this.compilationBuffer = compilationBuffer;
    }

    private static Group parseRootLess(String pattern) throws RegexSyntaxException {
        return new RegexParser(new RegexSource(pattern), RegexOptions.DEFAULT, new CompilationBuffer()).parse(false);
    }

    @CompilerDirectives.TruffleBoundary
    public RegexAST parse() throws RegexSyntaxException {
        this.ast.setRoot(this.parse(true));
        for (LookBehindAssertion lb : this.ast.getLookBehinds()) {
            if (lb.isLiteral()) continue;
            this.properties.setNonLiteralLookBehindAssertions();
            break;
        }
        return this.ast;
    }

    public void prepareForDFA() {
        if (this.properties.hasQuantifiers() && !this.properties.hasLargeCountedRepetitions()) {
            UnrollQuantifiersVisitor.unrollQuantifiers(this, this.ast.getRoot());
        }
        CalcMinPathsVisitor calcMinPathsVisitor = new CalcMinPathsVisitor();
        calcMinPathsVisitor.runReverse(this.ast.getRoot());
        calcMinPathsVisitor.run(this.ast.getRoot());
        this.ast.removeUnreachablePositionAssertions();
        if (!this.properties.hasNonLiteralLookBehindAssertions()) {
            this.ast.createPrefix();
            InitIDVisitor.init(this.ast);
            if (!this.properties.hasBackReferences() && !this.properties.hasLargeCountedRepetitions()) {
                new MarkLookBehindEntriesVisitor(this.ast).run();
            }
        }
        this.checkInnerLiteral();
    }

    private void checkInnerLiteral() {
        if (this.ast.isLiteralString() || this.ast.getRoot().startsWithCaret() || this.ast.getRoot().endsWithDollar() || this.ast.getRoot().size() != 1) {
            return;
        }
        ArrayList<Term> terms = this.ast.getRoot().getAlternatives().get(0).getTerms();
        int literalStart = -1;
        int literalEnd = -1;
        int maxPath = 0;
        for (int i = 0; i < terms.size(); ++i) {
            Term t = terms.get(i);
            if (t instanceof CharacterClass && (((CharacterClass)t).getCharSet().matchesSingleChar() || ((CharacterClass)t).getCharSet().matches2CharsWith1BitDifference())) {
                if (literalStart < 0) {
                    literalStart = i;
                }
                literalEnd = i + 1;
                continue;
            }
            if (literalStart >= 0 || t.hasLoops()) break;
            maxPath = t.getMaxPath();
            if (maxPath <= 4) continue;
            return;
        }
        if (literalStart >= 0 && (literalStart > 0 || literalEnd - literalStart > 1)) {
            this.properties.setInnerLiteral(literalStart, literalEnd);
        }
    }

    public RegexFlags getFlags() {
        return this.flags;
    }

    private void setComplexLookAround() {
        if (this.curGroup.isInLookAheadAssertion()) {
            this.properties.setComplexLookAheadAssertions();
        }
        if (this.curGroup.isInLookBehindAssertion()) {
            this.properties.setComplexLookBehindAssertions();
        }
    }

    private void createGroup(Token token) {
        this.createGroup(token, true, false, null);
    }

    private void createCaptureGroup(Token token) {
        this.createGroup(token, true, true, null);
    }

    private Group createGroup(Token token, boolean addToSeq, boolean capture, RegexASTSubtreeRootNode parent) {
        Group group;
        Group group2 = group = capture ? this.ast.createCaptureGroup(this.groupCount.inc()) : this.ast.createGroup();
        if (parent != null) {
            parent.setGroup(group);
        }
        if (addToSeq) {
            this.setComplexLookAround();
            this.addTerm(group);
        }
        this.ast.addSourceSection(group, token);
        this.curGroup = group;
        this.curGroup.setEnclosedCaptureGroupsLow(this.groupCount.getCount());
        this.addSequence(token);
        return group;
    }

    private void addSequence(Token token) {
        if (!this.curGroup.isEmpty()) {
            this.setComplexLookAround();
        }
        this.curSequence = this.curGroup.addSequence(this.ast);
        this.curTerm = null;
    }

    private void popGroup(Token token) throws RegexSyntaxException {
        this.curGroup.setEnclosedCaptureGroupsHigh(this.groupCount.getCount());
        this.ast.addSourceSection(this.curGroup, token);
        this.curTerm = this.curGroup;
        RegexASTNode parent = this.curGroup.getParent();
        if (parent instanceof RegexASTRootNode) {
            throw this.syntaxError("Unmatched ')'");
        }
        if (parent instanceof RegexASTSubtreeRootNode) {
            this.curSequence = (Sequence)parent.getParent();
            this.curTerm = (Term)parent;
        } else {
            this.curSequence = (Sequence)parent;
        }
        this.curGroup = this.curSequence.getParent();
    }

    private void addTerm(Term term) {
        this.curSequence.add(term);
        this.curTerm = term;
    }

    private void addLookBehindAssertion(Token token, boolean negate) {
        LookBehindAssertion lookBehind = this.ast.createLookBehindAssertion(negate);
        this.addTerm(lookBehind);
        this.createGroup(token, false, false, lookBehind);
    }

    private void addLookAheadAssertion(Token token, boolean negate) {
        LookAheadAssertion lookAhead = this.ast.createLookAheadAssertion(negate);
        this.addTerm(lookAhead);
        this.createGroup(token, false, false, lookAhead);
    }

    private Term translateUnicodeCharClass(Token.CharacterClass token) {
        CodePointSet codePointSet = token.getCodePointSet();
        if (Constants.BMP_WITHOUT_SURROGATES.contains(token.getCodePointSet())) {
            return this.createCharClass(codePointSet, (Token)token, token.wasSingleChar());
        }
        Group group = this.ast.createGroup();
        group.setEnclosedCaptureGroupsLow(this.groupCount.getCount());
        group.setEnclosedCaptureGroupsHigh(this.groupCount.getCount());
        IntRangesBuffer tmp = this.compilationBuffer.getIntRangesBuffer1();
        CodePointSet bmpRanges = codePointSet.createIntersection(Constants.BMP_WITHOUT_SURROGATES, tmp);
        CodePointSet astralRanges = codePointSet.createIntersection(Constants.ASTRAL_SYMBOLS, tmp);
        CodePointSet loneLeadSurrogateRanges = codePointSet.createIntersection(Constants.LEAD_SURROGATES, tmp);
        CodePointSet loneTrailSurrogateRanges = codePointSet.createIntersection(Constants.TRAIL_SURROGATES, tmp);
        assert (astralRanges.matchesSomething() || loneLeadSurrogateRanges.matchesSomething() || loneTrailSurrogateRanges.matchesSomething());
        if (bmpRanges.matchesSomething()) {
            Sequence bmpAlternative = group.addSequence(this.ast);
            bmpAlternative.add(this.createCharClass(bmpRanges, (Token)token));
        }
        if (loneLeadSurrogateRanges.matchesSomething()) {
            Sequence loneLeadSurrogateAlternative = group.addSequence(this.ast);
            loneLeadSurrogateAlternative.add(this.createCharClass(loneLeadSurrogateRanges, (Token)token));
            loneLeadSurrogateAlternative.add(NO_TRAIL_SURROGATE_AHEAD.copy(this.ast, true));
            this.properties.setAlternations();
        }
        if (loneTrailSurrogateRanges.matchesSomething()) {
            Sequence loneTrailSurrogateAlternative = group.addSequence(this.ast);
            loneTrailSurrogateAlternative.add(NO_LEAD_SURROGATE_BEHIND.copy(this.ast, true));
            loneTrailSurrogateAlternative.add(this.createCharClass(loneTrailSurrogateRanges, (Token)token));
            this.properties.setAlternations();
        }
        if (astralRanges.matchesSomething()) {
            IntRangesBuffer completeRanges = this.compilationBuffer.getIntRangesBuffer2();
            completeRanges.clear();
            char curLead = Character.highSurrogate(astralRanges.getLo(0));
            IntRangesBuffer curTrails = tmp;
            curTrails.clear();
            for (int i = 0; i < astralRanges.size(); ++i) {
                Sequence finishedAlternative;
                char startLead = Character.highSurrogate(astralRanges.getLo(i));
                char startTrail = Character.lowSurrogate(astralRanges.getLo(i));
                char endLead = Character.highSurrogate(astralRanges.getHi(i));
                char endTrail = Character.lowSurrogate(astralRanges.getHi(i));
                if (startLead > curLead) {
                    if (curTrails.matchesSomething()) {
                        finishedAlternative = group.addSequence(this.ast);
                        finishedAlternative.add(this.createCharClass(CharSet.create(curLead), (Token)token));
                        finishedAlternative.add(this.createCharClass(curTrails, (Token)token));
                    }
                    curLead = startLead;
                    curTrails.clear();
                }
                if (startLead == endLead) {
                    curTrails.addRange(startTrail, endTrail);
                    continue;
                }
                if (startTrail != Constants.TRAIL_SURROGATE_RANGE.getLo(0)) {
                    curTrails.addRange(startTrail, Constants.TRAIL_SURROGATE_RANGE.getHi(0));
                    assert (startLead < '\uffff');
                    startLead = (char)(startLead + '\u0001');
                }
                if (curTrails.matchesSomething()) {
                    finishedAlternative = group.addSequence(this.ast);
                    finishedAlternative.add(this.createCharClass(CharSet.create(curLead), (Token)token));
                    finishedAlternative.add(this.createCharClass(curTrails, (Token)token));
                }
                curLead = endLead;
                curTrails.clear();
                if (endTrail != Constants.TRAIL_SURROGATE_RANGE.getHi(0)) {
                    curTrails.addRange(Constants.TRAIL_SURROGATE_RANGE.getLo(0), endTrail);
                    assert (endLead > '\u0000');
                    endLead = (char)(endLead - '\u0001');
                }
                if (startLead > endLead) continue;
                completeRanges.addRange(startLead, endLead);
            }
            if (curTrails.matchesSomething()) {
                Sequence lastAlternative = group.addSequence(this.ast);
                lastAlternative.add(this.createCharClass(CharSet.create(curLead), (Token)token));
                lastAlternative.add(this.createCharClass(curTrails, (Token)token));
            }
            if (completeRanges.matchesSomething()) {
                Sequence completeRangesAlt = this.ast.createSequence();
                group.insertFirst(completeRangesAlt);
                completeRangesAlt.add(this.createCharClass(completeRanges, (Token)token));
                completeRangesAlt.add(this.createCharClass(CharSet.getTrailSurrogateRange(), (Token)token));
            }
        }
        if (group.size() > 1) {
            this.properties.setAlternations();
        }
        assert (group.size() != 1 || group.getAlternatives().get(0).getTerms().size() != 1);
        return group;
    }

    private void addCharClass(Token.CharacterClass token) {
        CodePointSet codePointSet = token.getCodePointSet();
        if (this.flags.isUnicode()) {
            if (codePointSet.matchesNothing()) {
                this.addTerm(this.createCharClass(CharSet.getEmpty(), (Token)token));
            } else {
                this.addTerm(this.translateUnicodeCharClass(token));
            }
        } else {
            this.addTerm(this.createCharClass(codePointSet, (Token)token, token.wasSingleChar()));
        }
    }

    private CharacterClass createCharClass(IntRangesBuffer buf, Token token) {
        return this.createCharClass(CharSet.fromSortedRanges(buf), token);
    }

    private CharacterClass createCharClass(CodePointSet codePointSet, Token token) {
        return this.createCharClass(CharSet.fromSortedRanges(codePointSet), token);
    }

    private CharacterClass createCharClass(CodePointSet codePointSet, Token token, boolean wasSingleChar) {
        return this.createCharClass(CharSet.fromSortedRanges(codePointSet), token, wasSingleChar);
    }

    private CharacterClass createCharClass(CharSet charSet, Token token) {
        return this.createCharClass(charSet, token, false);
    }

    private CharacterClass createCharClass(CharSet charSet, Token token, boolean wasSingleChar) {
        CharacterClass characterClass = this.ast.createCharacterClass(charSet);
        this.ast.addSourceSection(characterClass, token);
        if (wasSingleChar) {
            characterClass.setWasSingleChar();
        }
        return characterClass;
    }

    private void createOptionalBranch(Term term, boolean greedy, boolean copy, int recurse) throws RegexSyntaxException {
        this.addTerm(copy ? this.copyVisitor.copy(term) : term);
        if (this.curTerm instanceof Group) {
            this.curTerm.setEmptyGuard(true);
        }
        this.createOptional(term, greedy, true, recurse - 1);
    }

    private void createOptional(Term term, boolean greedy, boolean copy, int recurse) throws RegexSyntaxException {
        if (recurse < 0) {
            return;
        }
        this.properties.setAlternations();
        this.createGroup(null);
        this.curGroup.setExpandedQuantifier(true);
        if (term instanceof Group) {
            this.curGroup.setEnclosedCaptureGroupsLow(((Group)term).getEnclosedCaptureGroupsLow());
            this.curGroup.setEnclosedCaptureGroupsHigh(((Group)term).getEnclosedCaptureGroupsHigh());
        }
        if (greedy) {
            this.createOptionalBranch(term, greedy, copy, recurse);
            this.addSequence(null);
        } else {
            this.addSequence(null);
            this.createOptionalBranch(term, greedy, copy, recurse);
        }
        this.popGroup(null);
    }

    private void expandQuantifier(Term toExpand) {
        int i;
        assert (toExpand.hasQuantifier());
        Token.Quantifier quantifier = toExpand.getQuantifier();
        assert (quantifier.getMin() <= 40 && quantifier.getMax() <= 40) : toExpand + " in " + this.source;
        toExpand.setQuantifier(null);
        this.curTerm = toExpand;
        this.curSequence = (Sequence)this.curTerm.getParent();
        this.curGroup = this.curSequence.getParent();
        ObjectArrayBuffer buf = this.compilationBuffer.getObjectBuffer1();
        int size = this.curSequence.size();
        for (int i2 = this.curTerm.getSeqIndex() + 1; i2 < size; ++i2) {
            buf.add(this.curSequence.getLastTerm());
            this.curSequence.removeLastTerm();
        }
        if (quantifier.getMin() == 0) {
            this.curSequence.removeLastTerm();
        }
        Term t = this.curTerm;
        for (i = quantifier.getMin(); i > 1; --i) {
            this.addTerm(this.copyVisitor.copy(t));
            if (!(this.curTerm instanceof Group)) continue;
            ((Group)this.curTerm).setExpandedQuantifier(true);
        }
        this.createOptional(t, quantifier.isGreedy(), quantifier.getMin() > 0, quantifier.isInfiniteLoop() ? 0 : quantifier.getMax() - quantifier.getMin() - 1);
        if (quantifier.isInfiniteLoop()) {
            ((Group)this.curTerm).setLoop(true);
        }
        for (i = buf.length() - 1; i >= 0; --i) {
            this.curSequence.add((Term)buf.get(i));
        }
    }

    private boolean curTermIsAnchor(PositionAssertion.Type type) {
        return this.curTerm instanceof PositionAssertion && ((PositionAssertion)this.curTerm).type == type;
    }

    private void substitute(Token token, Group substitution) {
        Group copy = substitution.copy(this.ast, true);
        if (this.options.isDumpAutomata()) {
            this.setSourceSectionVisitor.run(copy, token);
        }
        this.addTerm(copy);
    }

    private Group parse(boolean rootCapture) throws RegexSyntaxException {
        RegexASTRootNode rootParent = this.ast.createRootNode();
        Group root = this.createGroup(null, false, rootCapture, rootParent);
        if (this.options.isDumpAutomata()) {
            this.ast.addSourceSections(root, Arrays.asList(this.ast.getSource().getSource().createSection(0, 1), this.ast.getSource().getSource().createSection(this.ast.getSource().getPattern().length() + 1, 1)));
        }
        while (this.lexer.hasNext()) {
            Token token = this.lexer.next();
            switch (token.kind) {
                case caret: {
                    if (this.flags.isMultiline()) {
                        this.substitute(token, MULTI_LINE_CARET_SUBSTITUTION);
                        this.properties.setAlternations();
                        break;
                    }
                    if (this.curTermIsAnchor(PositionAssertion.Type.CARET)) break;
                    PositionAssertion caret = this.ast.createPositionAssertion(PositionAssertion.Type.CARET);
                    this.ast.addSourceSection(caret, token);
                    this.addTerm(caret);
                    break;
                }
                case dollar: {
                    if (this.flags.isMultiline()) {
                        this.substitute(token, MULTI_LINE_DOLLAR_SUBSTITUTION);
                        this.properties.setAlternations();
                        break;
                    }
                    if (this.curTermIsAnchor(PositionAssertion.Type.DOLLAR)) break;
                    PositionAssertion dollar = this.ast.createPositionAssertion(PositionAssertion.Type.DOLLAR);
                    this.ast.addSourceSection(dollar, token);
                    this.addTerm(dollar);
                    break;
                }
                case wordBoundary: {
                    if (this.flags.isUnicode() && this.flags.isIgnoreCase()) {
                        this.substitute(token, UNICODE_IGNORE_CASE_WORD_BOUNDARY_SUBSTITUTION);
                    } else {
                        this.substitute(token, WORD_BOUNDARY_SUBSTITUTION);
                    }
                    this.properties.setAlternations();
                    break;
                }
                case nonWordBoundary: {
                    if (this.flags.isUnicode() && this.flags.isIgnoreCase()) {
                        this.substitute(token, UNICODE_IGNORE_CASE_NON_WORD_BOUNDARY_SUBSTITUTION);
                    } else {
                        this.substitute(token, NON_WORD_BOUNDARY_SUBSTITUTION);
                    }
                    this.properties.setAlternations();
                    break;
                }
                case backReference: {
                    BackReference backReference = this.ast.createBackReference(((Token.BackReference)token).getGroupNr());
                    this.ast.addSourceSection(backReference, token);
                    this.addTerm(backReference);
                    break;
                }
                case quantifier: {
                    this.parseQuantifier((Token.Quantifier)token);
                    break;
                }
                case alternation: {
                    if (this.tryMergeSingleCharClassAlternations()) break;
                    this.addSequence(token);
                    this.properties.setAlternations();
                    break;
                }
                case captureGroupBegin: {
                    this.properties.setCaptureGroups();
                    this.createCaptureGroup(token);
                    break;
                }
                case nonCaptureGroupBegin: {
                    this.createGroup(token);
                    break;
                }
                case lookAheadAssertionBegin: {
                    this.addLookAheadAssertion(token, ((Token.LookAheadAssertionBegin)token).isNegated());
                    break;
                }
                case lookBehindAssertionBegin: {
                    this.addLookBehindAssertion(token, ((Token.LookBehindAssertionBegin)token).isNegated());
                    break;
                }
                case groupEnd: {
                    if (this.tryMergeSingleCharClassAlternations()) {
                        this.curGroup.removeLastSequence();
                        this.ast.getNodeCount().dec();
                    }
                    this.optimizeGroup();
                    this.popGroup(token);
                    break;
                }
                case charClass: {
                    this.addCharClass((Token.CharacterClass)token);
                }
            }
        }
        if (this.curGroup != root) {
            throw this.syntaxError("Unterminated group");
        }
        this.optimizeGroup();
        root.setEnclosedCaptureGroupsHigh(this.groupCount.getCount());
        return root;
    }

    private void optimizeGroup() {
        RegexParser.sortAlternatives(this.curGroup);
        this.mergeCommonPrefixes(this.curGroup);
        this.singleCharNegativeLookAroundToPositive(this.curGroup);
    }

    private void parseQuantifier(Token.Quantifier quantifier) throws RegexSyntaxException {
        Term prev;
        if (this.curTerm == null) {
            throw this.syntaxError("Quantifier without target");
        }
        if (this.flags.isUnicode() && this.curTerm instanceof LookAheadAssertion) {
            throw this.syntaxError("Quantifier on lookahead assertion");
        }
        if (this.curTerm instanceof LookBehindAssertion) {
            throw this.syntaxError("Quantifier on lookbehind assertion");
        }
        assert (this.curTerm == this.curSequence.getLastTerm());
        if (quantifier.getMin() == -1) {
            this.replaceCurTermWithDeadNode();
            return;
        }
        if (quantifier.getMax() == 0 || quantifier.getMin() == 0 && (this.curTerm instanceof LookAroundAssertion || this.curTerm instanceof CharacterClass && ((CharacterClass)this.curTerm).getCharSet().matchesNothing())) {
            this.removeCurTerm();
            return;
        }
        this.ast.addSourceSection(this.curTerm, quantifier);
        if (this.curTerm instanceof LookAroundAssertion) {
            return;
        }
        if (quantifier.getMin() == 1 && quantifier.getMax() == 1) {
            return;
        }
        this.setQuantifier(this.curTerm, quantifier);
        if (this.curSequence.size() > 1 && (prev = this.curSequence.getTerms().get(this.curSequence.size() - 2)).hasQuantifier() && this.curTerm.equalsSemantic(prev, true)) {
            long max;
            this.removeCurTerm();
            long min = (long)prev.getQuantifier().getMin() + (long)quantifier.getMin();
            long l = max = prev.getQuantifier().isInfiniteLoop() || quantifier.isInfiniteLoop() ? -1L : (long)prev.getQuantifier().getMax() + (long)quantifier.getMax();
            if (min > Integer.MAX_VALUE) {
                this.replaceCurTermWithDeadNode();
                return;
            }
            if (max > Integer.MAX_VALUE) {
                max = -1L;
            }
            this.setQuantifier(prev, new Token.Quantifier((int)min, (int)max, prev.getQuantifier().isGreedy() || quantifier.isGreedy()));
        }
    }

    private void removeCurTerm() {
        this.deleteVisitor.run(this.curSequence.getLastTerm());
        this.curSequence.removeLastTerm();
        if (!this.curSequence.isEmpty()) {
            this.curTerm = this.curSequence.getLastTerm();
        }
    }

    private void replaceCurTermWithDeadNode() {
        this.removeCurTerm();
        this.addTerm(this.createCharClass(CharSet.getEmpty(), null));
    }

    private void setQuantifier(Term term, Token.Quantifier quantifier) {
        if (quantifier.getMin() > 40 || quantifier.getMax() > 40) {
            this.properties.setLargeCountedRepetitions();
        }
        term.setQuantifier(quantifier);
        this.properties.setQuantifiers();
        if (quantifier.getMin() != quantifier.getMax()) {
            this.properties.setAlternations();
        }
    }

    private boolean tryMergeSingleCharClassAlternations() {
        if (this.curGroup.size() > 1 && this.curSequence.isSingleCharClass()) {
            assert (this.curSequence == this.curGroup.getAlternatives().get(this.curGroup.size() - 1));
            Sequence prevSequence = this.curGroup.getAlternatives().get(this.curGroup.size() - 2);
            if (prevSequence.isSingleCharClass()) {
                this.mergeCharClasses((CharacterClass)prevSequence.getFirstTerm(), (CharacterClass)this.curSequence.getFirstTerm());
                this.curSequence.removeLastTerm();
                this.ast.getNodeCount().dec();
                return true;
            }
        }
        return false;
    }

    private void mergeCharClasses(CharacterClass dst, CharacterClass src) {
        dst.setCharSet(dst.getCharSet().union(src.getCharSet()));
        dst.setWasSingleChar(false);
        this.ast.addSourceSections(dst, this.ast.getSourceSections(src));
    }

    private static void sortAlternatives(Group group) {
        if (group.size() < 2) {
            return;
        }
        int begin = 0;
        while (begin + 1 < group.size()) {
            int end = RegexParser.findSingleCharAlternatives(group, begin);
            if (end > begin + 1) {
                group.getAlternatives().subList(begin, end).sort((a, b) -> ((CharacterClass)a.getFirstTerm()).getCharSet().getLo(0) - ((CharacterClass)b.getFirstTerm()).getCharSet().getLo(0));
                begin = end;
                continue;
            }
            ++begin;
        }
    }

    private void mergeCommonPrefixes(Group group) {
        if (group.size() < 2) {
            return;
        }
        ArrayList<Sequence> newAlternatives = null;
        int lastEnd = 0;
        int begin = 0;
        while (begin + 1 < group.size()) {
            int end = RegexParser.findMatchingAlternatives(group, begin);
            if (end < 0) {
                ++begin;
                continue;
            }
            if (newAlternatives == null) {
                newAlternatives = new ArrayList<Sequence>();
            }
            for (int i = lastEnd; i < begin; ++i) {
                newAlternatives.add(group.getAlternatives().get(i));
            }
            lastEnd = end;
            int prefixSize = 1;
            while (RegexParser.alternativesAreEqualAt(group, begin, end, prefixSize)) {
                ++prefixSize;
            }
            Sequence prefixSeq = this.ast.createSequence();
            Group innerGroup = this.ast.createGroup();
            int enclosedCGLo = Integer.MAX_VALUE;
            int enclosedCGHi = Integer.MIN_VALUE;
            boolean emptyAlt = false;
            for (int i = begin; i < end; ++i) {
                Sequence s = group.getAlternatives().get(i);
                assert (s.size() >= prefixSize);
                for (int j = 0; j < prefixSize; ++j) {
                    Term t = s.getTerms().get(j);
                    if (i == begin) {
                        prefixSeq.add(t);
                        continue;
                    }
                    this.ast.addSourceSections(prefixSeq.getTerms().get(j), this.ast.getSourceSections(t));
                    this.deleteVisitor.run(t);
                }
                if (i > begin && s.size() - prefixSize == 1 && s.getLastTerm() instanceof CharacterClass && !s.getLastTerm().hasQuantifier() && innerGroup.getLastAlternative().isSingleCharClass()) {
                    this.mergeCharClasses((CharacterClass)innerGroup.getLastAlternative().getFirstTerm(), (CharacterClass)s.getLastTerm());
                    continue;
                }
                if (prefixSize == s.size()) {
                    if (!emptyAlt) {
                        innerGroup.addSequence(this.ast);
                    }
                    emptyAlt = true;
                    continue;
                }
                Sequence copy = innerGroup.addSequence(this.ast);
                for (int j = prefixSize; j < s.size(); ++j) {
                    Term t = s.getTerms().get(j);
                    copy.add(t);
                    if (!(t instanceof Group)) continue;
                    Group g = (Group)t;
                    if (g.getEnclosedCaptureGroupsLow() != g.getEnclosedCaptureGroupsHigh()) {
                        enclosedCGLo = Math.min(enclosedCGLo, g.getEnclosedCaptureGroupsLow());
                        enclosedCGHi = Math.max(enclosedCGHi, g.getEnclosedCaptureGroupsHigh());
                    }
                    if (!g.isCapturing()) continue;
                    enclosedCGLo = Math.min(enclosedCGLo, g.getGroupNumber());
                    enclosedCGHi = Math.max(enclosedCGHi, g.getGroupNumber() + 1);
                }
            }
            if (enclosedCGLo != Integer.MAX_VALUE) {
                innerGroup.setEnclosedCaptureGroupsLow(enclosedCGLo);
                innerGroup.setEnclosedCaptureGroupsHigh(enclosedCGHi);
            }
            if (!(innerGroup.isEmpty() || innerGroup.size() == 1 && innerGroup.getAlternatives().get(0).isEmpty())) {
                this.mergeCommonPrefixes(innerGroup);
                prefixSeq.add(innerGroup);
            }
            newAlternatives.add(prefixSeq);
            begin = end;
        }
        if (newAlternatives != null) {
            for (int i = lastEnd; i < group.size(); ++i) {
                newAlternatives.add(group.getAlternatives().get(i));
            }
            group.setAlternatives(newAlternatives);
        }
    }

    private static boolean alternativesAreEqualAt(Group group, int altBegin, int altEnd, int iTerm) {
        if (group.getAlternatives().get(altBegin).size() <= iTerm) {
            return false;
        }
        Term cmp = group.getAlternatives().get(altBegin).getTerms().get(iTerm);
        for (int i = altBegin + 1; i < altEnd; ++i) {
            Sequence s = group.getAlternatives().get(i);
            if (s.size() <= iTerm) {
                return false;
            }
            if (s.getTerms().get(iTerm).equalsSemantic(cmp)) continue;
            return false;
        }
        return true;
    }

    private static int findMatchingAlternatives(Group group, int begin) {
        if (group.getAlternatives().get(begin).isEmpty()) {
            return -1;
        }
        Term cmp = group.getAlternatives().get(begin).getFirstTerm();
        int ret = -1;
        for (int i = begin + 1; i < group.size(); ++i) {
            Sequence s = group.getAlternatives().get(i);
            if (s.isEmpty() || !cmp.equalsSemantic(s.getFirstTerm())) {
                return ret;
            }
            ret = i + 1;
        }
        return ret;
    }

    private static int findSingleCharAlternatives(Group group, int begin) {
        int ret = -1;
        for (int i = begin; i < group.size(); ++i) {
            Sequence s = group.getAlternatives().get(i);
            if (s.isEmpty() || !(s.getFirstTerm() instanceof CharacterClass) || !((CharacterClass)s.getFirstTerm()).wasSingleChar()) {
                return ret;
            }
            ret = i + 1;
        }
        return ret;
    }

    private void singleCharNegativeLookAroundToPositive(Group group) {
        if (group.getParent() instanceof LookAroundAssertion && ((LookAroundAssertion)group.getParent()).isNegated() && group.size() == 1 && group.getAlternatives().get(0).isSingleCharClass()) {
            this.ast.invertNegativeLookAround((LookAroundAssertion)group.getParent());
            CharacterClass cc = (CharacterClass)group.getAlternatives().get(0).getFirstTerm();
            cc.setCharSet(cc.getCharSet().createInverse());
            Sequence empty = this.ast.createSequence();
            if (group.getParent() instanceof LookAheadAssertion) {
                empty.add(this.ast.createPositionAssertion(PositionAssertion.Type.DOLLAR));
                this.properties.setComplexLookAheadAssertions();
            } else {
                empty.add(this.ast.createPositionAssertion(PositionAssertion.Type.CARET));
                this.properties.setComplexLookBehindAssertions();
            }
            group.add(empty);
        }
    }

    private RegexSyntaxException syntaxError(String msg) {
        return new RegexSyntaxException(this.source, msg);
    }

    static {
        String wordBoundarySrc = "(?:^|(?<=\\W))(?=\\w)|(?<=\\w)(?:(?=\\W)|$)";
        String nonWordBoundarySrc = "(?:^|(?<=\\W))(?:(?=\\W)|$)|(?<=\\w)(?=\\w)";
        WORD_BOUNDARY_SUBSTITUTION = RegexParser.parseRootLess("(?:^|(?<=\\W))(?=\\w)|(?<=\\w)(?:(?=\\W)|$)");
        NON_WORD_BOUNDARY_SUBSTITUTION = RegexParser.parseRootLess("(?:^|(?<=\\W))(?:(?=\\W)|$)|(?<=\\w)(?=\\w)");
        Function<String, String> includeExtraCases = s -> s.replace("\\w", "[\\w\\u017F\\u212A]").replace("\\W", "[^\\w\\u017F\\u212A]");
        UNICODE_IGNORE_CASE_WORD_BOUNDARY_SUBSTITUTION = RegexParser.parseRootLess(includeExtraCases.apply("(?:^|(?<=\\W))(?=\\w)|(?<=\\w)(?:(?=\\W)|$)"));
        UNICODE_IGNORE_CASE_NON_WORD_BOUNDARY_SUBSTITUTION = RegexParser.parseRootLess(includeExtraCases.apply("(?:^|(?<=\\W))(?:(?=\\W)|$)|(?<=\\w)(?=\\w)"));
        MULTI_LINE_CARET_SUBSTITUTION = RegexParser.parseRootLess("(?:^|(?<=[\\r\\n\\u2028\\u2029]))");
        MULTI_LINE_DOLLAR_SUBSTITUTION = RegexParser.parseRootLess("(?:$|(?=[\\r\\n\\u2028\\u2029]))");
        NO_LEAD_SURROGATE_BEHIND = RegexParser.parseRootLess("(?:^|(?<=[^\\uD800-\\uDBFF]))");
        NO_TRAIL_SURROGATE_AHEAD = RegexParser.parseRootLess("(?:$|(?=[^\\uDC00-\\uDFFF]))");
    }

    private static final class UnrollQuantifiersVisitor
    extends DepthFirstTraversalRegexASTVisitor {
        private final RegexParser parser;

        private UnrollQuantifiersVisitor(RegexParser parser) {
            this.parser = parser;
        }

        public static void unrollQuantifiers(RegexParser parser, RegexASTNode runRoot) {
            new UnrollQuantifiersVisitor(parser).run(runRoot);
        }

        @Override
        protected void visit(CharacterClass characterClass) {
            this.expand(characterClass);
        }

        @Override
        protected void leave(Group group) {
            this.expand(group);
        }

        private void expand(Term t) {
            if (t.hasQuantifier()) {
                this.parser.expandQuantifier(t);
            }
        }
    }
}

